/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remote;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.remote.FileFolderRemote;
import org.alfresco.service.cmr.remote.LoaderRemote;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoaderRemoteServer
implements LoaderRemote {
    private static Log logger = LogFactory.getLog(LoaderRemoteServer.class);
    private static final QName ASSOC_WORKING_ROOT = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"LoaderServiceWorkingRoot");
    private RetryingTransactionHelper retryingTransactionHelper;
    private AuthenticationService authenticationService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private FileFolderRemote fileFolderRemote;
    private CheckOutCheckInService checkOutCheckInService;

    public void setTransactionService(TransactionService transactionService) {
        this.retryingTransactionHelper = transactionService.getRetryingTransactionHelper();
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setFileFolderRemote(FileFolderRemote fileFolderRemote) {
        this.fileFolderRemote = fileFolderRemote;
    }

    @Deprecated
    public void setMimetypeService(MimetypeService mimetypeService) {
    }

    public void setCheckOutCheckInService(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String authenticate(String username, String password) {
        String string;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.authenticate(username, password.toCharArray());
            String ticket = this.authenticationService.getCurrentTicket();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authenticated: " + username));
            }
            string = ticket;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef getOrCreateWorkingRoot(String ticket, final StoreRef storeRef) {
        NodeRef nodeRef;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Throwable {
                    NodeRef rootNodeRef = null;
                    if (!LoaderRemoteServer.this.nodeService.exists(storeRef)) {
                        LoaderRemoteServer.this.nodeService.createStore(storeRef.getProtocol(), storeRef.getIdentifier());
                    }
                    rootNodeRef = LoaderRemoteServer.this.nodeService.getRootNode(storeRef);
                    List assocRefs = LoaderRemoteServer.this.nodeService.getChildAssocs(rootNodeRef, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)ASSOC_WORKING_ROOT);
                    NodeRef workingRootNodeRef = null;
                    if (assocRefs.size() > 0) {
                        workingRootNodeRef = ((ChildAssociationRef)assocRefs.get(0)).getChildRef();
                    } else {
                        String username = LoaderRemoteServer.this.authenticationService.getCurrentUserName();
                        LoaderRemoteServer.this.nodeService.setProperty(rootNodeRef, ContentModel.PROP_AUTHOR, (Serializable)((Object)username));
                        PropertyMap properties = new PropertyMap();
                        properties.put(ContentModel.PROP_NAME, "Loader Application Root");
                        workingRootNodeRef = LoaderRemoteServer.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ASSOC_WORKING_ROOT, ContentModel.TYPE_FOLDER, (Map)properties).getChildRef();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Got working root node: " + workingRootNodeRef));
                    }
                    return workingRootNodeRef;
                }
            };
            nodeRef = this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return nodeRef;
    }

    @Override
    public int getNodeCount(String ticket) {
        throw new UnsupportedOperationException("getNodeCount cannot be accurately determined at low cost.");
    }

    @Override
    public int getNodeCount(String ticket, StoreRef storeRef) {
        throw new UnsupportedOperationException("getNodeCount cannot be accurately determined at low cost.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileInfo[] uploadContent(String ticket, final NodeRef folderNodeRef, final String[] filenames, final byte[][] bytes) {
        FileInfo[] fileInfoArray;
        if (filenames.length < bytes.length) {
            throw new IllegalArgumentException("The number of files must match the number of binary byte arrays given.");
        }
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<FileInfo[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo[]>(){

                @Override
                public FileInfo[] execute() throws Throwable {
                    FileInfo[] results = new FileInfo[filenames.length];
                    for (int i = 0; i < filenames.length; ++i) {
                        FileInfo newFileInfo;
                        results[i] = newFileInfo = LoaderRemoteServer.this.fileFolderService.create(folderNodeRef, filenames[i], ContentModel.TYPE_CONTENT);
                        NodeRef newFileNodeRef = newFileInfo.getNodeRef();
                        ContentWriter writer = LoaderRemoteServer.this.fileFolderService.getWriter(newFileNodeRef);
                        writer.guessMimetype(filenames[i]);
                        writer.guessEncoding();
                        ByteArrayInputStream is = new ByteArrayInputStream(bytes[i]);
                        writer.putContent((InputStream)is);
                    }
                    return results;
                }
            };
            fileInfoArray = this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return fileInfoArray;
    }

    @Override
    public void coci(String ticket, NodeRef[] nodeRef, byte[][] bytes, List<HashMap<String, Serializable>> versionProperties) {
        FileInfo[] workingCopy = this.checkout(ticket, nodeRef);
        String[] fna = new String[bytes.length];
        for (int i = 0; i < workingCopy.length; ++i) {
            fna[i] = workingCopy[i].getName();
            versionProperties.add(new HashMap());
        }
        this.fileFolderRemote.putContent(ticket, this.getNodesRef(workingCopy), bytes, fna);
        this.checkin(ticket, this.getNodesRef(workingCopy), versionProperties);
    }

    NodeRef[] getNodesRef(FileInfo[] filesInfoList) {
        NodeRef[] nr = new NodeRef[filesInfoList.length];
        for (int i = 0; i < filesInfoList.length; ++i) {
            nr[i] = filesInfoList[i].getNodeRef();
        }
        return nr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRef checkout(String ticket, final NodeRef nodeRef) {
        NodeRef nodeRef2;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Throwable {
                    return LoaderRemoteServer.this.checkOutCheckInService.checkout(nodeRef);
                }
            };
            nodeRef2 = this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return nodeRef2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileInfo[] checkout(String ticket, final NodeRef[] nodeRef) {
        FileInfo[] fileInfoArray;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<FileInfo[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo[]>(){

                @Override
                public FileInfo[] execute() throws Throwable {
                    FileInfo[] arr = new FileInfo[nodeRef.length];
                    for (int i = 0; i < nodeRef.length; ++i) {
                        arr[i] = LoaderRemoteServer.this.fileFolderService.getFileInfo(LoaderRemoteServer.this.checkOutCheckInService.checkout(nodeRef[i]));
                    }
                    return arr;
                }
            };
            fileInfoArray = this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return fileInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRef checkin(String ticket, final NodeRef workingCopyNodeRef, final Map<String, Serializable> versionProperties) {
        NodeRef nodeRef;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Throwable {
                    return LoaderRemoteServer.this.checkOutCheckInService.checkin(workingCopyNodeRef, versionProperties);
                }
            };
            nodeRef = this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return nodeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef[] checkin(String ticket, final NodeRef[] workingCopyNodeRef, final List<HashMap<String, Serializable>> versionProperties) {
        NodeRef[] nodeRefArray;
        AuthenticationUtil.pushAuthentication();
        try {
            this.authenticationService.validate(ticket);
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef[]> callback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef[]>(){

                @Override
                public NodeRef[] execute() throws Throwable {
                    NodeRef[] nr = new NodeRef[workingCopyNodeRef.length];
                    for (int i = 0; i < workingCopyNodeRef.length; ++i) {
                        nr[i] = LoaderRemoteServer.this.checkOutCheckInService.checkin(workingCopyNodeRef[i], (Map)versionProperties.get(i));
                    }
                    return nr;
                }
            };
            nodeRefArray = this.retryingTransactionHelper.doInTransaction(callback, false, true);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return nodeRefArray;
    }
}

