/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenditionServicePermissionsTest
extends BaseAlfrescoSpringTest {
    private static Log logger = LogFactory.getLog(RenditionServicePermissionsTest.class);
    private static final QName RESCALE_RENDER_DEFN_NAME = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("imageRenderingEngine" + System.currentTimeMillis()));
    private NodeRef nodeWithImageContent;
    private NodeRef testFolder;
    private PermissionService permissionService;
    private PersonService personService;
    private RenditionService renditionService;
    private Repository repositoryHelper;
    private RetryingTransactionHelper transactionHelper;
    private String testFolderName;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.permissionService = (PermissionService)this.applicationContext.getBean("PermissionService");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.renditionService = (RenditionService)this.applicationContext.getBean("renditionService");
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.transactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        NodeRef companyHome = this.repositoryHelper.getCompanyHome();
        this.testFolderName = "Test-folder-" + System.currentTimeMillis();
        this.testFolder = this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)this.testFolderName), ContentModel.TYPE_FOLDER).getChildRef();
        this.nodeService.setProperty(this.testFolder, ContentModel.PROP_NAME, (Serializable)((Object)this.testFolderName));
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, "Test-image-node-" + System.currentTimeMillis());
        String testImageNodeName = "testImageNode" + System.currentTimeMillis();
        this.nodeWithImageContent = this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)testImageNodeName), ContentModel.TYPE_CONTENT, props).getChildRef();
        URL url = RenditionServicePermissionsTest.class.getClassLoader().getResource("images/gray21.512.png");
        RenditionServicePermissionsTest.assertNotNull((String)"url of test image was null", (Object)url);
        File imageFile = new File(url.getFile());
        RenditionServicePermissionsTest.assertTrue((boolean)imageFile.exists());
        this.nodeService.setProperty(this.nodeWithImageContent, ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "image/png", 0L, null));
        ContentWriter writer = this.contentService.getWriter(this.nodeWithImageContent, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("image/png");
        writer.setEncoding("UTF-8");
        writer.putContent(imageFile);
    }

    protected void onTearDownInTransaction() throws Exception {
        this.nodeService.deleteNode(this.nodeWithImageContent);
        this.nodeService.deleteNode(this.testFolder);
    }

    public void testRenditionAccessPermissions() throws Exception {
        this.setComplete();
        this.endTransaction();
        String normalUser = "renditionUser";
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                Assert.assertEquals((String)"admin", (String)RenditionServicePermissionsTest.this.authenticationService.getCurrentUserName());
                if (!RenditionServicePermissionsTest.this.authenticationService.authenticationExists("renditionUser")) {
                    RenditionServicePermissionsTest.this.authenticationService.createAuthentication("renditionUser", "PWD".toCharArray());
                    PropertyMap personProperties = new PropertyMap();
                    personProperties.put(ContentModel.PROP_USERNAME, "renditionUser");
                    personProperties.put(ContentModel.PROP_AUTHORITY_DISPLAY_NAME, "titlerenditionUser");
                    personProperties.put(ContentModel.PROP_FIRSTNAME, "firstName");
                    personProperties.put(ContentModel.PROP_LASTNAME, "lastName");
                    personProperties.put(ContentModel.PROP_EMAIL, "email@email.com");
                    personProperties.put(ContentModel.PROP_JOBTITLE, "jobTitle");
                    RenditionServicePermissionsTest.this.personService.createPerson(personProperties);
                }
                RenditionServicePermissionsTest.this.permissionService.setPermission(RenditionServicePermissionsTest.this.testFolder, "renditionUser", "Consumer", true);
                return null;
            }
        });
        final NodeRef rendition = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)"renditionUser");
                Assert.assertEquals((String)"renditionUser", (String)RenditionServicePermissionsTest.this.authenticationService.getCurrentUserName());
                Assert.assertFalse((String)"Source node has unexpected renditioned aspect.", (boolean)RenditionServicePermissionsTest.this.nodeService.hasAspect(RenditionServicePermissionsTest.this.nodeWithImageContent, RenditionModel.ASPECT_RENDITIONED));
                String path = RenditionServicePermissionsTest.this.testFolderName + "/testRendition.png";
                RenditionDefinition action = RenditionServicePermissionsTest.this.makeRescaleImageAction();
                action.setParameterValue("destination-path-template", (Serializable)((Object)path));
                logger.debug((Object)("Creating rendition of: " + RenditionServicePermissionsTest.this.nodeWithImageContent));
                ChildAssociationRef renditionAssoc = RenditionServicePermissionsTest.this.renditionService.render(RenditionServicePermissionsTest.this.nodeWithImageContent, action);
                logger.debug((Object)("Created rendition: " + renditionAssoc.getChildRef()));
                NodeRef renditionNode = renditionAssoc.getChildRef();
                Assert.assertEquals((String)"The parent node was not correct", (Object)RenditionServicePermissionsTest.this.nodeWithImageContent, (Object)renditionAssoc.getParentRef());
                logger.debug((Object)("rendition's primary parent: " + RenditionServicePermissionsTest.this.nodeService.getPrimaryParent(renditionNode)));
                Assert.assertEquals((String)"The parent node was not correct", (Object)RenditionServicePermissionsTest.this.testFolder, (Object)RenditionServicePermissionsTest.this.nodeService.getPrimaryParent(renditionNode).getParentRef());
                Assert.assertTrue((String)"Source node is missing renditioned aspect.", (boolean)RenditionServicePermissionsTest.this.nodeService.hasAspect(RenditionServicePermissionsTest.this.nodeWithImageContent, RenditionModel.ASPECT_RENDITIONED));
                return renditionNode;
            }
        });
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                Serializable renditionCreator = RenditionServicePermissionsTest.this.nodeService.getProperty(rendition, ContentModel.PROP_CREATOR);
                Assert.assertEquals((String)"Incorrect creator", (Object)"renditionUser", (Object)renditionCreator);
                return null;
            }
        });
    }

    private RenditionDefinition makeRescaleImageAction() {
        RenditionDefinition result = this.renditionService.createRenditionDefinition(RESCALE_RENDER_DEFN_NAME, "imageRenderingEngine");
        result.setParameterValue("xsize", Integer.valueOf(42));
        return result;
    }
}

