/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NoTransformerException;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTransformationRenderingEngine
extends AbstractRenderingEngine {
    private static Log logger = LogFactory.getLog(AbstractTransformationRenderingEngine.class);
    public static final String PARAM_TIMEOUT_MS = "timeoutMs";
    public static final String PARAM_READ_LIMIT_TIME_MS = "readLimitTimeMs";
    public static final String PARAM_MAX_SOURCE_SIZE_K_BYTES = "maxSourceSizeKBytes";
    public static final String PARAM_READ_LIMIT_K_BYTES = "readLimitKBytes";
    public static final String PARAM_MAX_PAGES = "maxPages";
    public static final String PARAM_PAGE_LIMIT = "pageLimit";
    private static final String TRANSFORMER_NOT_EXISTS_MESSAGE_PATTERN = "Transformer for '%s' source mime type and '%s' target mime type was not found. Operation can't be performed";
    private static final String NOT_TRANSFORMABLE_MESSAGE_PATTERN = "Content not transformable for '%s' source mime type and '%s' target mime type. Operation can't be performed";
    private static final String TRANSFORMING_ERROR_MESSAGE = "Some error occurred during document transforming. Error message: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void render(AbstractRenderingEngine.RenderingContext context) {
        ContentTransformer transformer;
        ContentReader contentReader = context.makeContentReader();
        String sourceUrl = contentReader.getContentUrl();
        String sourceMimeType = contentReader.getMimetype();
        String targetMimeType = this.getTargetMimeType(context);
        TransformationOptions options = this.getTransformOptions(context);
        boolean orig = TransformerDebug.setDebugOutput(false);
        try {
            transformer = this.contentService.getTransformer(sourceUrl, sourceMimeType, contentReader.getSize(), targetMimeType, options);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            TransformerDebug.setDebugOutput(orig);
            throw throwable;
        }
        TransformerDebug.setDebugOutput(orig);
        if (null == transformer) {
            throw new RenditionServiceException(String.format(TRANSFORMER_NOT_EXISTS_MESSAGE_PATTERN, sourceMimeType, targetMimeType));
        }
        if (transformer.isTransformable(sourceMimeType, contentReader.getSize(), targetMimeType, options)) {
            ContentWriter contentWriter = context.makeContentWriter();
            try {
                this.contentService.transform(contentReader, contentWriter, options);
            }
            catch (NoTransformerException ntx) {
                logger.debug((Object)("No transformer found to execute rule: \n   reader: " + contentReader + "\n" + "   writer: " + contentWriter + "\n" + "   action: " + this));
                throw new RenditionServiceException(TRANSFORMING_ERROR_MESSAGE + ntx.getMessage(), (Throwable)((Object)ntx));
            }
        } else {
            throw new RenditionServiceException(String.format(NOT_TRANSFORMABLE_MESSAGE_PATTERN, sourceMimeType, targetMimeType));
        }
    }

    protected abstract TransformationOptions getTransformOptions(AbstractRenderingEngine.RenderingContext var1);

    protected TransformationOptions getTransformOptionsImpl(TransformationOptions options, AbstractRenderingEngine.RenderingContext context) {
        Integer pageLimit;
        Integer maxPages;
        Long readLimitKBytes;
        Long maxSourceSizeKBytes;
        Long readLimitTimeMs;
        Long timeoutMs = context.getCheckedParam(PARAM_TIMEOUT_MS, Long.class);
        if (timeoutMs != null) {
            options.setTimeoutMs(timeoutMs);
        }
        if ((readLimitTimeMs = context.getCheckedParam(PARAM_READ_LIMIT_TIME_MS, Long.class)) != null) {
            options.setReadLimitTimeMs(readLimitTimeMs);
        }
        if ((maxSourceSizeKBytes = context.getCheckedParam(PARAM_MAX_SOURCE_SIZE_K_BYTES, Long.class)) != null) {
            options.setMaxSourceSizeKBytes(maxSourceSizeKBytes);
        }
        if ((readLimitKBytes = context.getCheckedParam(PARAM_READ_LIMIT_K_BYTES, Long.class)) != null) {
            options.setReadLimitKBytes(readLimitKBytes);
        }
        if ((maxPages = context.getCheckedParam(PARAM_MAX_PAGES, Integer.class)) != null) {
            options.setMaxPages(maxPages);
        }
        if ((pageLimit = context.getCheckedParam(PARAM_PAGE_LIMIT, Integer.class)) != null) {
            options.setPageLimit(pageLimit);
        }
        return options;
    }
}

