/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteRenditionActionExecuter
extends ActionExecuterAbstractBase {
    private static Log log = LogFactory.getLog(DeleteRenditionActionExecuter.class);
    public static final String NAME = "delete-rendition";
    public static final String PARAM_RENDITION_DEFINITION_NAME = "rendition-definition-name";
    private NodeService nodeService;
    private RenditionService renditionService;
    private BehaviourFilter behaviourFilter;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        Map<String, Serializable> paramValues;
        QName renditionDefName;
        ChildAssociationRef existingRendition;
        boolean nodeExists = this.nodeService.exists(actionedUponNodeRef);
        if (nodeExists && (existingRendition = this.renditionService.getRenditionByName(actionedUponNodeRef, renditionDefName = (QName)(paramValues = action.getParameterValues()).get(PARAM_RENDITION_DEFINITION_NAME))) != null) {
            if (log.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Deleting rendition node: ").append(existingRendition);
                log.debug((Object)msg.toString());
            }
            this.behaviourFilter.disableBehaviour(actionedUponNodeRef, ContentModel.ASPECT_AUDITABLE);
            try {
                this.nodeService.deleteNode(existingRendition.getChildRef());
                Object var9_8 = null;
                this.behaviourFilter.enableBehaviour(actionedUponNodeRef, ContentModel.ASPECT_AUDITABLE);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.behaviourFilter.enableBehaviour(actionedUponNodeRef, ContentModel.ASPECT_AUDITABLE);
                throw throwable;
            }
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_RENDITION_DEFINITION_NAME, DataTypeDefinition.QNAME, true, this.getParamDisplayLabel(PARAM_RENDITION_DEFINITION_NAME), false));
    }
}

