/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OnContentUpdateRuleTrigger
extends RuleTriggerAbstractBase
implements ContentServicePolicies.OnContentUpdatePolicy {
    private static Log logger = LogFactory.getLog(OnContentUpdateRuleTrigger.class);
    private boolean onNewContent = false;
    private boolean triggerParentRules = true;

    public void setOnNewContent(boolean onNewContent) {
        this.onNewContent = onNewContent;
    }

    public void setTriggerParentRules(boolean triggerParentRules) {
        this.triggerParentRules = triggerParentRules;
    }

    public void registerRuleTrigger() {
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onContentUpdate"));
    }

    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        if (!this.areRulesEnabled()) {
            return;
        }
        boolean fail = false;
        if (newContent) {
            ContentData contentData;
            boolean editInline;
            Boolean value = (Boolean)this.nodeService.getProperty(nodeRef, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"editInline"));
            if (value != null && (editInline = value.booleanValue())) {
                fail = true;
            }
            if (!fail && ((contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT)) == null || this.isZeroLengthOfficeDoc(contentData))) {
                fail = true;
            }
        }
        if (!fail && !newContent) {
            Set newNodeRefSet = TransactionalResourceHelper.getSet("RuleTrigger.NewNodes");
            boolean wasCreatedInTxn = newNodeRefSet.contains(nodeRef);
            if (logger.isDebugEnabled() && wasCreatedInTxn) {
                logger.debug((Object)("Receiving content property update for node created in transaction: " + nodeRef));
            }
            fail = wasCreatedInTxn;
        }
        if (!fail && newContent == this.onNewContent) {
            if (this.triggerParentRules) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("OnContentUpdate rule triggered fired for content; nodeId=" + nodeRef.getId() + "; newContent=" + newContent));
                }
                List parentsAssocRefs = this.nodeService.getParentAssocs(nodeRef);
                for (ChildAssociationRef parentAssocRef : parentsAssocRefs) {
                    this.triggerRules(parentAssocRef.getParentRef(), nodeRef);
                }
            } else {
                this.triggerRules(nodeRef, nodeRef);
            }
        }
    }

    private boolean isZeroLengthOfficeDoc(ContentData contentData) {
        boolean result = false;
        if (contentData.getSize() == 0L && ("application/msword".equals(contentData.getMimetype()) || "application/vnd.ms-excel".equals(contentData.getMimetype()) || "application/vnd.ms-powerpoint".equals(contentData.getMimetype()))) {
            result = true;
        }
        return result;
    }
}

