/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.search.CannedQueryDef;
import org.alfresco.repo.search.CannedQueryDefImpl;
import org.alfresco.repo.search.QueryCollection;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.dom4j.Element;
import org.dom4j.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryCollectionImpl
implements QueryCollection {
    private static final org.dom4j.QName ELEMENT_QNAME = new org.dom4j.QName("query-register", new Namespace("alf", "http://www.alfresco.org"));
    private static final org.dom4j.QName NAME = new org.dom4j.QName("name", new Namespace("alf", "http://www.alfresco.org"));
    private static final org.dom4j.QName NAMESPACES = new org.dom4j.QName("namespaces", new Namespace("alf", "http://www.alfresco.org"));
    private static final org.dom4j.QName NAMESPACE = new org.dom4j.QName("namespace", new Namespace("alf", "http://www.alfresco.org"));
    private static final org.dom4j.QName PREFIX = new org.dom4j.QName("prefix", new Namespace("alf", "http://www.alfresco.org"));
    private static final org.dom4j.QName URI = new org.dom4j.QName("uri", new Namespace("alf", "http://www.alfresco.org"));
    private String name;
    private Map<QName, QueryParameterDefinition> parameters = new HashMap<QName, QueryParameterDefinition>();
    private Map<QName, CannedQueryDef> queries = new HashMap<QName, CannedQueryDef>();
    NamespacePrefixResolver namespacePrefixResolver;

    public QueryCollectionImpl(String name, Map<QName, QueryParameterDefinition> parameters, NamespacePrefixResolver namespacePrefixResolver) {
        this.name = name;
        this.parameters = parameters;
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean containsQueryDefinition(QName qName) {
        return this.queries.containsKey(qName);
    }

    private void addQueryDefinition(CannedQueryDef queryDefinition) {
        this.queries.put(queryDefinition.getQname(), queryDefinition);
    }

    @Override
    public CannedQueryDef getQueryDefinition(QName qName) {
        return this.queries.get(qName);
    }

    @Override
    public boolean containsParameterDefinition(QName qName) {
        return this.parameters.containsKey(qName);
    }

    @Override
    public QueryParameterDefinition getParameterDefinition(QName qName) {
        return this.parameters.get(qName);
    }

    @Override
    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.namespacePrefixResolver;
    }

    public static QueryCollection createQueryCollection(Element element, DictionaryService dictionaryService, NamespacePrefixResolver nspr) {
        DynamicNamespacePrefixResolver dnpr = new DynamicNamespacePrefixResolver(nspr);
        if (element.getName().equals(ELEMENT_QNAME.getName())) {
            Element nameSpaces;
            String name = null;
            Element nameElement = element.element(NAME.getName());
            if (nameElement != null) {
                name = nameElement.getText();
            }
            if ((nameSpaces = element.element(NAMESPACES.getName())) != null) {
                List ns = nameSpaces.elements(NAMESPACE.getName());
                for (Element nsElement : ns) {
                    Element prefixElement = nsElement.element(PREFIX.getName());
                    Element uriElement = nsElement.element(URI.getName());
                    if (prefixElement == null || nsElement == null) continue;
                    dnpr.registerNamespace(prefixElement.getText(), uriElement.getText());
                }
            }
            HashMap<QName, QueryParameterDefinition> parameters = new HashMap<QName, QueryParameterDefinition>();
            List list = element.elements(QueryParameterDefImpl.getElementQName().getName());
            for (Element defElement : list) {
                QueryParameterDefinition paramDef = QueryParameterDefImpl.createParameterDefinition(defElement, dictionaryService, nspr);
                parameters.put(paramDef.getQName(), paramDef);
            }
            QueryCollectionImpl collection = new QueryCollectionImpl(name, parameters, (NamespacePrefixResolver)dnpr);
            list = element.elements(CannedQueryDefImpl.getElementQName().getName());
            for (Element defElement : list) {
                CannedQueryDefImpl queryDef = CannedQueryDefImpl.createCannedQuery(defElement, dictionaryService, collection, nspr);
                collection.addQueryDefinition(queryDef);
            }
            return collection;
        }
        return null;
    }
}

