/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.impl.lucene.ClosingIndexSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneAnalyser;
import org.alfresco.repo.search.impl.lucene.LuceneConfig;
import org.alfresco.repo.search.impl.lucene.LuceneIndexException;
import org.alfresco.repo.search.impl.lucene.LuceneIndexer;
import org.alfresco.repo.search.impl.lucene.index.IndexInfo;
import org.alfresco.repo.search.impl.lucene.index.TransactionStatus;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLuceneBase {
    private static Log s_logger = LogFactory.getLog(AbstractLuceneBase.class);
    private IndexInfo indexInfo;
    protected StoreRef store;
    protected String deltaId;
    private LuceneConfig config;
    private TransactionStatus status = TransactionStatus.UNKNOWN;
    private DictionaryService dictionaryService;

    protected void initialise(StoreRef store, String deltaId) throws LuceneIndexException {
        this.store = store;
        this.deltaId = deltaId;
        String basePath = this.getBasePath();
        File baseDir = new File(basePath);
        this.indexInfo = IndexInfo.getIndexInfo(baseDir, this.config);
        try {
            if (this.deltaId != null) {
                if (!this.getStatus().equals((Object)TransactionStatus.ACTIVE)) {
                    this.setStatus(TransactionStatus.ACTIVE);
                } else if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Delta already set as active " + deltaId));
                }
            }
        }
        catch (IOException e) {
            throw new IndexerException("Failed to set delta as active");
        }
    }

    private String getBasePath() {
        if (this.config.getIndexRootLocation() == null) {
            throw new IndexerException("No configuration for index location");
        }
        String basePath = this.config.getIndexRootLocation() + File.separator + this.store.getProtocol() + File.separator + this.store.getIdentifier() + File.separator;
        return basePath;
    }

    protected IndexSearcher getSearcher() throws LuceneIndexException {
        try {
            return new ClosingIndexSearcher(this.indexInfo.getMainIndexReferenceCountingReadOnlyIndexReader());
        }
        catch (IOException e) {
            s_logger.error((Object)"Error", (Throwable)e);
            throw new LuceneIndexException("Failed to open IndexSarcher for " + this.getBasePath(), e);
        }
    }

    protected ClosingIndexSearcher getSearcher(LuceneIndexer luceneIndexer) throws LuceneIndexException {
        try {
            if (luceneIndexer == null) {
                return new ClosingIndexSearcher(this.indexInfo.getMainIndexReferenceCountingReadOnlyIndexReader());
            }
            luceneIndexer.flushPending();
            return new ClosingIndexSearcher(this.indexInfo.getMainIndexReferenceCountingReadOnlyIndexReader(this.deltaId, luceneIndexer.getDeletions(), luceneIndexer.getContainerDeletions(), luceneIndexer.getDeleteOnlyNodes()));
        }
        catch (IOException e) {
            s_logger.error((Object)"Error", (Throwable)e);
            throw new LuceneIndexException("Failed to open IndexSarcher for " + this.getBasePath(), e);
        }
    }

    protected IndexReader getDeltaReader() throws LuceneIndexException, IOException {
        return this.indexInfo.getDeltaIndexReader(this.deltaId);
    }

    protected void closeDeltaReader() throws LuceneIndexException, IOException {
        this.indexInfo.closeDeltaIndexReader(this.deltaId);
    }

    protected IndexWriter getDeltaWriter() throws LuceneIndexException, IOException {
        return this.indexInfo.getDeltaIndexWriter(this.deltaId, (Analyzer)new LuceneAnalyser(this.dictionaryService, this.config.getDefaultMLIndexAnalysisMode()));
    }

    protected void closeDeltaWriter() throws LuceneIndexException, IOException {
        this.indexInfo.closeDeltaIndexWriter(this.deltaId);
    }

    protected void saveDelta() throws LuceneIndexException, IOException {
        this.closeDeltaReader();
        this.closeDeltaWriter();
    }

    protected void setInfo(long docs, Set<String> deletions, Set<String> containerDeletions, boolean deleteNodesOnly) throws IOException {
        this.indexInfo.setPreparedState(this.deltaId, deletions, containerDeletions, docs, deleteNodesOnly);
    }

    protected void setStatus(TransactionStatus status) throws IOException {
        this.indexInfo.setStatus(this.deltaId, status, null, null);
        this.status = status;
    }

    protected TransactionStatus getStatus() {
        return this.status;
    }

    protected IndexReader getReader() throws LuceneIndexException, IOException {
        return this.indexInfo.getMainIndexReferenceCountingReadOnlyIndexReader();
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setLuceneConfig(LuceneConfig config) {
        this.config = config;
    }

    public LuceneConfig getLuceneConfig() {
        return this.config;
    }

    public String getDeltaId() {
        return this.deltaId;
    }

    public <R> R doReadOnly(IndexInfo.LockWork<R> lockWork) {
        return this.indexInfo.doReadOnly(lockWork);
    }

    public void deleteIndex() {
        this.indexInfo.delete(this.deltaId);
    }
}

