/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.alfresco.repo.node.NodeBulkLoader;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneBase;
import org.alfresco.repo.search.impl.lucene.LuceneIndexException;
import org.alfresco.repo.search.impl.lucene.index.TransactionStatus;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.springframework.dao.ConcurrencyFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLuceneIndexerImpl<T>
extends AbstractLuceneBase
implements Indexer {
    protected long docs;
    private boolean isReadThrough;
    protected TransactionService transactionService;
    protected NodeBulkLoader bulkLoader;
    public static final String NOT_INDEXED_NO_TRANSFORMATION = "nint";
    public static final String NOT_INDEXED_TRANSFORMATION_FAILED = "nitf";
    public static final String NOT_INDEXED_CONTENT_MISSING = "nicm";
    public static final String NOT_INDEXED_NO_TYPE_CONVERSION = "nintc";
    private static Log s_logger = LogFactory.getLog(AbstractLuceneIndexerImpl.class);
    protected long maxAtomicTransformationTime = 20L;
    protected Set<String> deletions = new LinkedHashSet<String>();
    protected Set<String> containerDeletions = new LinkedHashSet<String>();
    protected List<Command<T>> commandList = new ArrayList<Command<T>>(10000);
    protected IndexUpdateStatus indexUpdateStatus = IndexUpdateStatus.UNMODIFIED;

    @Override
    public void setReadThrough(boolean isReadThrough) {
        this.isReadThrough = isReadThrough;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setBulkLoader(NodeBulkLoader bulkLoader) {
        this.bulkLoader = bulkLoader;
    }

    protected static Set<String> deletePrimary(Collection<String> nodeRefs, IndexReader reader, boolean delete) throws LuceneIndexException {
        LinkedHashSet<String> refs = new LinkedHashSet<String>();
        for (String nodeRef : nodeRefs) {
            try {
                TermDocs td = reader.termDocs(new Term("PRIMARYPARENT", nodeRef));
                while (td.next()) {
                    int doc = td.doc();
                    Document document = reader.document(doc);
                    String[] ids = document.getValues("ID");
                    refs.add(ids[ids.length - 1]);
                    if (!delete) continue;
                    reader.deleteDocument(doc);
                }
                td.close();
            }
            catch (IOException e) {
                throw new LuceneIndexException("Failed to delete node by primary parent for " + nodeRef, e);
            }
        }
        return refs;
    }

    protected static Set<String> deleteReference(Collection<String> nodeRefs, IndexReader reader, boolean delete) throws LuceneIndexException {
        LinkedHashSet<String> refs = new LinkedHashSet<String>();
        for (String nodeRef : nodeRefs) {
            try {
                TermDocs td = reader.termDocs(new Term("PARENT", nodeRef));
                while (td.next()) {
                    int doc = td.doc();
                    Document document = reader.document(doc);
                    String[] ids = document.getValues("ID");
                    refs.add(ids[ids.length - 1]);
                    if (!delete) continue;
                    reader.deleteDocument(doc);
                }
                td.close();
            }
            catch (IOException e) {
                throw new LuceneIndexException("Failed to delete node by parent for " + nodeRef, e);
            }
        }
        return refs;
    }

    protected static Set<String> deleteContainerAndBelow(String nodeRef, IndexReader reader, boolean delete, boolean cascade) throws LuceneIndexException {
        LinkedHashSet<String> refs = new LinkedHashSet<String>();
        try {
            if (delete) {
                reader.deleteDocuments(new Term("ID", nodeRef));
            }
            refs.add(nodeRef);
            if (cascade) {
                TermDocs td = reader.termDocs(new Term("ANCESTOR", nodeRef));
                while (td.next()) {
                    int doc = td.doc();
                    Document document = reader.document(doc);
                    String[] ids = document.getValues("ID");
                    refs.add(ids[ids.length - 1]);
                    if (!delete) continue;
                    reader.deleteDocument(doc);
                }
                td.close();
            }
        }
        catch (IOException e) {
            throw new LuceneIndexException("Failed to delete container and below for " + nodeRef, e);
        }
        return refs;
    }

    protected boolean locateContainer(String nodeRef, IndexReader reader) {
        boolean found = false;
        try {
            TermDocs td = reader.termDocs(new Term("ID", nodeRef));
            while (td.next()) {
                int doc = td.doc();
                Document document = reader.document(doc);
                if (document.getField("ISCONTAINER") == null) continue;
                found = true;
                break;
            }
            td.close();
        }
        catch (IOException e) {
            throw new LuceneIndexException("Failed to delete container and below for " + nodeRef, e);
        }
        return found;
    }

    protected boolean deleteLeafOnly(String nodeRef, IndexReader reader, boolean delete) throws LuceneIndexException {
        boolean found = false;
        try {
            TermDocs td = reader.termDocs(new Term("ID", nodeRef));
            while (td.next()) {
                int doc = td.doc();
                Document document = reader.document(doc);
                Field path = document.getField("PATH");
                if (path != null && path.stringValue().length() != 0) continue;
                found = true;
                if (!delete) break;
                reader.deleteDocument(doc);
            }
            td.close();
        }
        catch (IOException e) {
            throw new LuceneIndexException("Failed to delete container and below for " + nodeRef, e);
        }
        return found;
    }

    public void setMaxAtomicTransformationTime(long maxAtomicTransformationTime) {
        this.maxAtomicTransformationTime = maxAtomicTransformationTime;
    }

    protected void checkAbleToDoWork(IndexUpdateStatus indexUpdateStatus) {
        if (this.indexUpdateStatus != IndexUpdateStatus.UNMODIFIED) {
            if (this.indexUpdateStatus == indexUpdateStatus) {
                return;
            }
            throw new IndexerException("Can not mix FTS and transactional updates");
        }
        this.indexUpdateStatus = indexUpdateStatus;
        switch (this.getStatus()) {
            case UNKNOWN: {
                try {
                    this.setStatus(TransactionStatus.ACTIVE);
                    break;
                }
                catch (IOException e) {
                    throw new LuceneIndexException("Failed to set TX active", e);
                }
            }
            case ACTIVE: {
                break;
            }
            default: {
                throw new IndexerException(this.buildErrorString());
            }
        }
    }

    private String buildErrorString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("The indexer is unable to accept more work: ");
        switch (this.getStatus().getStatus()) {
            case 3: {
                buffer.append("The indexer has been committed");
                break;
            }
            case 8: {
                buffer.append("The indexer is committing");
                break;
            }
            case 1: {
                buffer.append("The indexer is marked for rollback");
                break;
            }
            case 2: {
                buffer.append("The indexer is prepared to commit");
                break;
            }
            case 7: {
                buffer.append("The indexer is preparing to commit");
                break;
            }
            case 4: {
                buffer.append("The indexer has been rolled back");
                break;
            }
            case 9: {
                buffer.append("The indexer is rolling back");
                break;
            }
            case 5: {
                buffer.append("The indexer is in an unknown state");
                break;
            }
        }
        return buffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)(Thread.currentThread().getName() + " Starting Commit"));
        }
        switch (this.getStatus().getStatus()) {
            case 8: {
                throw new LuceneIndexException("Unable to commit: Transaction is committing");
            }
            case 3: {
                throw new LuceneIndexException("Unable to commit: Transaction is commited ");
            }
            case 9: {
                throw new LuceneIndexException("Unable to commit: Transaction is rolling back");
            }
            case 4: {
                throw new LuceneIndexException("Unable to commit: Transaction is aleady rolled back");
            }
            case 1: {
                throw new LuceneIndexException("Unable to commit: Transaction is marked for roll back");
            }
            case 7: {
                throw new LuceneIndexException("Unable to commit: Transaction is preparing");
            }
            case 0: {
                this.prepare();
            }
        }
        if (this.getStatus().getStatus() != 2) {
            throw new LuceneIndexException("Index must be prepared to commit");
        }
        try {
            try {
                this.setStatus(TransactionStatus.COMMITTING);
                if (this.isModified()) {
                    this.doCommit();
                }
                this.setStatus(TransactionStatus.COMMITTED);
            }
            catch (LuceneIndexException e) {
                this.rollback();
                if (!s_logger.isDebugEnabled()) throw new LuceneIndexException("Commit failed", (Throwable)((Object)e));
                s_logger.debug((Object)(Thread.currentThread().getName() + " Commit Failed"), (Throwable)((Object)e));
                throw new LuceneIndexException("Commit failed", (Throwable)((Object)e));
            }
            catch (Throwable t) {
                this.rollback();
                if (!s_logger.isDebugEnabled()) throw new LuceneIndexException("Commit failed", t);
                s_logger.debug((Object)(Thread.currentThread().getName() + " Commit Failed"), t);
                throw new LuceneIndexException("Commit failed", t);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!s_logger.isDebugEnabled()) throw throwable;
            s_logger.debug((Object)(Thread.currentThread().getName() + " Ending Commit"));
            throw throwable;
        }
        if (!s_logger.isDebugEnabled()) return;
        s_logger.debug((Object)(Thread.currentThread().getName() + " Ending Commit"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int prepare() throws LuceneIndexException {
        int n;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)(Thread.currentThread().getName() + " Starting Prepare"));
        }
        switch (this.getStatus().getStatus()) {
            case 8: {
                throw new IndexerException("Unable to prepare: Transaction is committing");
            }
            case 3: {
                throw new IndexerException("Unable to prepare: Transaction is commited ");
            }
            case 9: {
                throw new IndexerException("Unable to prepare: Transaction is rolling back");
            }
            case 4: {
                throw new IndexerException("Unable to prepare: Transaction is aleady rolled back");
            }
            case 1: {
                throw new IndexerException("Unable to prepare: Transaction is marked for roll back");
            }
            case 7: {
                throw new IndexerException("Unable to prepare: Transaction is already preparing");
            }
            case 2: {
                throw new IndexerException("Unable to prepare: Transaction is already prepared");
            }
        }
        try {
            try {
                this.setStatus(TransactionStatus.PREPARING);
                if (this.isModified()) {
                    this.doPrepare();
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)(Thread.currentThread().getName() + " Waiting to Finish Preparing"));
                    }
                }
                this.setStatus(TransactionStatus.PREPARED);
                n = this.isModified() ? 0 : 3;
                Object var3_4 = null;
            }
            catch (LuceneIndexException e) {
                this.setRollbackOnly();
                if (!s_logger.isDebugEnabled()) throw new LuceneIndexException("Index failed to prepare", (Throwable)((Object)e));
                s_logger.debug((Object)(Thread.currentThread().getName() + " Prepare Failed"), (Throwable)((Object)e));
                throw new LuceneIndexException("Index failed to prepare", (Throwable)((Object)e));
            }
            catch (Throwable t) {
                this.rollback();
                if (!s_logger.isDebugEnabled()) throw new LuceneIndexException("Prepared failed", t);
                s_logger.debug((Object)(Thread.currentThread().getName() + " Prepare Failed"), t);
                throw new LuceneIndexException("Prepared failed", t);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (!s_logger.isDebugEnabled()) throw throwable;
            s_logger.debug((Object)(Thread.currentThread().getName() + " Ending Prepare"));
            throw throwable;
        }
        if (!s_logger.isDebugEnabled()) return n;
        s_logger.debug((Object)(Thread.currentThread().getName() + " Ending Prepare"));
        return n;
    }

    public boolean isModified() {
        return this.indexUpdateStatus != IndexUpdateStatus.UNMODIFIED;
    }

    public void rollback() throws LuceneIndexException {
        switch (this.getStatus().getStatus()) {
            case 3: {
                throw new IndexerException("Unable to roll back: Transaction is committed ");
            }
            case 9: {
                throw new IndexerException("Unable to roll back: Transaction is rolling back");
            }
            case 4: {
                throw new IndexerException("Unable to roll back: Transaction is already rolled back");
            }
        }
        try {
            this.setStatus(TransactionStatus.ROLLINGBACK);
            this.doRollBack();
            this.setStatus(TransactionStatus.ROLLEDBACK);
        }
        catch (IOException e) {
            throw new LuceneIndexException("rollback failed ", e);
        }
    }

    public void setRollbackOnly() {
        switch (this.getStatus().getStatus()) {
            case 8: {
                throw new IndexerException("Unable to mark for rollback: Transaction is committing");
            }
            case 3: {
                throw new IndexerException("Unable to mark for rollback: Transaction is committed");
            }
        }
        try {
            this.doSetRollbackOnly();
            this.setStatus(TransactionStatus.MARKED_ROLLBACK);
        }
        catch (IOException e) {
            throw new LuceneIndexException("Set rollback only failed ", e);
        }
    }

    protected abstract void doPrepare() throws IOException;

    protected abstract void doCommit() throws IOException;

    protected abstract void doRollBack() throws IOException;

    protected abstract void doSetRollbackOnly() throws IOException;

    protected <T2> T2 doInReadthroughTransaction(final RetryingTransactionHelper.RetryingTransactionCallback<T2> callback) {
        if (this.isReadThrough) {
            return (T2)this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<T2>(){

                @Override
                public T2 execute() throws Throwable {
                    if (AbstractLuceneIndexerImpl.this.bulkLoader != null) {
                        AbstractLuceneIndexerImpl.this.bulkLoader.setCheckNodeConsistency();
                    }
                    try {
                        return callback.execute();
                    }
                    catch (InvalidNodeRefException e) {
                        throw new ConcurrencyFailureException("Possible cache integrity issue during reindexing", (Throwable)e);
                    }
                }
            }, true, true);
        }
        try {
            return callback.execute();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected void index(T ref) throws LuceneIndexException {
        this.addCommand(new Command<T>(ref, Action.INDEX));
    }

    protected void reindex(T ref, boolean cascadeReindexDirectories) throws LuceneIndexException {
        this.addCommand(new Command<T>(ref, cascadeReindexDirectories ? Action.CASCADEREINDEX : Action.REINDEX));
    }

    protected void delete(T ref) throws LuceneIndexException {
        this.addCommand(new Command<T>(ref, Action.DELETE));
    }

    private void addCommand(Command<T> command) {
        if (this.commandList.size() > 0) {
            Command<T> last = this.commandList.get(this.commandList.size() - 1);
            if (last.action == command.action && last.ref.equals(command.ref)) {
                return;
            }
        }
        this.purgeCommandList(command);
        this.commandList.add(command);
        if (this.commandList.size() > this.getLuceneConfig().getIndexerBatchSize()) {
            this.flushPending();
        }
    }

    private void purgeCommandList(Command<T> command) {
        this.removeFromCommandList(command, command.action != Action.DELETE);
    }

    private void removeFromCommandList(Command<T> command, boolean matchExact) {
        ListIterator<Command<T>> it = this.commandList.listIterator(this.commandList.size());
        while (it.hasPrevious()) {
            Command<T> current = it.previous();
            if (matchExact) {
                if (!current.ref.equals(command.ref)) continue;
                if (current.action == command.action) {
                    it.remove();
                    return;
                }
                if (command.action == Action.DELETE || current.action != Action.INDEX) continue;
                it.remove();
                command.action = Action.INDEX;
                continue;
            }
            if (!current.ref.equals(command.ref)) continue;
            it.remove();
        }
    }

    public Set<String> getDeletions() {
        return Collections.unmodifiableSet(this.deletions);
    }

    public Set<String> getContainerDeletions() {
        return Collections.unmodifiableSet(this.containerDeletions);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Command<S> {
        S ref;
        Action action;

        Command(S ref, Action action) {
            this.ref = ref;
            this.action = action;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            if (this.action == Action.INDEX) {
                buffer.append("Index ");
            } else if (this.action == Action.DELETE) {
                buffer.append("Delete ");
            } else if (this.action == Action.REINDEX) {
                buffer.append("Reindex ");
            } else {
                buffer.append("Unknown ... ");
            }
            buffer.append(this.ref);
            return buffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FTSStatus {
        New,
        Dirty,
        Clean;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum IndexUpdateStatus {
        UNMODIFIED,
        SYNCRONOUS,
        ASYNCHRONOUS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Action {
        INDEX,
        REINDEX,
        DELETE,
        CASCADEREINDEX;

    }
}

