/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import com.werken.saxpath.XPathReader;
import java.io.IOException;
import org.alfresco.repo.search.EmptyResultSet;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.impl.lucene.ADMLuceneSearcherImpl;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryLanguage;
import org.alfresco.repo.search.impl.lucene.ClosingIndexSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneResultSet;
import org.alfresco.repo.search.impl.lucene.LuceneXPathHandler;
import org.alfresco.repo.search.impl.lucene.PagingLuceneResultSet;
import org.alfresco.repo.search.impl.lucene.query.PathQuery;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.saxpath.SAXPathException;
import org.saxpath.XPathHandler;

public class LuceneAlfrescoXPathQueryLanguage
extends AbstractLuceneQueryLanguage {
    public LuceneAlfrescoXPathQueryLanguage() {
        this.setName("xpath");
    }

    public ResultSet executeQuery(SearchParameters searchParameters, ADMLuceneSearcherImpl admLuceneSearcher) {
        try {
            XPathReader reader = new XPathReader();
            LuceneXPathHandler handler = new LuceneXPathHandler();
            handler.setNamespacePrefixResolver(admLuceneSearcher.getNamespacePrefixResolver());
            handler.setDictionaryService(admLuceneSearcher.getDictionaryService());
            reader.setXPathHandler((XPathHandler)handler);
            reader.parse(searchParameters.getQuery());
            PathQuery query = handler.getQuery();
            ClosingIndexSearcher searcher = admLuceneSearcher.getClosingIndexSearcher();
            if (searcher == null) {
                return new EmptyResultSet();
            }
            Hits hits = searcher.search((Query)query);
            Object rs = new LuceneResultSet(hits, (Searcher)searcher, admLuceneSearcher.getNodeService(), admLuceneSearcher.getTenantService(), searchParameters, admLuceneSearcher.getLuceneConfig());
            rs = new PagingLuceneResultSet((ResultSet)rs, searchParameters, admLuceneSearcher.getNodeService());
            return rs;
        }
        catch (SAXPathException e) {
            throw new SearcherException("Failed to parse query: " + searchParameters.getQuery(), e);
        }
        catch (IOException e) {
            throw new SearcherException("IO exception during search", e);
        }
    }
}

