/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.repo.search.impl.lucene.analysis.AlfrescoStandardAnalyser;
import org.alfresco.repo.search.impl.lucene.index.IndexInfo;
import org.alfresco.repo.search.impl.lucene.index.TransactionStatus;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

public class IndexInfoTest
extends TestCase {
    public static final String[] WORD_LIST = new String[]{"aardvark", "banana", "cucumber", "daffodil", "emu", "frog", "gibbon", "humour", "injection", "jelly", "key", "lemur", "monkey", "number", "open", "plummet", "quest", "replication", "steam", "tunnel", "uncommon", "verbose", "where", "xylem", "yellow", "zebra", "alpha", "bravo", "charlie", "delta", "echo", "foxtrot", "golf", "hotel", "indigo", "juliet", "kilo", "lima", "mike", "november", "oscar", "papa", "quebec", "romeo", "sierra", "tango", "uniform", "victor", "whisky", "xray", "yankee", "zulu"};
    public static final String[] CREATE_LIST = new String[]{"aardvark", "banana", "cucumber", "daffodil", "emu", "frog", "gibbon", "humour", "injection", "jelly", "key", "lemur", "monkey", "number", "open", "plummet", "quest", "replication", "steam", "tunnel", "uncommon", "verbose", "where", "xylem", "yellow", "zebra"};
    public static final String[] UPDATE_LIST = new String[]{"alpha", "bravo", "charlie", "delta", "echo", "foxtrot", "golf", "hotel", "indigo", "juliet", "kilo", "lima", "mike", "november", "oscar", "papa", "quebec", "romeo", "sierra", "tango", "uniform", "victor", "whisky", "xray", "yankee", "zulu"};
    public static final String[] CREATE_LIST_2 = new String[]{"aardvark2", "banana2", "cucumber2", "daffodil2", "emu2", "frog2", "gibbon2", "humour2", "injection2", "jelly2", "key2", "lemur2", "monkey2", "number2", "open2", "plummet2", "quest2", "replication2", "steam2", "tunnel2", "uncommon2", "verbose2", "where2", "xylem2", "yellow2", "zebra2"};
    public static final String[] UPDATE_LIST_2 = new String[]{"alpha2", "bravo2", "charlie2", "delta2", "echo2", "foxtrot2", "golf2", "hotel2", "indigo2", "juliet2", "kilo2", "lima2", "mike2", "november2", "oscar2", "papa2", "quebec2", "romeo2", "sierra2", "tango2", "uniform2", "victor2", "whisky2", "xray2", "yankee2", "zulu2"};

    public IndexInfoTest() {
    }

    public IndexInfoTest(String arg0) {
        super(arg0);
    }

    public void testCreateAndSearch() throws IOException {
        System.setProperty("disableLuceneLocks", "true");
        HashSet<String> deletions = new HashSet<String>();
        for (int i = 0; i < 0; ++i) {
            deletions.add(new NodeRef(new StoreRef("woof", "bingle"), GUID.generate()).toString());
        }
        File tempLocation = TempFileProvider.getTempDir();
        File testArea = new File(tempLocation, "IndexInfoTest");
        File testDir = new File(testArea, "" + System.currentTimeMillis());
        IndexInfo ii = IndexInfo.getIndexInfo(testDir, null);
        for (int i = 0; i < WORD_LIST.length; ++i) {
            TermDocs tds;
            int j;
            IndexReader reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)i);
            reader.close();
            String guid = GUID.generate();
            ii.setStatus(guid, TransactionStatus.ACTIVE, null, null);
            IndexWriter writer = ii.getDeltaIndexWriter(guid, (Analyzer)new AlfrescoStandardAnalyser());
            Document doc = new Document();
            for (int k = 0; k < 15; ++k) {
                doc.add((Fieldable)new Field("ID" + k, guid, Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            }
            doc.add((Fieldable)new Field("TEXT", WORD_LIST[i], Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            writer.addDocument(doc);
            ii.closeDeltaIndexWriter(guid);
            ii.setStatus(guid, TransactionStatus.PREPARING, null, null);
            ii.setPreparedState(guid, deletions, Collections.<String>emptySet(), 1L, false);
            ii.getDeletions(guid);
            ii.setStatus(guid, TransactionStatus.PREPARED, null, null);
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)i);
            for (j = 0; j < WORD_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", WORD_LIST[j]));
                if (j < i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertEquals((int)tds.doc(), (int)j);
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader(guid, deletions, Collections.<String>emptySet(), false);
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)(i + 1));
            for (j = 0; j < WORD_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", WORD_LIST[j]));
                if (j <= i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertEquals((int)tds.doc(), (int)j);
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
            ii.setStatus(guid, TransactionStatus.COMMITTING, null, null);
            ii.setStatus(guid, TransactionStatus.COMMITTED, null, null);
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)(i + 1));
            for (j = 0; j < WORD_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", WORD_LIST[j]));
                if (j <= i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertEquals((int)tds.doc(), (int)j);
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
        }
    }

    public void testCreateDeleteAndSearch() throws IOException {
        int i;
        IndexInfoTest.assertEquals((int)CREATE_LIST.length, (int)UPDATE_LIST.length);
        StoreRef storeRef = new StoreRef("woof", "bingle");
        System.setProperty("disableLuceneLocks", "true");
        ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>();
        File tempLocation = TempFileProvider.getTempDir();
        File testArea = new File(tempLocation, "IndexInfoTest");
        File testDir = new File(testArea, "" + System.currentTimeMillis());
        IndexInfo ii = IndexInfo.getIndexInfo(testDir, null);
        for (i = 0; i < CREATE_LIST.length; ++i) {
            TermDocs tds;
            int j;
            IndexReader reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)i);
            reader.close();
            String guid = GUID.generate();
            ii.setStatus(guid, TransactionStatus.ACTIVE, null, null);
            IndexWriter writer = ii.getDeltaIndexWriter(guid, (Analyzer)new AlfrescoStandardAnalyser());
            Document doc = new Document();
            for (int k = 0; k < 15; ++k) {
                doc.add((Fieldable)new Field("ID" + k, guid, Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            }
            doc.add((Fieldable)new Field("TEXT", CREATE_LIST[i], Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            NodeRef nodeRef = new NodeRef(storeRef, GUID.generate());
            nodeRefs.add(nodeRef);
            doc.add((Fieldable)new Field("ID", nodeRef.toString(), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            writer.addDocument(doc);
            ii.closeDeltaIndexWriter(guid);
            ii.setStatus(guid, TransactionStatus.PREPARING, null, null);
            ii.setPreparedState(guid, Collections.<String>emptySet(), Collections.<String>emptySet(), 1L, false);
            ii.getDeletions(guid);
            ii.setStatus(guid, TransactionStatus.PREPARED, null, null);
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)i);
            for (j = 0; j < CREATE_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", CREATE_LIST[j]));
                if (j < i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertEquals((int)tds.doc(), (int)j);
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader(guid, Collections.<String>emptySet(), Collections.<String>emptySet(), false);
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)(i + 1));
            for (j = 0; j < CREATE_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", CREATE_LIST[j]));
                if (j <= i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertEquals((int)tds.doc(), (int)j);
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
            ii.setStatus(guid, TransactionStatus.COMMITTING, null, null);
            ii.setStatus(guid, TransactionStatus.COMMITTED, null, null);
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)(i + 1));
            for (j = 0; j < CREATE_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", CREATE_LIST[j]));
                if (j <= i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertEquals((int)tds.doc(), (int)j);
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
        }
        for (i = 0; i < CREATE_LIST.length; ++i) {
            int j;
            HashSet<String> deletions = new HashSet<String>();
            deletions.add(((NodeRef)nodeRefs.get(i)).toString());
            IndexReader reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)(CREATE_LIST.length - i));
            reader.close();
            String guid = GUID.generate();
            ii.setStatus(guid, TransactionStatus.ACTIVE, null, null);
            ii.closeDeltaIndexWriter(guid);
            ii.setStatus(guid, TransactionStatus.PREPARING, null, null);
            ii.setPreparedState(guid, deletions, Collections.<String>emptySet(), 1L, false);
            ii.getDeletions(guid);
            ii.setStatus(guid, TransactionStatus.PREPARED, null, null);
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)(CREATE_LIST.length - i));
            int lastDoc = -1;
            for (j = 0; j < CREATE_LIST.length; ++j) {
                TermDocs tds = reader.termDocs(new Term("TEXT", CREATE_LIST[j]));
                if (j >= i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                    lastDoc = tds.doc();
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader(guid, deletions, Collections.<String>emptySet(), false);
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)(UPDATE_LIST.length - i - 1));
            lastDoc = -1;
            for (j = 0; j < CREATE_LIST.length; ++j) {
                TermDocs tds = reader.termDocs(new Term("TEXT", CREATE_LIST[j]));
                if (j > i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                    lastDoc = tds.doc();
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
            ii.setStatus(guid, TransactionStatus.COMMITTING, null, null);
            ii.setStatus(guid, TransactionStatus.COMMITTED, null, null);
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)(UPDATE_LIST.length - i - 1));
            lastDoc = -1;
            for (j = 0; j < CREATE_LIST.length; ++j) {
                TermDocs tds = reader.termDocs(new Term("TEXT", CREATE_LIST[j]));
                if (j > i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                    lastDoc = tds.doc();
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
            IndexReader reader1 = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexReader reader2 = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexReader reader3 = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            reader3.close();
            reader2.close();
            reader1.close();
        }
    }

    public void testCreateUpdateAndSearch() throws IOException {
        int i;
        IndexInfoTest.assertEquals((int)CREATE_LIST.length, (int)UPDATE_LIST.length);
        StoreRef storeRef = new StoreRef("woof", "bingle");
        System.setProperty("disableLuceneLocks", "true");
        ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>();
        File tempLocation = TempFileProvider.getTempDir();
        File testArea = new File(tempLocation, "IndexInfoTest");
        File testDir = new File(testArea, "" + System.currentTimeMillis());
        IndexInfo ii = IndexInfo.getIndexInfo(testDir, null);
        for (i = 0; i < CREATE_LIST.length; ++i) {
            TermDocs tds;
            int j;
            IndexReader reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)i);
            reader.close();
            String guid = GUID.generate();
            ii.setStatus(guid, TransactionStatus.ACTIVE, null, null);
            IndexWriter writer = ii.getDeltaIndexWriter(guid, (Analyzer)new AlfrescoStandardAnalyser());
            Document doc = new Document();
            for (int k = 0; k < 15; ++k) {
                doc.add((Fieldable)new Field("ID" + k, guid, Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            }
            doc.add((Fieldable)new Field("TEXT", CREATE_LIST[i], Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            NodeRef nodeRef = new NodeRef(storeRef, GUID.generate());
            nodeRefs.add(nodeRef);
            doc.add((Fieldable)new Field("ID", nodeRef.toString(), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            writer.addDocument(doc);
            ii.closeDeltaIndexWriter(guid);
            ii.setStatus(guid, TransactionStatus.PREPARING, null, null);
            ii.setPreparedState(guid, Collections.<String>emptySet(), Collections.<String>emptySet(), 1L, false);
            ii.getDeletions(guid);
            ii.setStatus(guid, TransactionStatus.PREPARED, null, null);
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)i);
            for (j = 0; j < CREATE_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", CREATE_LIST[j]));
                if (j < i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertEquals((int)tds.doc(), (int)j);
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader(guid, Collections.<String>emptySet(), Collections.<String>emptySet(), false);
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)(i + 1));
            for (j = 0; j < CREATE_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", CREATE_LIST[j]));
                if (j <= i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertEquals((int)tds.doc(), (int)j);
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
            ii.setStatus(guid, TransactionStatus.COMMITTING, null, null);
            ii.setStatus(guid, TransactionStatus.COMMITTED, null, null);
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)(i + 1));
            for (j = 0; j < CREATE_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", CREATE_LIST[j]));
                if (j <= i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertEquals((int)tds.doc(), (int)j);
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
        }
        for (i = 0; i < UPDATE_LIST.length; ++i) {
            TermDocs tds;
            int j;
            HashSet<String> deletions = new HashSet<String>();
            deletions.add(((NodeRef)nodeRefs.get(i)).toString());
            IndexReader reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)UPDATE_LIST.length);
            reader.close();
            String guid = GUID.generate();
            ii.setStatus(guid, TransactionStatus.ACTIVE, null, null);
            IndexWriter writer = ii.getDeltaIndexWriter(guid, (Analyzer)new AlfrescoStandardAnalyser());
            Document doc = new Document();
            for (int k = 0; k < 15; ++k) {
                doc.add((Fieldable)new Field("ID" + k, guid, Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            }
            doc.add((Fieldable)new Field("TEXT", UPDATE_LIST[i], Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            writer.addDocument(doc);
            ii.closeDeltaIndexWriter(guid);
            ii.setStatus(guid, TransactionStatus.PREPARING, null, null);
            ii.setPreparedState(guid, deletions, Collections.<String>emptySet(), 1L, false);
            ii.getDeletions(guid);
            ii.setStatus(guid, TransactionStatus.PREPARED, null, null);
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)UPDATE_LIST.length);
            int lastDoc = -1;
            for (j = 0; j < CREATE_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", CREATE_LIST[j]));
                if (j >= i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                    lastDoc = tds.doc();
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            for (j = 0; j < UPDATE_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", UPDATE_LIST[j]));
                if (j < i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                    lastDoc = tds.doc();
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader(guid, deletions, Collections.<String>emptySet(), false);
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)UPDATE_LIST.length);
            lastDoc = -1;
            for (j = 0; j < CREATE_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", CREATE_LIST[j]));
                if (j > i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                    lastDoc = tds.doc();
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            for (j = 0; j < UPDATE_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", UPDATE_LIST[j]));
                if (j <= i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                    lastDoc = tds.doc();
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
            ii.setStatus(guid, TransactionStatus.COMMITTING, null, null);
            ii.setStatus(guid, TransactionStatus.COMMITTED, null, null);
            reader = ii.getMainIndexReferenceCountingReadOnlyIndexReader();
            IndexInfoTest.assertEquals((int)reader.numDocs(), (int)UPDATE_LIST.length);
            lastDoc = -1;
            for (j = 0; j < CREATE_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", CREATE_LIST[j]));
                if (j > i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                    lastDoc = tds.doc();
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            for (j = 0; j < UPDATE_LIST.length; ++j) {
                tds = reader.termDocs(new Term("TEXT", UPDATE_LIST[j]));
                if (j <= i) {
                    IndexInfoTest.assertTrue((boolean)tds.next());
                    IndexInfoTest.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                    lastDoc = tds.doc();
                } else {
                    IndexInfoTest.assertFalse((boolean)tds.next());
                }
                tds.close();
            }
            reader.close();
        }
    }

    public void testMultiThreadedCreateAndSearch() {
        System.setProperty("disableLuceneLocks", "true");
        File tempLocation = TempFileProvider.getTempDir();
        File testArea = new File(tempLocation, "IndexInfoTest");
        File testDir = new File(testArea, "" + System.currentTimeMillis());
        IndexInfo ii = IndexInfo.getIndexInfo(testDir, null);
        Thread thread1 = new Thread(new Test(ii, CREATE_LIST, UPDATE_LIST));
        Thread thread2 = new Thread(new Test(ii, CREATE_LIST_2, UPDATE_LIST_2));
        thread1.start();
        thread2.start();
        try {
            thread1.join();
            thread2.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static class Test
    implements Runnable {
        String[] create;
        String[] update;
        IndexInfo ii;

        Test(IndexInfo ii, String[] create, String[] update) {
            this.ii = ii;
            this.create = create;
            this.update = update;
        }

        public void run() {
            try {
                TermDocs tds;
                int j;
                int lastDoc;
                int i;
                Assert.assertEquals((int)this.create.length, (int)this.update.length);
                StoreRef storeRef = new StoreRef("woof", "bingle");
                ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>();
                for (i = 0; i < this.create.length; ++i) {
                    IndexReader reader = this.ii.getMainIndexReferenceCountingReadOnlyIndexReader();
                    reader.close();
                    String guid = GUID.generate();
                    this.ii.setStatus(guid, TransactionStatus.ACTIVE, null, null);
                    IndexWriter writer = this.ii.getDeltaIndexWriter(guid, (Analyzer)new AlfrescoStandardAnalyser());
                    Document doc = new Document();
                    for (int k = 0; k < 15; ++k) {
                        doc.add((Fieldable)new Field("ID" + k, guid, Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                    }
                    doc.add((Fieldable)new Field("TEXT", this.create[i], Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                    NodeRef nodeRef = new NodeRef(storeRef, GUID.generate());
                    nodeRefs.add(nodeRef);
                    doc.add((Fieldable)new Field("ID", nodeRef.toString(), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                    writer.addDocument(doc);
                    this.ii.closeDeltaIndexWriter(guid);
                    this.ii.setStatus(guid, TransactionStatus.PREPARING, null, null);
                    this.ii.setPreparedState(guid, Collections.<String>emptySet(), Collections.<String>emptySet(), 1L, false);
                    this.ii.getDeletions(guid);
                    this.ii.setStatus(guid, TransactionStatus.PREPARED, null, null);
                    reader = this.ii.getMainIndexReferenceCountingReadOnlyIndexReader();
                    lastDoc = -1;
                    for (j = 0; j < this.create.length; ++j) {
                        tds = reader.termDocs(new Term("TEXT", this.create[j]));
                        if (j < i) {
                            Assert.assertTrue((boolean)tds.next());
                            Assert.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                            lastDoc = tds.doc();
                        } else {
                            Assert.assertFalse((boolean)tds.next());
                        }
                        tds.close();
                    }
                    reader.close();
                    reader = this.ii.getMainIndexReferenceCountingReadOnlyIndexReader(guid, Collections.<String>emptySet(), Collections.<String>emptySet(), false);
                    lastDoc = -1;
                    for (j = 0; j < this.create.length; ++j) {
                        tds = reader.termDocs(new Term("TEXT", this.create[j]));
                        if (j <= i) {
                            Assert.assertTrue((boolean)tds.next());
                            Assert.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                            lastDoc = tds.doc();
                        } else {
                            Assert.assertFalse((boolean)tds.next());
                        }
                        tds.close();
                    }
                    reader.close();
                    this.ii.setStatus(guid, TransactionStatus.COMMITTING, null, null);
                    this.ii.setStatus(guid, TransactionStatus.COMMITTED, null, null);
                    reader = this.ii.getMainIndexReferenceCountingReadOnlyIndexReader();
                    lastDoc = -1;
                    for (j = 0; j < this.create.length; ++j) {
                        tds = reader.termDocs(new Term("TEXT", this.create[j]));
                        if (j <= i) {
                            Assert.assertTrue((boolean)tds.next());
                            Assert.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                            lastDoc = tds.doc();
                        } else {
                            Assert.assertFalse((boolean)tds.next());
                        }
                        tds.close();
                    }
                    reader.close();
                }
                for (i = 0; i < this.update.length; ++i) {
                    HashSet<String> deletions = new HashSet<String>();
                    deletions.add(((NodeRef)nodeRefs.get(i)).toString());
                    IndexReader reader = this.ii.getMainIndexReferenceCountingReadOnlyIndexReader();
                    reader.close();
                    String guid = GUID.generate();
                    this.ii.setStatus(guid, TransactionStatus.ACTIVE, null, null);
                    IndexWriter writer = this.ii.getDeltaIndexWriter(guid, (Analyzer)new AlfrescoStandardAnalyser());
                    Document doc = new Document();
                    for (int k = 0; k < 15; ++k) {
                        doc.add((Fieldable)new Field("ID" + k, guid, Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                    }
                    doc.add((Fieldable)new Field("TEXT", this.update[i], Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                    writer.addDocument(doc);
                    this.ii.closeDeltaIndexWriter(guid);
                    this.ii.setStatus(guid, TransactionStatus.PREPARING, null, null);
                    this.ii.setPreparedState(guid, deletions, Collections.<String>emptySet(), 1L, false);
                    this.ii.getDeletions(guid);
                    this.ii.setStatus(guid, TransactionStatus.PREPARED, null, null);
                    reader = this.ii.getMainIndexReferenceCountingReadOnlyIndexReader();
                    lastDoc = -1;
                    for (j = 0; j < this.create.length; ++j) {
                        tds = reader.termDocs(new Term("TEXT", this.create[j]));
                        if (j >= i) {
                            Assert.assertTrue((boolean)tds.next());
                            Assert.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                            lastDoc = tds.doc();
                        } else {
                            Assert.assertFalse((boolean)tds.next());
                        }
                        tds.close();
                    }
                    for (j = 0; j < this.update.length; ++j) {
                        tds = reader.termDocs(new Term("TEXT", this.update[j]));
                        if (j < i) {
                            Assert.assertTrue((boolean)tds.next());
                            Assert.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                            lastDoc = tds.doc();
                        } else {
                            Assert.assertFalse((boolean)tds.next());
                        }
                        tds.close();
                    }
                    reader.close();
                    reader = this.ii.getMainIndexReferenceCountingReadOnlyIndexReader(guid, deletions, Collections.<String>emptySet(), false);
                    lastDoc = -1;
                    for (j = 0; j < this.create.length; ++j) {
                        tds = reader.termDocs(new Term("TEXT", this.create[j]));
                        if (j > i) {
                            Assert.assertTrue((boolean)tds.next());
                            Assert.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                            lastDoc = tds.doc();
                        } else {
                            Assert.assertFalse((boolean)tds.next());
                        }
                        tds.close();
                    }
                    for (j = 0; j < this.update.length; ++j) {
                        tds = reader.termDocs(new Term("TEXT", this.update[j]));
                        if (j <= i) {
                            Assert.assertTrue((boolean)tds.next());
                            Assert.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                            lastDoc = tds.doc();
                        } else {
                            Assert.assertFalse((boolean)tds.next());
                        }
                        tds.close();
                    }
                    reader.close();
                    this.ii.setStatus(guid, TransactionStatus.COMMITTING, null, null);
                    this.ii.setStatus(guid, TransactionStatus.COMMITTED, null, null);
                    reader = this.ii.getMainIndexReferenceCountingReadOnlyIndexReader();
                    lastDoc = -1;
                    for (j = 0; j < this.create.length; ++j) {
                        tds = reader.termDocs(new Term("TEXT", this.create[j]));
                        if (j > i) {
                            Assert.assertTrue((boolean)tds.next());
                            Assert.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                            lastDoc = tds.doc();
                        } else {
                            Assert.assertFalse((boolean)tds.next());
                        }
                        tds.close();
                    }
                    for (j = 0; j < this.update.length; ++j) {
                        tds = reader.termDocs(new Term("TEXT", this.update[j]));
                        if (j <= i) {
                            Assert.assertTrue((boolean)tds.next());
                            Assert.assertTrue((tds.doc() > lastDoc ? 1 : 0) != 0);
                            lastDoc = tds.doc();
                        } else {
                            Assert.assertFalse((boolean)tds.next());
                        }
                        tds.close();
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                System.exit(-1);
            }
        }
    }
}

