/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.alfresco.httpclient.HttpClientFactory;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParserException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrAdminHTTPClient {
    static Log s_logger = LogFactory.getLog(SolrAdminHTTPClient.class);
    private String baseUrl;
    private HttpClient httpClient;
    private HttpClientFactory httpClientFactory;

    public void init() {
        StringBuilder sb = new StringBuilder();
        sb.append("/solr/admin/cores");
        this.baseUrl = sb.toString();
        this.httpClient = this.httpClientFactory.getHttpClient();
        HttpClientParams params = this.httpClient.getParams();
        params.setBooleanParameter("http.authentication.preemptive", true);
        this.httpClient.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials("admin", "admin"));
    }

    public void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject execute(HashMap<String, String> args) {
        try {
            JSONObject jSONObject;
            URLCodec encoder = new URLCodec();
            StringBuilder url = new StringBuilder();
            for (String key : args.keySet()) {
                String value = args.get(key);
                if (url.length() == 0) {
                    url.append(this.baseUrl);
                    url.append("?");
                    url.append(encoder.encode(key, "UTF-8"));
                    url.append("=");
                    url.append(encoder.encode(value, "UTF-8"));
                    continue;
                }
                url.append("&");
                url.append(encoder.encode(key, "UTF-8"));
                url.append("=");
                url.append(encoder.encode(value, "UTF-8"));
            }
            PostMethod post = new PostMethod(url.toString());
            try {
                JSONObject json;
                Header locationHeader;
                this.httpClient.executeMethod((HttpMethod)post);
                if ((post.getStatusCode() == 301 || post.getStatusCode() == 302) && (locationHeader = post.getResponseHeader("location")) != null) {
                    String redirectLocation = locationHeader.getValue();
                    post.setURI(new URI(redirectLocation, true));
                    this.httpClient.executeMethod((HttpMethod)post);
                }
                if (post.getStatusCode() != 200) {
                    throw new LuceneQueryParserException("Request failed " + post.getStatusCode() + " " + url.toString());
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(post.getResponseBodyAsStream()));
                jSONObject = json = new JSONObject(new JSONTokener((Reader)reader));
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                post.releaseConnection();
                throw throwable;
            }
            post.releaseConnection();
            return jSONObject;
        }
        catch (UnsupportedEncodingException e) {
            throw new LuceneQueryParserException("", (Throwable)e);
        }
        catch (HttpException e) {
            throw new LuceneQueryParserException("", (Throwable)e);
        }
        catch (IOException e) {
            throw new LuceneQueryParserException("", (Throwable)e);
        }
        catch (JSONException e) {
            throw new LuceneQueryParserException("", (Throwable)e);
        }
    }
}

