/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParserException;
import org.alfresco.repo.search.impl.solr.SolrAdminHTTPClient;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrChildApplicationContextFactory
extends ChildApplicationContextFactory {
    private static String ALFRESCO_ACTIVE = "tracker.alfresco.active";
    private static String ALFRESCO_LAG = "tracker.alfresco.lag";
    private static String ALFRESCO_LAG_DURATION = "tracker.alfresco.lag.duration";
    private static String ARCHIVE_ACTIVE = "tracker.archive.active";
    private static String ARCHIVE_LAG = "tracker.archive.lag";
    private static String ARCHIVE_LAG_DURATION = "tracker.archive.lag.duration";

    @Override
    public boolean isUpdateable(String name) {
        return super.isUpdateable(name) && !name.equals(ALFRESCO_ACTIVE) && !name.equals(ALFRESCO_LAG) && !name.equals(ALFRESCO_LAG_DURATION) && !name.equals(ARCHIVE_ACTIVE) && !name.equals(ARCHIVE_LAG) && !name.equals(ARCHIVE_LAG_DURATION);
    }

    @Override
    public String getProperty(String name) {
        if (name.equals(ALFRESCO_ACTIVE) || name.equals(ALFRESCO_LAG) || name.equals(ALFRESCO_LAG_DURATION) || name.equals(ARCHIVE_ACTIVE) || name.equals(ARCHIVE_LAG) || name.equals(ARCHIVE_LAG_DURATION)) {
            try {
                ApplicationContext ctx = this.getApplicationContext();
                SolrAdminHTTPClient adminClient = (SolrAdminHTTPClient)ctx.getBean("search.solrAdminHTTPCLient");
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("action", "SUMMARY");
                args.put("wt", "json");
                JSONObject json = adminClient.execute(args);
                JSONObject summary = json.getJSONObject("Summary");
                Date now = new Date();
                JSONObject alfresco = summary.getJSONObject("alfresco");
                String alfrescoLag = alfresco.getString("Lag");
                String alfrescoActive = alfresco.getString("Active");
                String alfrescoDuration = alfresco.getString("Duration");
                JSONObject archive = summary.getJSONObject("archive");
                String archiveLag = archive.getString("Lag");
                String archiveActive = archive.getString("Active");
                String archiveDuration = archive.getString("Duration");
                if (name.equals(ALFRESCO_ACTIVE)) {
                    return alfrescoActive;
                }
                if (name.equals(ALFRESCO_LAG)) {
                    return alfrescoLag;
                }
                if (name.equals(ALFRESCO_LAG_DURATION)) {
                    return alfrescoDuration;
                }
                if (name.equals(ARCHIVE_ACTIVE)) {
                    return archiveActive;
                }
                if (name.equals(ARCHIVE_LAG)) {
                    return archiveLag;
                }
                if (name.equals(ARCHIVE_LAG_DURATION)) {
                    return archiveDuration;
                }
                return "Unavailable";
            }
            catch (LuceneQueryParserException lqe) {
                return "Unavailable: " + lqe.getMessage();
            }
            catch (JSONException e) {
                return "Unavailable: " + e.getMessage();
            }
        }
        return super.getProperty(name);
    }

    @Override
    public Set<String> getPropertyNames() {
        TreeSet<String> result = new TreeSet<String>();
        result.add(ALFRESCO_ACTIVE);
        result.add(ALFRESCO_LAG);
        result.add(ALFRESCO_LAG_DURATION);
        result.add(ARCHIVE_ACTIVE);
        result.add(ARCHIVE_LAG);
        result.add(ARCHIVE_LAG_DURATION);
        result.addAll(super.getPropertyNames());
        return result;
    }

    @Override
    public void setProperty(String name, String value) {
        if (name.equals(ALFRESCO_ACTIVE) || name.equals(ALFRESCO_LAG) || name.equals(ALFRESCO_LAG_DURATION) || name.equals(ARCHIVE_ACTIVE) || name.equals(ARCHIVE_LAG) || name.equals(ARCHIVE_LAG_DURATION)) {
            throw new IllegalStateException("Illegal write to property \"" + name + "\"");
        }
        super.setProperty(name, value);
    }
}

