/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.alfresco.repo.search.CannedQueryDef;
import org.alfresco.repo.search.QueryRegisterComponent;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.impl.NodeSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneQueryLanguageSPI;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.QueryParameterisationException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.XPathException;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.QueryParameter;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.alfresco.util.SearchLanguageConversion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrSearchService
implements SearchService {
    private NodeService nodeService;
    private NamespacePrefixResolver namespacePrefixResolver;
    private DictionaryService dictionaryService;
    private Map<String, LuceneQueryLanguageSPI> queryLanguages;
    private QueryRegisterComponent queryRegister;

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.namespacePrefixResolver;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public Map<String, LuceneQueryLanguageSPI> getQueryLanguages() {
        return this.queryLanguages;
    }

    public void setQueryLanguages(Map<String, LuceneQueryLanguageSPI> queryLanguages) {
        this.queryLanguages = queryLanguages;
    }

    public QueryRegisterComponent getQueryRegister() {
        return this.queryRegister;
    }

    public void setQueryRegister(QueryRegisterComponent queryRegister) {
        this.queryRegister = queryRegister;
    }

    public ResultSet query(StoreRef store, String language, String query) {
        return this.query(store, language, query, null);
    }

    public ResultSet query(StoreRef store, String language, String query, QueryParameterDefinition[] queryParameterDefinitions) {
        SearchParameters sp = new SearchParameters();
        sp.addStore(store);
        sp.setLanguage(language);
        sp.setQuery(query);
        if (queryParameterDefinitions != null) {
            for (QueryParameterDefinition qpd : queryParameterDefinitions) {
                sp.addQueryParameterDefinition(qpd);
            }
        }
        sp.excludeDataInTheCurrentTransaction(true);
        return this.query(sp);
    }

    public ResultSet query(StoreRef store, QName queryId, QueryParameter[] queryParameters) {
        CannedQueryDef definition = this.queryRegister.getQueryDefinition(queryId);
        this.checkParameters(definition, queryParameters);
        String queryString = this.parameterise(definition.getQuery(), definition.getQueryParameterMap(), queryParameters, definition.getNamespacePrefixResolver());
        return this.query(store, definition.getLanguage(), queryString, null);
    }

    private void checkParameters(CannedQueryDef definition, QueryParameter[] queryParameters) throws QueryParameterisationException {
        ArrayList<QName> missing = new ArrayList<QName>();
        HashSet<QName> parameterQNameSet = new HashSet<QName>();
        if (queryParameters != null) {
            for (QueryParameter parameter : queryParameters) {
                parameterQNameSet.add(parameter.getQName());
            }
        }
        for (QueryParameterDefinition parameterDefinition : definition.getQueryParameterDefs()) {
            if (parameterDefinition.hasDefaultValue() || parameterQNameSet.contains(parameterDefinition.getQName())) continue;
            missing.add(parameterDefinition.getQName());
        }
        if (missing.size() > 0) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append("The query is missing values for the following parameters: ");
            for (QName qName : missing) {
                buffer.append(qName);
                buffer.append(", ");
            }
            buffer.delete(buffer.length() - 1, buffer.length() - 1);
            buffer.delete(buffer.length() - 1, buffer.length() - 1);
            throw new QueryParameterisationException(buffer.toString());
        }
    }

    private String parameterise(String unparameterised, Map<QName, QueryParameterDefinition> map, QueryParameter[] queryParameters, NamespacePrefixResolver nspr) throws QueryParameterisationException {
        HashMap<QName, ArrayList<Serializable>> valueMap = new HashMap<QName, ArrayList<Serializable>>();
        if (queryParameters != null) {
            for (QueryParameter parameter : queryParameters) {
                ArrayList<Serializable> list = (ArrayList<Serializable>)valueMap.get(parameter.getQName());
                if (list == null) {
                    list = new ArrayList<Serializable>();
                    valueMap.put(parameter.getQName(), list);
                }
                list.add(parameter.getValue());
            }
        }
        HashMap iteratorMap = new HashMap();
        ArrayList<QName> missing = new ArrayList<QName>(1);
        StringBuilder buffer = new StringBuilder(unparameterised);
        int index = 0;
        while ((index = buffer.indexOf("${", index)) != -1) {
            int endIndex = buffer.indexOf("}", index);
            String qNameString = buffer.substring(index + 2, endIndex);
            QName key = QName.createQName((String)qNameString, (NamespacePrefixResolver)nspr);
            QueryParameterDefinition parameterDefinition = map.get(key);
            if (parameterDefinition == null) {
                missing.add(key);
                buffer.replace(index, endIndex + 1, "");
                continue;
            }
            ListIterator it = (ListIterator)iteratorMap.get(key);
            if (it == null || !it.hasNext()) {
                List list = (List)valueMap.get(key);
                if (list != null && list.size() > 0) {
                    it = list.listIterator();
                }
                if (it != null) {
                    iteratorMap.put(key, it);
                }
            }
            String value = it == null ? parameterDefinition.getDefault() : (String)DefaultTypeConverter.INSTANCE.convert(String.class, it.next());
            buffer.replace(index, endIndex + 1, value);
        }
        if (missing.size() > 0) {
            StringBuilder error = new StringBuilder();
            error.append("The query uses the following parameters which are not defined: ");
            for (QName qName : missing) {
                error.append(qName);
                error.append(", ");
            }
            error.delete(error.length() - 1, error.length() - 1);
            error.delete(error.length() - 1, error.length() - 1);
            throw new QueryParameterisationException(error.toString());
        }
        return buffer.toString();
    }

    public ResultSet query(SearchParameters searchParameters) {
        String parameterisedQueryString;
        if (searchParameters.getStores().size() != 1) {
            throw new IllegalStateException("Only one store can be searched at present");
        }
        if (searchParameters.getQueryParameterDefinitions().size() > 0) {
            HashMap<QName, QueryParameterDefinition> map = new HashMap<QName, QueryParameterDefinition>();
            for (QueryParameterDefinition qpd : searchParameters.getQueryParameterDefinitions()) {
                map.put(qpd.getQName(), qpd);
            }
            parameterisedQueryString = this.parameterise(searchParameters.getQuery(), map, null, this.namespacePrefixResolver);
        } else {
            parameterisedQueryString = searchParameters.getQuery();
        }
        searchParameters.setQuery(parameterisedQueryString);
        LuceneQueryLanguageSPI language = this.queryLanguages.get(searchParameters.getLanguage().toLowerCase());
        if (language != null) {
            return language.executeQuery(searchParameters, null);
        }
        throw new SearcherException("Unknown query language: " + searchParameters.getLanguage());
    }

    public List<NodeRef> selectNodes(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks) throws InvalidNodeRefException, XPathException {
        return this.selectNodes(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, "xpath");
    }

    public List<NodeRef> selectNodes(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks, String language) throws InvalidNodeRefException, XPathException {
        NodeSearcher nodeSearcher = new NodeSearcher(this.nodeService, this.dictionaryService, this);
        return nodeSearcher.selectNodes(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, language);
    }

    public List<Serializable> selectProperties(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks) throws InvalidNodeRefException, XPathException {
        return this.selectProperties(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, "xpath");
    }

    public List<Serializable> selectProperties(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks, String language) throws InvalidNodeRefException, XPathException {
        NodeSearcher nodeSearcher = new NodeSearcher(this.nodeService, this.dictionaryService, this);
        return nodeSearcher.selectProperties(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, language);
    }

    public boolean contains(NodeRef nodeRef, QName propertyQName, String googleLikePattern) throws InvalidNodeRefException {
        return this.contains(nodeRef, propertyQName, googleLikePattern, SearchParameters.Operator.OR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(NodeRef nodeRef, QName propertyQName, String googleLikePattern, SearchParameters.Operator defaultOperator) throws InvalidNodeRefException {
        boolean bl;
        block5: {
            ResultSet resultSet = null;
            try {
                boolean answer;
                StringBuilder sb = new StringBuilder();
                sb.append("+ID:\"").append(nodeRef.toString()).append("\" +(TEXT:(").append(googleLikePattern.toLowerCase()).append(") ");
                if (propertyQName != null) {
                    sb.append(" OR @").append(LuceneQueryParser.escape((String)QName.createQName((String)propertyQName.getNamespaceURI(), (String)ISO9075.encode((String)propertyQName.getLocalName())).toString()));
                    sb.append(":(").append(googleLikePattern.toLowerCase()).append(")");
                } else {
                    for (QName key : this.nodeService.getProperties(nodeRef).keySet()) {
                        sb.append(" OR @").append(LuceneQueryParser.escape((String)QName.createQName((String)key.getNamespaceURI(), (String)ISO9075.encode((String)key.getLocalName())).toString()));
                        sb.append(":(").append(googleLikePattern.toLowerCase()).append(")");
                    }
                }
                sb.append(")");
                SearchParameters sp = new SearchParameters();
                sp.setLanguage("lucene");
                sp.setQuery(sb.toString());
                sp.setDefaultOperator(defaultOperator);
                sp.addStore(nodeRef.getStoreRef());
                resultSet = this.query(sp);
                bl = answer = resultSet.length() > 0;
                Object var11_11 = null;
                if (resultSet == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var11_12 = null;
                    if (resultSet == null) break block6;
                    resultSet.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean like(NodeRef nodeRef, QName propertyQName, String sqlLikePattern, boolean includeFTS) throws InvalidNodeRefException {
        if (propertyQName == null) {
            throw new IllegalArgumentException("Property QName is mandatory for the like expression");
        }
        StringBuilder sb = new StringBuilder(sqlLikePattern.length() * 3);
        if (includeFTS) {
            boolean bl;
            block8: {
                String pattern = SearchLanguageConversion.convertXPathLikeToLucene((String)sqlLikePattern.toLowerCase());
                sb = new StringBuilder();
                sb.append("+ID:\"").append(nodeRef.toString()).append("\" +(");
                if (includeFTS) {
                    sb.append("TEXT:(").append(pattern).append(") ");
                }
                if (propertyQName != null) {
                    sb.append(" @").append(LuceneQueryParser.escape((String)QName.createQName((String)propertyQName.getNamespaceURI(), (String)ISO9075.encode((String)propertyQName.getLocalName())).toString())).append(":(").append(pattern).append(")");
                }
                sb.append(")");
                ResultSet resultSet = null;
                try {
                    boolean answer;
                    resultSet = this.query(nodeRef.getStoreRef(), "lucene", sb.toString());
                    bl = answer = resultSet.length() > 0;
                    Object var11_13 = null;
                    if (resultSet == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        String pattern = SearchLanguageConversion.convertXPathLikeToRegex((String)sqlLikePattern.toLowerCase());
        Serializable property = this.nodeService.getProperty(nodeRef, propertyQName);
        if (property == null) {
            return false;
        }
        String propertyString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, propertyQName));
        return propertyString.toLowerCase().matches(pattern);
    }
}

