/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.List;
import java.util.Set;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.security.authentication.AuthenticationDisallowedException;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationMaxUsersException;
import org.alfresco.repo.security.authentication.TicketComponent;
import org.alfresco.service.cmr.security.AuthenticationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthenticationService
implements AuthenticationService {
    public static final String GUEST_AUTHENTICATION_NOT_SUPPORTED = "Guest authentication not supported";
    private SysAdminParams sysAdminParams;

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void preAuthenticationCheck(String userName) throws AuthenticationException {
        if (this.sysAdminParams != null) {
            List<String> allowedUsers = this.sysAdminParams.getAllowedUserList();
            if (allowedUsers != null && !allowedUsers.contains(userName)) {
                throw new AuthenticationDisallowedException("Username not allowed: " + userName);
            }
            Integer maxUsers = this.sysAdminParams.getMaxUsers();
            if (maxUsers != null && maxUsers != -1 && this.getUsersWithTickets(true).size() >= maxUsers) {
                throw new AuthenticationMaxUsersException("Max users exceeded: " + maxUsers);
            }
        }
    }

    public List<String> getAllowedUsers() {
        return this.sysAdminParams.getAllowedUserList();
    }

    public int getMaxUsers() {
        return this.sysAdminParams.getMaxUsers();
    }

    public abstract Set<String> getUsersWithTickets(boolean var1);

    public abstract int invalidateTickets(boolean var1);

    public abstract int countTickets(boolean var1);

    public abstract Set<TicketComponent> getTicketComponents();
}

