/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.Date;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.dao.UsernameNotFoundException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.springframework.dao.DataAccessException;

public class DefaultMutableAuthenticationDao
implements MutableAuthenticationDao {
    private boolean allowCreateUser = false;
    private boolean allowUpdateUser = false;
    private boolean allowDeleteUser = false;
    private boolean allowSetEnabled = false;
    private boolean allowGetEnabled = false;
    private boolean allowSetAccountExpires = false;
    private boolean allowGetAccountHasExpired = false;
    private boolean allowSetCredentialsExpire = false;
    private boolean allowGetCredentialsExpire = false;
    private boolean allowGetCredentialsHaveExpired = false;
    private boolean allowSetAccountLocked = false;
    private boolean allowGetAccountLocked = false;
    private boolean allowSetAccountExpiryDate = false;
    private boolean allowGetAccountExpiryDate = false;
    private boolean allowSetCredentialsExpiryDate = false;
    private boolean allowGetCredentialsExpiryDate = false;

    public void createUser(String userName, char[] rawPassword) throws AuthenticationException {
        if (!this.allowCreateUser) {
            throw new AlfrescoRuntimeException("Create User is not supported");
        }
    }

    public void updateUser(String userName, char[] rawPassword) throws AuthenticationException {
        if (!this.allowUpdateUser) {
            throw new AlfrescoRuntimeException("Update user is not supported");
        }
    }

    public void deleteUser(String userName) throws AuthenticationException {
        if (!this.allowDeleteUser) {
            throw new AlfrescoRuntimeException("Delete user is not supported");
        }
    }

    public boolean userExists(String userName) {
        return true;
    }

    public void setEnabled(String userName, boolean enabled) {
        if (!this.allowSetEnabled) {
            throw new AlfrescoRuntimeException("Set enabled is not supported");
        }
    }

    public boolean getEnabled(String userName) {
        if (!this.allowGetEnabled) {
            throw new AlfrescoRuntimeException("Get enabled is not supported");
        }
        return true;
    }

    public void setAccountExpires(String userName, boolean expires) {
        if (!this.allowSetAccountExpires) {
            throw new AlfrescoRuntimeException("Set account expires is not supported");
        }
    }

    public boolean getAccountExpires(String userName) {
        if (!this.allowSetAccountExpires) {
            throw new AlfrescoRuntimeException("Get account expires is not supported");
        }
        return false;
    }

    public boolean getAccountHasExpired(String userName) {
        if (!this.allowGetAccountHasExpired) {
            throw new AlfrescoRuntimeException("Get account has expired is not supported");
        }
        return false;
    }

    public void setCredentialsExpire(String userName, boolean expires) {
        if (!this.allowSetCredentialsExpire) {
            throw new AlfrescoRuntimeException("Set credentials expire is not supported");
        }
    }

    public boolean getCredentialsExpire(String userName) {
        if (!this.allowGetCredentialsExpire) {
            throw new AlfrescoRuntimeException("Get credentials expire is not supported");
        }
        return false;
    }

    public boolean getCredentialsHaveExpired(String userName) {
        if (!this.allowGetCredentialsHaveExpired) {
            throw new AlfrescoRuntimeException("Get credentials have expired is not supported");
        }
        return false;
    }

    public void setLocked(String userName, boolean locked) {
        if (!this.allowSetAccountLocked) {
            throw new AlfrescoRuntimeException("Set account locked is not supported");
        }
    }

    public boolean getLocked(String userName) {
        if (!this.allowGetAccountLocked) {
            throw new AlfrescoRuntimeException("Get account locked is not supported");
        }
        return false;
    }

    public boolean getAccountlocked(String userName) {
        return this.getLocked(userName);
    }

    public void setAccountExpiryDate(String userName, Date exipryDate) {
        if (!this.allowSetAccountExpiryDate) {
            throw new AlfrescoRuntimeException("Set account expiry date is not supported");
        }
    }

    public Date getAccountExpiryDate(String userName) {
        if (!this.allowGetAccountExpiryDate) {
            throw new AlfrescoRuntimeException("Get account expiry date is not supported");
        }
        return null;
    }

    public void setCredentialsExpiryDate(String userName, Date exipryDate) {
        if (!this.allowSetCredentialsExpiryDate) {
            throw new AlfrescoRuntimeException("Set credentials expiry date is not supported");
        }
    }

    public Date getCredentialsExpiryDate(String userName) {
        if (!this.allowGetCredentialsExpiryDate) {
            throw new AlfrescoRuntimeException("Get credentials expiry date is not supported");
        }
        return null;
    }

    public String getMD4HashedPassword(String userName) {
        throw new AlfrescoRuntimeException("Not implemented");
    }

    public UserDetails loadUserByUsername(String arg0) throws UsernameNotFoundException, DataAccessException {
        throw new AlfrescoRuntimeException("Not implemented");
    }

    public Object getSalt(UserDetails user) {
        throw new AlfrescoRuntimeException("Not implemented");
    }

    public void setAllowCreateUser(boolean allowCreateUser) {
        this.allowCreateUser = allowCreateUser;
    }

    public void setAllowDeleteUser(boolean allowDeleteUser) {
        this.allowDeleteUser = allowDeleteUser;
    }

    public void setAllowGetAccountExpiryDate(boolean allowGetAccountExpiryDate) {
        this.allowGetAccountExpiryDate = allowGetAccountExpiryDate;
    }

    public void setAllowGetAccountHasExpired(boolean allowGetAccountHasExpired) {
        this.allowGetAccountHasExpired = allowGetAccountHasExpired;
    }

    public void setAllowGetAccountLocked(boolean allowGetAccountLocked) {
        this.allowGetAccountLocked = allowGetAccountLocked;
    }

    public void setAllowGetCredentialsExpire(boolean allowGetCredentialsExpire) {
        this.allowGetCredentialsExpire = allowGetCredentialsExpire;
    }

    public void setAllowGetCredentialsExpiryDate(boolean allowGetCredentialsExpiryDate) {
        this.allowGetCredentialsExpiryDate = allowGetCredentialsExpiryDate;
    }

    public void setAllowGetCredentialsHaveExpired(boolean allowGetCredentialsHaveExpired) {
        this.allowGetCredentialsHaveExpired = allowGetCredentialsHaveExpired;
    }

    public void setAllowGetEnabled(boolean allowGetEnabled) {
        this.allowGetEnabled = allowGetEnabled;
    }

    public void setAllowSetAccountExpires(boolean allowSetAccountExpires) {
        this.allowSetAccountExpires = allowSetAccountExpires;
    }

    public void setAllowSetAccountExpiryDate(boolean allowSetAccountExpiryDate) {
        this.allowSetAccountExpiryDate = allowSetAccountExpiryDate;
    }

    public void setAllowSetAccountLocked(boolean allowSetAccountLocked) {
        this.allowSetAccountLocked = allowSetAccountLocked;
    }

    public void setAllowSetCredentialsExpire(boolean allowSetCredentialsExpire) {
        this.allowSetCredentialsExpire = allowSetCredentialsExpire;
    }

    public void setAllowSetCredentialsExpiryDate(boolean allowSetCredentialsExpiryDate) {
        this.allowSetCredentialsExpiryDate = allowSetCredentialsExpiryDate;
    }

    public void setAllowSetEnabled(boolean allowSetEnabled) {
        this.allowSetEnabled = allowSetEnabled;
    }

    public void setAllowUpdateUser(boolean allowUpdateUser) {
        this.allowUpdateUser = allowUpdateUser;
    }
}

