/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.service.cmr.security.MutableAuthenticationService;

public class MutableAuthenticationServiceImpl
extends AuthenticationServiceImpl
implements MutableAuthenticationService {
    MutableAuthenticationDao authenticationDao;

    public void setAuthenticationDao(MutableAuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    public void createAuthentication(String userName, char[] password) throws AuthenticationException {
        this.authenticationDao.createUser(userName, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAuthentication(String userName, char[] oldPassword, char[] newPassword) throws AuthenticationException {
        String currentUser = AuthenticationUtil.getRunAsUser();
        try {
            this.authenticate(userName, oldPassword);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            AuthenticationUtil.setRunAsUser((String)currentUser);
            throw throwable;
        }
        AuthenticationUtil.setRunAsUser((String)currentUser);
        this.authenticationDao.updateUser(userName, newPassword);
    }

    public void setAuthentication(String userName, char[] newPassword) throws AuthenticationException {
        this.authenticationDao.updateUser(userName, newPassword);
    }

    public void deleteAuthentication(String userName) throws AuthenticationException {
        this.authenticationDao.deleteUser(userName);
    }

    public boolean getAuthenticationEnabled(String userName) throws AuthenticationException {
        return this.authenticationDao.getEnabled(userName);
    }

    public void setAuthenticationEnabled(String userName, boolean enabled) throws AuthenticationException {
        this.authenticationDao.setEnabled(userName, enabled);
    }

    public boolean authenticationExists(String userName) {
        return this.authenticationDao.userExists(userName);
    }

    public boolean isAuthenticationMutable(String userName) {
        return this.authenticationExists(userName);
    }

    public boolean isAuthenticationCreationAllowed() {
        return true;
    }
}

