/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.dao.User;
import net.sf.acegisecurity.providers.dao.UsernameNotFoundException;
import net.sf.acegisecurity.providers.encoding.PasswordEncoder;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.EqualsHelper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryAuthenticationDao
implements MutableAuthenticationDao,
InitializingBean,
NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy {
    private static final StoreRef STOREREF_USERS = new StoreRef("user", "alfrescoUserStore");
    private AuthorityService authorityService;
    private NodeService nodeService;
    private TenantService tenantService;
    private NamespacePrefixResolver namespacePrefixResolver;
    private PasswordEncoder passwordEncoder;
    private PolicyComponent policyComponent;
    private Map<String, NodeRef> userFolderRefs = new ConcurrentHashMap<String, NodeRef>(4);
    private SimpleCache<String, NodeRef> authenticationCache;

    public void setNamespaceService(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setAuthenticationCache(SimpleCache<String, NodeRef> authenticationCache) {
        this.authenticationCache = authenticationCache;
    }

    public void afterPropertiesSet() throws Exception {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.TYPE_USER, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
    }

    public UserDetails loadUserByUsername(String incomingUserName) throws UsernameNotFoundException, DataAccessException {
        NodeRef userRef = this.getUserOrNull(incomingUserName);
        if (userRef == null) {
            throw new UsernameNotFoundException("Could not find user by userName: " + incomingUserName);
        }
        Map properties = this.nodeService.getProperties(userRef);
        String password = (String)DefaultTypeConverter.INSTANCE.convert(String.class, properties.get(ContentModel.PROP_PASSWORD));
        String userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, properties.get(ContentModel.PROP_USER_USERNAME));
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
        User ud = new User(userName, password, this.getEnabled(userName, properties), !this.getHasExpired(userName, properties), !this.getCredentialsHaveExpired(userName, properties), !this.getLocked(userName, properties), gas);
        return ud;
    }

    public NodeRef getUserOrNull(String searchUserName) {
        List results;
        if (searchUserName == null || searchUserName.length() == 0) {
            return null;
        }
        NodeRef result = (NodeRef)this.authenticationCache.get((Serializable)((Object)searchUserName));
        if (result == null && !(results = this.nodeService.getChildAssocs(this.getUserFolderLocation(searchUserName), (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)searchUserName))).isEmpty()) {
            result = this.tenantService.getName(((ChildAssociationRef)results.get(0)).getChildRef());
            this.authenticationCache.put((Serializable)((Object)searchUserName), (Object)result);
        }
        return result;
    }

    @Override
    public void createUser(String caseSensitiveUserName, char[] rawPassword) throws AuthenticationException {
        this.tenantService.checkDomainUser(caseSensitiveUserName);
        NodeRef userRef = this.getUserOrNull(caseSensitiveUserName);
        if (userRef != null) {
            throw new AuthenticationException("User already exists: " + caseSensitiveUserName);
        }
        NodeRef typesNode = this.getUserFolderLocation(caseSensitiveUserName);
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        properties.put(ContentModel.PROP_USER_USERNAME, caseSensitiveUserName);
        Object salt = null;
        properties.put(ContentModel.PROP_SALT, salt);
        properties.put(ContentModel.PROP_PASSWORD, this.passwordEncoder.encodePassword(new String(rawPassword), salt));
        properties.put(ContentModel.PROP_ACCOUNT_EXPIRES, false);
        properties.put(ContentModel.PROP_CREDENTIALS_EXPIRE, false);
        properties.put(ContentModel.PROP_ENABLED, true);
        properties.put(ContentModel.PROP_ACCOUNT_LOCKED, false);
        this.nodeService.createNode(typesNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)caseSensitiveUserName), ContentModel.TYPE_USER, properties);
    }

    private NodeRef getUserFolderLocation(String caseSensitiveUserName) {
        String cacheKey = this.tenantService.getUserDomain(caseSensitiveUserName);
        NodeRef userNodeRef = this.userFolderRefs.get(cacheKey);
        if (userNodeRef == null) {
            QName qnameAssocSystem = QName.createQName((String)"sys", (String)"system", (NamespacePrefixResolver)this.namespacePrefixResolver);
            QName qnameAssocUsers = QName.createQName((String)"sys", (String)"people", (NamespacePrefixResolver)this.namespacePrefixResolver);
            StoreRef userStoreRef = this.tenantService.getName(caseSensitiveUserName, new StoreRef(STOREREF_USERS.getProtocol(), STOREREF_USERS.getIdentifier()));
            NodeRef rootNode = this.nodeService.getRootNode(userStoreRef);
            List results = this.nodeService.getChildAssocs(rootNode, RegexQNamePattern.MATCH_ALL, (QNamePattern)qnameAssocSystem);
            NodeRef sysNodeRef = null;
            if (results.size() == 0) {
                throw new AlfrescoRuntimeException("Required authority system folder path not found: " + qnameAssocSystem);
            }
            sysNodeRef = ((ChildAssociationRef)results.get(0)).getChildRef();
            if ((results = this.nodeService.getChildAssocs(sysNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)qnameAssocUsers)).size() == 0) {
                throw new AlfrescoRuntimeException("Required user folder path not found: " + qnameAssocUsers);
            }
            userNodeRef = this.tenantService.getName(((ChildAssociationRef)results.get(0)).getChildRef());
            this.userFolderRefs.put(cacheKey, userNodeRef);
        }
        return userNodeRef;
    }

    @Override
    public void updateUser(String userName, char[] rawPassword) throws AuthenticationException {
        NodeRef userRef = this.getUserOrNull(userName);
        if (userRef == null) {
            throw new AuthenticationException("User name does not exist: " + userName);
        }
        Map properties = this.nodeService.getProperties(userRef);
        Object salt = null;
        properties.remove(ContentModel.PROP_SALT);
        properties.put(ContentModel.PROP_SALT, salt);
        properties.remove(ContentModel.PROP_PASSWORD);
        properties.put(ContentModel.PROP_PASSWORD, this.passwordEncoder.encodePassword(new String(rawPassword), salt));
        this.nodeService.setProperties(userRef, properties);
    }

    @Override
    public void deleteUser(String userName) throws AuthenticationException {
        NodeRef userRef = this.getUserOrNull(userName);
        if (userRef == null) {
            throw new AuthenticationException("User name does not exist: " + userName);
        }
        this.nodeService.deleteNode(userRef);
    }

    public Object getSalt(UserDetails userDetails) {
        return null;
    }

    @Override
    public boolean userExists(String userName) {
        return this.getUserOrNull(userName) != null;
    }

    private Map<QName, Serializable> getUserProperties(String userName) {
        NodeRef userNodeRef = this.getUserOrNull(userName);
        if (userNodeRef == null) {
            return null;
        }
        return this.nodeService.getProperties(userNodeRef);
    }

    @Override
    public boolean getAccountExpires(String userName) {
        if (this.authorityService.isAdminAuthority(userName)) {
            return false;
        }
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return false;
        }
        Serializable ser = this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRES);
        if (ser == null) {
            return false;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue((Object)ser);
    }

    @Override
    public Date getAccountExpiryDate(String userName) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return null;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue((Object)this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRES))) {
            return (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRY_DATE));
        }
        return null;
    }

    @Override
    public boolean getAccountHasExpired(String userName) {
        return this.getHasExpired(userName, null);
    }

    private boolean getHasExpired(String userName, Map<QName, Serializable> properties) {
        if (this.authorityService.isAdminAuthority(userName)) {
            return false;
        }
        if (properties == null) {
            properties = this.getUserProperties(userName);
        }
        if (properties == null) {
            return false;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue((Object)properties.get(ContentModel.PROP_ACCOUNT_EXPIRES))) {
            Date date = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)properties.get(ContentModel.PROP_ACCOUNT_EXPIRY_DATE));
            if (date == null) {
                return false;
            }
            return date.compareTo(new Date()) < 1;
        }
        return false;
    }

    @Override
    public boolean getLocked(String userName) {
        return this.getLocked(userName, null);
    }

    @Override
    public boolean getAccountlocked(String userName) {
        return this.getLocked(userName, null);
    }

    private boolean getLocked(String userName, Map<QName, Serializable> properties) {
        if (this.authorityService.isAdminAuthority(userName)) {
            return false;
        }
        if (properties == null) {
            properties = this.getUserProperties(userName);
        }
        if (properties == null) {
            return false;
        }
        Serializable ser = properties.get(ContentModel.PROP_ACCOUNT_LOCKED);
        if (ser == null) {
            return false;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue((Object)ser);
    }

    @Override
    public boolean getCredentialsExpire(String userName) {
        return this.getCredentialsExpire(userName, null);
    }

    private boolean getCredentialsExpire(String userName, Map<QName, Serializable> properties) {
        if (this.authorityService.isAdminAuthority(userName)) {
            return false;
        }
        if (properties == null) {
            properties = this.getUserProperties(userName);
        }
        if (properties == null) {
            return false;
        }
        Serializable ser = properties.get(ContentModel.PROP_CREDENTIALS_EXPIRE);
        if (ser == null) {
            return false;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue((Object)ser);
    }

    @Override
    public Date getCredentialsExpiryDate(String userName) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return null;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue((Object)this.nodeService.getProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRE))) {
            return (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRY_DATE));
        }
        return null;
    }

    @Override
    public boolean getCredentialsHaveExpired(String userName) {
        return this.getCredentialsHaveExpired(userName, null);
    }

    private boolean getCredentialsHaveExpired(String userName, Map<QName, Serializable> properties) {
        if (this.authorityService.isAdminAuthority(userName)) {
            return false;
        }
        if (properties == null) {
            properties = this.getUserProperties(userName);
        }
        if (properties == null) {
            return false;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue((Object)properties.get(ContentModel.PROP_CREDENTIALS_EXPIRE))) {
            Date date = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)properties.get(ContentModel.PROP_CREDENTIALS_EXPIRY_DATE));
            if (date == null) {
                return false;
            }
            return date.compareTo(new Date()) < 1;
        }
        return false;
    }

    @Override
    public boolean getEnabled(String userName) {
        return this.getEnabled(userName, null);
    }

    private boolean getEnabled(String userName, Map<QName, Serializable> properties) {
        if (this.authorityService.isAdminAuthority(userName)) {
            return true;
        }
        if (properties == null) {
            properties = this.getUserProperties(userName);
        }
        if (properties == null) {
            return false;
        }
        Serializable ser = properties.get(ContentModel.PROP_ENABLED);
        if (ser == null) {
            return true;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue((Object)ser);
    }

    @Override
    public void setAccountExpires(String userName, boolean expires) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRES, (Serializable)Boolean.valueOf(expires));
    }

    @Override
    public void setAccountExpiryDate(String userName, Date exipryDate) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRY_DATE, (Serializable)exipryDate);
    }

    @Override
    public void setCredentialsExpire(String userName, boolean expires) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRE, (Serializable)Boolean.valueOf(expires));
    }

    @Override
    public void setCredentialsExpiryDate(String userName, Date exipryDate) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRY_DATE, (Serializable)exipryDate);
    }

    @Override
    public void setEnabled(String userName, boolean enabled) {
        if (!enabled && this.authorityService.isAdminAuthority(userName)) {
            return;
        }
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_ENABLED, (Serializable)Boolean.valueOf(enabled));
    }

    @Override
    public void setLocked(String userName, boolean locked) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_ACCOUNT_LOCKED, (Serializable)Boolean.valueOf(locked));
    }

    @Override
    public String getMD4HashedPassword(String userName) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return null;
        }
        String password = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_PASSWORD));
        return password;
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        NodeRef userNode;
        String uidBefore = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)before.get(ContentModel.PROP_USERNAME));
        String uidAfter = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)after.get(ContentModel.PROP_USERNAME));
        if (uidBefore != null && !EqualsHelper.nullSafeEquals((Object)uidBefore, (Object)uidAfter) && (userNode = this.getUserOrNull(uidBefore)) != null) {
            this.nodeService.setProperty(userNode, ContentModel.PROP_USER_USERNAME, (Serializable)((Object)uidAfter));
            this.nodeService.moveNode(userNode, this.nodeService.getPrimaryParent(userNode).getParentRef(), ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)uidAfter));
            this.authenticationCache.remove((Serializable)((Object)uidBefore));
        }
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        String userName = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USER_USERNAME));
        if (userName != null) {
            this.authenticationCache.remove((Serializable)((Object)userName));
        }
    }
}

