/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ldap;

import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.ldap.LDAPInitialDirContextFactory;
import org.alfresco.repo.security.sync.ldap.LDAPNameResolver;
import org.springframework.beans.factory.InitializingBean;

public class LDAPAuthenticationComponentImpl
extends AbstractAuthenticationComponent
implements InitializingBean,
ActivateableBean {
    private boolean escapeCommasInBind = false;
    private boolean escapeCommasInUid = false;
    private boolean active = true;
    private String userNameFormat;
    private LDAPNameResolver ldapNameResolver;
    private LDAPInitialDirContextFactory ldapInitialContextFactory;

    public void setLDAPInitialDirContextFactory(LDAPInitialDirContextFactory ldapInitialDirContextFactory) {
        this.ldapInitialContextFactory = ldapInitialDirContextFactory;
    }

    public void setUserNameFormat(String userNameFormat) {
        this.userNameFormat = userNameFormat == null || userNameFormat.length() == 0 ? null : userNameFormat;
    }

    public void setLdapNameResolver(LDAPNameResolver ldapNameResolver) {
        this.ldapNameResolver = ldapNameResolver;
    }

    public void setEscapeCommasInBind(boolean escapeCommasInBind) {
        this.escapeCommasInBind = escapeCommasInBind;
    }

    public void setEscapeCommasInUid(boolean escapeCommasInUid) {
        this.escapeCommasInUid = escapeCommasInUid;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.ldapNameResolver == null && this.userNameFormat == null) {
            throw new IllegalStateException("At least one of ldapNameResolver and userNameFormat must be set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void authenticateImpl(String userName, char[] password) throws AuthenticationException {
        String userDN = this.userNameFormat == null ? this.ldapNameResolver.resolveDistinguishedName(userName) : String.format(this.userNameFormat, LDAPAuthenticationComponentImpl.escapeUserName(userName, this.escapeCommasInBind));
        InitialDirContext ctx = null;
        try {
            ctx = this.ldapInitialContextFactory.getInitialDirContext(userDN, new String(password));
            this.setCurrentUser(LDAPAuthenticationComponentImpl.escapeUserName(userName, this.escapeCommasInUid));
            Object var6_5 = null;
            if (ctx == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (ctx == null) throw throwable;
            try {
                ctx.close();
                throw throwable;
            }
            catch (NamingException e) {
                this.clearCurrentSecurityContext();
                throw new AuthenticationException("Failed to close connection", (Throwable)e);
            }
        }
        try {
            ctx.close();
            return;
        }
        catch (NamingException e) {
            this.clearCurrentSecurityContext();
            throw new AuthenticationException("Failed to close connection", (Throwable)e);
        }
    }

    private static String escapeUserName(String userName, boolean escape) {
        if (escape) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < userName.length(); ++i) {
                char c = userName.charAt(i);
                if (c == ',') {
                    sb.append('\\');
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return userName;
    }

    protected boolean implementationAllowsGuestLogin() {
        return true;
    }
}

