/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ntlm;

import java.net.InetAddress;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;

public class NTLMLocalToken
extends UsernamePasswordAuthenticationToken {
    private static final long serialVersionUID = -7946514578455279387L;
    private String m_clientDomain;
    private String m_clientAddr;

    protected NTLMLocalToken() {
        super(null, null);
    }

    protected NTLMLocalToken(InetAddress ipAddr) {
        if (ipAddr != null) {
            this.m_clientAddr = ipAddr.getHostAddress();
        }
    }

    public NTLMLocalToken(String username, String plainPwd) {
        super((Object)username.toLowerCase(), (Object)plainPwd);
    }

    public NTLMLocalToken(String username, String plainPwd, String domain, String ipAddr) {
        super((Object)(username != null ? username.toLowerCase() : ""), (Object)plainPwd);
        this.m_clientDomain = domain;
        this.m_clientAddr = ipAddr;
    }

    public final boolean isGuestLogon() {
        return this.hasAuthority("Guest");
    }

    public final boolean isAdministrator() {
        return this.hasAuthority("Administrator");
    }

    public final boolean hasAuthority(String authority) {
        boolean found = false;
        GrantedAuthority[] authorities = this.getAuthorities();
        if (authorities != null && authorities.length > 0) {
            int i = 0;
            while (!found && i < authorities.length) {
                if (!authorities[i++].getAuthority().equals(authority)) continue;
                found = true;
            }
        }
        return found;
    }

    public final boolean hasClientDomain() {
        return this.m_clientDomain != null;
    }

    public final String getClientDomain() {
        return this.m_clientDomain;
    }

    public final boolean hasClientAddress() {
        return this.m_clientAddr != null;
    }

    public final String getClientAddress() {
        return this.m_clientAddr;
    }
}

