/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.subsystems;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.management.subsystems.ChildApplicationContextManager;
import org.alfresco.repo.security.authentication.AbstractChainingAuthenticationService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubsystemChainingAuthenticationService
extends AbstractChainingAuthenticationService {
    private ChildApplicationContextManager applicationContextManager;
    private String sourceBeanName;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Collection<String> instanceIds;
    private Map<String, ApplicationContext> contexts = new TreeMap<String, ApplicationContext>();
    private Map<String, Object> sourceBeans = new TreeMap<String, Object>();

    public void setApplicationContextManager(ChildApplicationContextManager applicationContextManager) {
        this.applicationContextManager = applicationContextManager;
    }

    public void setSourceBeanName(String sourceBeanName) {
        this.sourceBeanName = sourceBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshBeans() {
        boolean haveWriteLock = false;
        try {
            if (this.instanceIds == null || !((Object)this.instanceIds).equals(this.applicationContextManager.getInstanceIds())) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                haveWriteLock = true;
                this.instanceIds = this.applicationContextManager.getInstanceIds();
                this.contexts.keySet().retainAll(this.instanceIds);
                this.sourceBeans.keySet().retainAll(this.instanceIds);
            }
            for (String instance : this.instanceIds) {
                ApplicationContext newContext = this.applicationContextManager.getApplicationContext(instance);
                ApplicationContext context = this.contexts.get(instance);
                if (context == newContext) continue;
                if (!haveWriteLock) {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                    haveWriteLock = true;
                }
                newContext = this.applicationContextManager.getApplicationContext(instance);
                this.contexts.put(instance, newContext);
                try {
                    this.sourceBeans.put(instance, newContext.getBean(this.sourceBeanName));
                }
                catch (NoSuchBeanDefinitionException e) {
                    this.sourceBeans.remove(instance);
                }
            }
            Object var8_7 = null;
            if (haveWriteLock) {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (haveWriteLock) {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MutableAuthenticationService getMutableAuthenticationService() {
        MutableAuthenticationService mutableAuthenticationService;
        this.lock.readLock().lock();
        try {
            this.refreshBeans();
            for (String instance : this.instanceIds) {
                AuthenticationService authenticationService = (AuthenticationService)this.sourceBeans.get(instance);
                if (!(authenticationService instanceof MutableAuthenticationService) || authenticationService instanceof ActivateableBean && !((ActivateableBean)((Object)authenticationService)).isActive()) continue;
                MutableAuthenticationService mutableAuthenticationService2 = (MutableAuthenticationService)authenticationService;
                Object var6_5 = null;
                this.lock.readLock().unlock();
                return mutableAuthenticationService2;
            }
            mutableAuthenticationService = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
        Object var6_6 = null;
        this.lock.readLock().unlock();
        return mutableAuthenticationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<AuthenticationService> getUsableAuthenticationServices() {
        LinkedList<AuthenticationService> result = new LinkedList<AuthenticationService>();
        this.lock.readLock().lock();
        try {
            this.refreshBeans();
            for (String instance : this.instanceIds) {
                AuthenticationService authenticationService = (AuthenticationService)this.sourceBeans.get(instance);
                if (authenticationService instanceof ActivateableBean && !((ActivateableBean)((Object)authenticationService)).isActive()) continue;
                result.add(authenticationService);
            }
            LinkedList<AuthenticationService> linkedList = result;
            Object var6_5 = null;
            this.lock.readLock().unlock();
            return linkedList;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
    }
}

