/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.security.authority.UnknownAuthorityException;
import org.alfresco.repo.security.authority.script.ScriptGroup;
import org.alfresco.repo.security.authority.script.ScriptUser;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.ScriptPagingDetails;

public class ScriptAuthorityService
extends BaseScopableProcessorExtension {
    private AuthorityService authorityService;
    private PersonService personService;
    private ServiceRegistry serviceRegistry;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.authorityService = serviceRegistry.getAuthorityService();
        this.personService = serviceRegistry.getPersonService();
    }

    public AuthorityService getAuthorityService() {
        return this.authorityService;
    }

    public ScriptGroup[] searchRootGroupsInZone(String displayNamePattern, String zone) {
        return this.searchRootGroupsInZone(displayNamePattern, zone, -1, -1);
    }

    public ScriptGroup[] searchRootGroupsInZone(String displayNamePattern, String zone, int maxItems, int skipCount) {
        return this.searchRootGroupsInZone(displayNamePattern, zone, new ScriptPagingDetails(maxItems, skipCount), null);
    }

    public ScriptGroup[] searchRootGroupsInZone(String displayNamePattern, String zone, ScriptPagingDetails paging, String sortBy) {
        Set<String> authorities;
        try {
            authorities = this.authorityService.findAuthorities(AuthorityType.GROUP, null, true, displayNamePattern, zone);
        }
        catch (UnknownAuthorityException e) {
            authorities = Collections.emptySet();
        }
        return ScriptGroup.makeScriptGroups(authorities, paging, sortBy, this.serviceRegistry, this.getScope());
    }

    public ScriptGroup[] searchRootGroups(String displayNamePattern) {
        return this.searchRootGroupsInZone(displayNamePattern, null);
    }

    public ScriptGroup[] searchRootGroups(String displayNamePattern, ScriptPagingDetails paging, String sortBy) {
        return this.searchRootGroupsInZone(displayNamePattern, null, paging, sortBy);
    }

    public ScriptGroup[] getAllRootGroups() {
        return this.getAllRootGroups(-1, -1);
    }

    public ScriptGroup[] getAllRootGroups(int maxItems, int skipCount) {
        return this.getAllRootGroups(new ScriptPagingDetails(maxItems, skipCount));
    }

    public ScriptGroup[] getAllRootGroups(ScriptPagingDetails paging) {
        Set<String> authorities;
        try {
            authorities = this.authorityService.getAllRootAuthorities(AuthorityType.GROUP);
        }
        catch (UnknownAuthorityException e) {
            authorities = Collections.emptySet();
        }
        return ScriptGroup.makeScriptGroups(authorities, paging, this.serviceRegistry, this.getScope());
    }

    public ScriptGroup[] getAllRootGroupsInZone(String zone) {
        return this.getAllRootGroupsInZone(zone, -1, -1);
    }

    public ScriptGroup[] getAllRootGroupsInZone(String zone, int maxItems, int skipCount) {
        Set<String> authorities;
        try {
            authorities = this.authorityService.getAllRootAuthoritiesInZone(zone, AuthorityType.GROUP);
        }
        catch (UnknownAuthorityException e) {
            authorities = Collections.emptySet();
        }
        return ScriptGroup.makeScriptGroups(authorities, new ScriptPagingDetails(maxItems, skipCount), null, this.serviceRegistry, this.getScope());
    }

    public ScriptGroup[] getAllRootGroupsInZone(String zone, ScriptPagingDetails paging, String sortBy) {
        Set<String> authorities;
        try {
            authorities = this.authorityService.getAllRootAuthoritiesInZone(zone, AuthorityType.GROUP);
        }
        catch (UnknownAuthorityException e) {
            authorities = Collections.emptySet();
        }
        return ScriptGroup.makeScriptGroups(authorities, paging, sortBy, this.serviceRegistry, this.getScope());
    }

    public ScriptGroup[] getGroups(String filter, ScriptPagingDetails paging) {
        return this.getGroupsInZone(filter, null, paging, null);
    }

    public ScriptGroup[] getGroups(String filter, ScriptPagingDetails paging, String sortBy) {
        return this.getGroupsInZone(filter, null, paging, sortBy);
    }

    public ScriptGroup[] getGroupsInZone(String filter, String zone, ScriptPagingDetails paging, String sortBy) {
        if (filter != null && (filter.length() == 0 || filter.equals("*"))) {
            filter = null;
        }
        if (filter != null && (filter.startsWith("*") || filter.indexOf("?") != -1)) {
            return this.searchGroupsInZone(filter, zone, paging, sortBy);
        }
        try {
            paging.setRequestTotalCountMax(10000);
            PagingResults<String> groups = this.authorityService.getAuthorities(AuthorityType.GROUP, zone, filter, true, true, paging);
            return ScriptGroup.makeScriptGroups(groups, paging, this.serviceRegistry, this.getScope());
        }
        catch (UnknownAuthorityException e) {
            return new ScriptGroup[0];
        }
    }

    public ScriptGroup getGroup(String shortName) {
        String fullName = this.authorityService.getName(AuthorityType.GROUP, shortName);
        if (this.authorityService.authorityExists(fullName)) {
            ScriptGroup group = new ScriptGroup(fullName, this.serviceRegistry, this.getScope());
            return group;
        }
        return null;
    }

    public ScriptGroup getGroupForFullAuthorityName(String fullAuthorityName) {
        if (this.authorityService.authorityExists(fullAuthorityName)) {
            ScriptGroup group = new ScriptGroup(fullAuthorityName, this.serviceRegistry, this.getScope());
            return group;
        }
        return null;
    }

    public ScriptGroup createRootGroup(String shortName, String displayName) {
        this.authorityService.createAuthority(AuthorityType.GROUP, shortName, displayName, this.authorityService.getDefaultZones());
        return this.getGroup(shortName);
    }

    public ScriptGroup[] searchGroups(String shortNameFilter) {
        return this.searchGroupsInZone(shortNameFilter, null);
    }

    public ScriptGroup[] searchGroups(String shortNameFilter, ScriptPagingDetails paging, String sortBy) {
        return this.searchGroupsInZone(shortNameFilter, null, paging, sortBy);
    }

    public ScriptGroup[] searchGroupsInZone(String shortNameFilter, String zone) {
        return this.searchGroupsInZone(shortNameFilter, zone, -1, -1);
    }

    public ScriptGroup[] searchGroupsInZone(String shortNameFilter, String zone, int maxItems, int skipCount) {
        return this.searchGroupsInZone(shortNameFilter, zone, new ScriptPagingDetails(maxItems, skipCount), null);
    }

    public ScriptGroup[] searchGroupsInZone(String shortNameFilter, String zone, ScriptPagingDetails paging, String sortBy) {
        Set<String> authorities;
        String filter = shortNameFilter;
        if (shortNameFilter.length() != 0) {
            filter = filter.replace("\"", "");
        }
        try {
            authorities = this.authorityService.findAuthorities(AuthorityType.GROUP, null, false, filter, zone);
        }
        catch (UnknownAuthorityException e) {
            authorities = Collections.emptySet();
        }
        return ScriptGroup.makeScriptGroups(authorities, paging, sortBy, this.serviceRegistry, this.getScope());
    }

    public ScriptUser getUser(String username) {
        try {
            NodeRef person = this.personService.getPerson(username, false);
            return new ScriptUser(username, person, this.serviceRegistry, this.getScope());
        }
        catch (NoSuchPersonException e) {
            return null;
        }
    }

    public ScriptUser[] searchUsers(String nameFilter, ScriptPagingDetails paging, String sortBy) {
        ArrayList<Pair<QName, String>> filter = new ArrayList<Pair<QName, String>>();
        filter.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)nameFilter));
        filter.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)nameFilter));
        filter.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)nameFilter));
        ArrayList<Pair<QName, Boolean>> sort = new ArrayList<Pair<QName, Boolean>>();
        if ("lastName".equals(sortBy)) {
            sort.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)true));
            sort.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)true));
            sort.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)true));
        } else if ("firstName".equals(sortBy)) {
            sort.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)true));
            sort.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)true));
            sort.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)true));
        } else {
            sort.add(new Pair((Object)ContentModel.PROP_USERNAME, (Object)true));
            sort.add(new Pair((Object)ContentModel.PROP_FIRSTNAME, (Object)true));
            sort.add(new Pair((Object)ContentModel.PROP_LASTNAME, (Object)true));
        }
        List people = this.personService.getPeople(filter, true, sort, paging).getPage();
        paging.setTotalItems(people.size());
        ScriptUser[] users = new ScriptUser[people.size()];
        for (int i = 0; i < users.length; ++i) {
            PersonService.PersonInfo person = (PersonService.PersonInfo)people.get(i);
            users[i] = new ScriptUser(person.getUserName(), person.getNodeRef(), this.serviceRegistry, this.getScope());
        }
        return users;
    }
}

