/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority.script;

import java.io.Serializable;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.security.authority.script.Authority;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.mozilla.javascript.Scriptable;

public class ScriptUser
implements Authority,
Serializable {
    private static final long serialVersionUID = 7865300693011208293L;
    private transient ServiceRegistry serviceRegistry;
    private transient AuthorityService authorityService;
    private Authority.ScriptAuthorityType authorityType = Authority.ScriptAuthorityType.USER;
    private String userName;
    private String shortName;
    private String displayName;
    private NodeRef personNodeRef;
    private Scriptable scope;

    public ScriptUser(String userName, NodeRef personNodeRef, ServiceRegistry serviceRegistry, Scriptable scope) {
        this.serviceRegistry = serviceRegistry;
        this.authorityService = serviceRegistry.getAuthorityService();
        this.scope = scope;
        this.personNodeRef = personNodeRef;
        this.userName = userName;
        this.shortName = this.authorityService.getShortName(userName);
        this.displayName = this.authorityService.getAuthorityDisplayName(userName);
    }

    public ScriptUser(String userName, AuthorityService authorityService) {
        this.authorityService = authorityService;
        this.userName = userName;
        this.shortName = authorityService.getShortName(userName);
        this.displayName = authorityService.getAuthorityDisplayName(userName);
    }

    public void setAuthorityType(Authority.ScriptAuthorityType authorityType) {
        this.authorityType = authorityType;
    }

    public Authority.ScriptAuthorityType getAuthorityType() {
        return this.authorityType;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setFullName(String fullName) {
        this.userName = fullName;
    }

    public String getFullName() {
        return this.userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public NodeRef getPersonNodeRef() {
        if (this.personNodeRef == null) {
            this.personNodeRef = this.authorityService.getAuthorityNodeRef(this.userName);
        }
        return this.personNodeRef;
    }

    public ScriptNode getPerson() {
        return new ScriptNode(this.getPersonNodeRef(), this.serviceRegistry, this.scope);
    }
}

