/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.security.permissions.PermissionCheckedCollection;

public class PermissionCheckedCollectionTest
extends TestCase {
    protected void setUp() throws Exception {
    }

    public void testBasicWrapping() throws Exception {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        list.add(3);
        boolean isCutOff = true;
        int sizeUnchecked = 100;
        int sizeOriginal = 900;
        Collection proxiedList = PermissionCheckedCollection.PermissionCheckedCollectionMixin.create(list, true, 100, 900);
        PermissionCheckedCollectionTest.assertTrue((String)"Proxied object must still be a List", (boolean)(proxiedList instanceof List));
        PermissionCheckedCollectionTest.assertEquals((String)"List values incorrect", (int)3, (int)proxiedList.size());
        PermissionCheckedCollectionTest.assertTrue((String)"Proxied object must also be a PermissionCheckedCollection", (boolean)(proxiedList instanceof PermissionCheckedCollection));
        PermissionCheckedCollection proxiedPermissionCheckedCollection = (PermissionCheckedCollection)((Object)proxiedList);
        PermissionCheckedCollectionTest.assertEquals((String)"cutOff value incorrect", (boolean)true, (boolean)proxiedPermissionCheckedCollection.isCutOff());
        PermissionCheckedCollectionTest.assertEquals((String)"sizeUnchecked value incorrect", (int)100, (int)proxiedPermissionCheckedCollection.sizeUnchecked());
        PermissionCheckedCollectionTest.assertEquals((String)"sizeOriginal value incorrect", (int)900, (int)proxiedPermissionCheckedCollection.sizeOriginal());
    }

    public void testVolumeWrapping() throws Exception {
        int count = 10000;
        long before = System.nanoTime();
        for (int i = 0; i < count; ++i) {
            this.testBasicWrapping();
        }
        long after = System.nanoTime();
        double average = (double)(after - before) / (double)count / 1000000.0;
        System.out.println("Average is " + average + "ms per wrap.");
    }
}

