/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.util.List;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.context.Context;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.security.SecureContext;
import org.alfresco.query.AbstractCannedQuery;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.repo.security.authentication.AlfrescoSecureContext;
import org.alfresco.repo.security.permissions.PermissionCheckedCollection;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCannedQueryPermissions<R>
extends AbstractCannedQuery<R> {
    private Log logger = LogFactory.getLog(AbstractCannedQueryPermissions.class);
    private MethodSecurityBean<R> methodSecurity;

    protected AbstractCannedQueryPermissions(CannedQueryParameters parameters, MethodSecurityBean<R> methodSecurity) {
        super(parameters);
        this.methodSecurity = methodSecurity;
    }

    protected boolean isApplyPostQueryPermissions() {
        return true;
    }

    protected List<R> applyPostQueryPermissions(List<R> results, int requestedCount) {
        Context context = ContextHolder.getContext();
        if (context == null || !(context instanceof AlfrescoSecureContext)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Ignoring post-query permissions.  The secure context is empty: " + (Object)((Object)this)));
            }
            return results;
        }
        Authentication authentication = ((SecureContext)context).getAuthentication();
        List resultsOut = (List)this.methodSecurity.applyPermissions(results, authentication, requestedCount);
        return resultsOut;
    }

    protected Pair<Integer, Integer> getTotalResultCount(List<R> results) {
        PermissionCheckedCollection pcc;
        int size;
        int possibleSize = size = results.size();
        if (results instanceof PermissionCheckedCollection && (pcc = (PermissionCheckedCollection)((Object)results)).isCutOff()) {
            double successRatio = (double)size / (double)pcc.sizeOriginal();
            int possiblyMissed = (int)((double)pcc.sizeUnchecked() * successRatio);
            possibleSize = size + possiblyMissed;
        }
        return new Pair((Object)size, (Object)possibleSize);
    }
}

