/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.util.List;
import org.alfresco.repo.security.person.HomeFolderProvider;
import org.alfresco.repo.security.person.HomeFolderProvider2;
import org.alfresco.repo.security.person.HomeSpaceNodeRef;
import org.alfresco.repo.security.person.PermissionsManager;
import org.alfresco.repo.security.person.PortableHomeFolderManager;
import org.alfresco.repo.security.person.UIDBasedHomeFolderProvider;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractHomeFolderProvider
implements HomeFolderProvider,
BeanNameAware,
InitializingBean {
    private String name;
    private PortableHomeFolderManager homeFolderManager;
    private StoreRef storeRef;
    private ServiceRegistry serviceRegistry;
    private String path;
    private String ownerOnCreate;
    private PermissionsManager onCreatePermissionsManager;
    private PermissionsManager onReferencePermissionsManager;
    private V2Adaptor v2Adaptor = new V2Adaptor(this);

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"homeFolderManager", (Object)this.homeFolderManager);
        this.homeFolderManager.addProvider(this.v2Adaptor);
    }

    protected PortableHomeFolderManager getHomeFolderManager() {
        return this.homeFolderManager;
    }

    public void setHomeFolderManager(PortableHomeFolderManager homeFolderManager) {
        this.homeFolderManager = homeFolderManager;
    }

    public String getName() {
        return this.name;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    protected String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        boolean reset = this.path != null;
        this.path = path;
        if (reset) {
            this.homeFolderManager.clearCaches(this.v2Adaptor);
        }
    }

    protected StoreRef getStoreRef() {
        return this.storeRef;
    }

    public void setStoreRef(StoreRef storeRef) {
        this.storeRef = storeRef;
    }

    public void setStoreUrl(String storeUrl) {
        this.storeRef = new StoreRef(storeUrl);
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setTenantService(TenantService tenantService) {
    }

    public void setOnCreatePermissionsManager(PermissionsManager onCreatePermissionsManager) {
        this.onCreatePermissionsManager = onCreatePermissionsManager;
    }

    public PermissionsManager getOnCreatePermissionsManager() {
        return this.onCreatePermissionsManager;
    }

    public void setOnReferencePermissionsManager(PermissionsManager onReferencePermissionsManager) {
        this.onReferencePermissionsManager = onReferencePermissionsManager;
    }

    public PermissionsManager getOnReferencePermissionsManager() {
        return this.onReferencePermissionsManager;
    }

    public void setOwnerOnCreate(String ownerOnCreate) {
        this.ownerOnCreate = ownerOnCreate;
    }

    public String getOwnerOnCreate() {
        return this.ownerOnCreate;
    }

    protected NodeRef getPathNodeRef() {
        return this.homeFolderManager.getRootPathNodeRef(this.v2Adaptor);
    }

    protected NodeRef resolvePath(String pathToResolve) {
        return this.homeFolderManager.resolvePath(this.v2Adaptor, pathToResolve);
    }

    public void onCreateNode(ChildAssociationRef childAssocRef) {
        this.homeFolderManager.homeFolderCreateAndSetPermissions(this.v2Adaptor, childAssocRef.getChildRef());
    }

    protected abstract HomeSpaceNodeRef getHomeFolder(NodeRef var1);

    protected V2Adaptor getV2Adaptor() {
        return this.v2Adaptor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class V2Adaptor
    implements HomeFolderProvider2 {
        AbstractHomeFolderProvider abstractHomeFolderProvider;

        public V2Adaptor(AbstractHomeFolderProvider abstractHomeFolderProvider2) {
            this.abstractHomeFolderProvider = abstractHomeFolderProvider2;
            abstractHomeFolderProvider2.v2Adaptor = this;
        }

        @Override
        public String getName() {
            return this.abstractHomeFolderProvider.getName();
        }

        @Override
        public String getStoreUrl() {
            return this.abstractHomeFolderProvider.getStoreRef().toString();
        }

        @Override
        public String getRootPath() {
            return this.abstractHomeFolderProvider.getPath();
        }

        @Override
        public List<String> getHomeFolderPath(NodeRef person) {
            return this.abstractHomeFolderProvider instanceof UIDBasedHomeFolderProvider ? ((UIDBasedHomeFolderProvider)this.abstractHomeFolderProvider).getHomeFolderPath(person) : null;
        }

        @Override
        public NodeRef getTemplateNodeRef() {
            return this.abstractHomeFolderProvider instanceof UIDBasedHomeFolderProvider ? ((UIDBasedHomeFolderProvider)this.abstractHomeFolderProvider).getTemplateNodeRef() : null;
        }

        @Override
        public String getOwner() {
            return this.abstractHomeFolderProvider.getOwnerOnCreate();
        }

        @Override
        public PermissionsManager getOnCreatePermissionsManager() {
            return this.abstractHomeFolderProvider.getOnReferencePermissionsManager();
        }

        @Override
        public PermissionsManager getOnReferencePermissionsManager() {
            return this.abstractHomeFolderProvider.getOnReferencePermissionsManager();
        }

        @Override
        public HomeSpaceNodeRef getHomeFolder(NodeRef person) {
            return this.abstractHomeFolderProvider.getHomeFolder(person);
        }

        public void onCreateNode(ChildAssociationRef childAssocRef) {
            this.abstractHomeFolderProvider.onCreateNode(childAssocRef);
        }
    }
}

