/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.alfresco.repo.security.person.PersonException;
import org.alfresco.repo.security.person.UsernameHomeFolderProvider;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.FileNameValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexHomeFolderProvider
extends UsernameHomeFolderProvider {
    private static Log logger = LogFactory.getLog(RegexHomeFolderProvider.class);
    private QName propertyName;
    private Pattern pattern;
    private List<Integer> groupOrder;

    public void setPropertyName(String propertyName) {
        this.propertyName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)propertyName);
    }

    public void setPattern(String patternString) {
        this.pattern = this.getPattern(patternString);
    }

    public void setGroupOrder(String groupOrderString) {
        this.groupOrder = this.getGroupOrder(groupOrderString);
    }

    private Pattern getPattern(String patternString) {
        Pattern pattern;
        if (patternString == null || patternString.trim().length() == 0) {
            return null;
        }
        try {
            pattern = Pattern.compile(patternString);
            logger.debug((Object)("Successfully compiled patternString : " + patternString));
        }
        catch (PatternSyntaxException pse) {
            throw new PersonException("Pattern string :" + patternString + " does not compile", pse);
        }
        return pattern;
    }

    private List<Integer> getGroupOrder(String groupOrderString) {
        if (groupOrderString == null || groupOrderString.trim().length() == 0) {
            return Collections.emptyList();
        }
        String[] groupOrderStrings = groupOrderString.split(",");
        ArrayList<Integer> groupOrder = new ArrayList<Integer>(groupOrderStrings.length);
        for (String group : groupOrderStrings) {
            Integer i;
            try {
                i = Integer.valueOf(group);
            }
            catch (NumberFormatException nfe) {
                throw new PersonException("groupOrdering value " + groupOrderString + " is invalid.", nfe);
            }
            if (groupOrder.contains(i) || i < 0) {
                throw new PersonException("groupOrdering value " + groupOrderString + " is invalid.");
            }
            groupOrder.add(i);
        }
        return groupOrder;
    }

    @Override
    public List<String> getHomeFolderPath(NodeRef person) {
        Matcher matcher;
        ArrayList<String> path = new ArrayList<String>();
        String key = FileNameValidator.getValidFileName(this.getHomeFolderManager().getPersonProperty(person, this.propertyName));
        if (this.pattern != null && (matcher = this.pattern.matcher(key)).find()) {
            int groupCount = matcher.groupCount();
            if (!this.groupOrder.isEmpty()) {
                for (int group : this.groupOrder) {
                    if (group > groupCount) {
                        throw new PersonException("groupOrdering value " + group + " is out of range.");
                    }
                    this.addFolderToPath(path, matcher, group);
                }
            } else {
                for (int group = 1; group <= groupCount; ++group) {
                    this.addFolderToPath(path, matcher, group);
                }
            }
        }
        path.add(key);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("returning " + path + " for key: " + key));
        }
        return path;
    }

    private void addFolderToPath(List<String> path, Matcher matcher, int group) {
        String folder = matcher.group(group);
        if (folder.length() > 0) {
            path.add(folder);
        }
    }
}

