/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;

public class TestGroupManager {
    private final AuthorityService authorityService;
    private final SearchService searchService;
    private final Map<String, NodeRef> groups = new HashMap<String, NodeRef>();

    public TestGroupManager(AuthorityService authorityService, SearchService searchService) {
        this.authorityService = authorityService;
        this.searchService = searchService;
    }

    public String createGroupIfNotExist(String groupShortName) {
        String fullName = this.authorityService.getName(AuthorityType.GROUP, groupShortName);
        if (!this.groups.containsKey(groupShortName) && !this.authorityService.authorityExists(fullName)) {
            HashSet<String> zones = new HashSet<String>(2, 1.0f);
            zones.add("APP.DEFAULT");
            fullName = this.authorityService.createAuthority(AuthorityType.GROUP, groupShortName, groupShortName, zones);
            this.groups.put(groupShortName, this.findGroupNode(groupShortName));
        }
        return fullName;
    }

    public String addGroupToParent(String parentGroupShortName, String childGroupShortName) {
        String parentFullName = this.createGroupIfNotExist(parentGroupShortName);
        String groupFullName = this.createGroupIfNotExist(childGroupShortName);
        this.authorityService.addAuthority(parentFullName, groupFullName);
        return groupFullName;
    }

    public void addUserToGroup(String groupShortName, String userName) {
        String fullGroupName = this.createGroupIfNotExist(groupShortName);
        this.authorityService.addAuthority(fullGroupName, userName);
    }

    public void deleteGroup(String groupShortName) {
        String groupFullName = this.authorityService.getName(AuthorityType.GROUP, groupShortName);
        if (this.authorityService.authorityExists(groupFullName)) {
            this.authorityService.deleteAuthority(groupFullName);
        }
    }

    public void clearGroups() {
        for (String group : this.groups.keySet()) {
            String fullName = this.authorityService.getName(AuthorityType.GROUP, group);
            if (!this.authorityService.authorityExists(fullName)) continue;
            this.authorityService.deleteAuthority(fullName);
        }
        this.groups.clear();
    }

    public NodeRef get(String groupShortName) {
        NodeRef result = this.groups.get(groupShortName);
        if (result == null) {
            result = this.findGroupNode(groupShortName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NodeRef findGroupNode(String groupShortName) {
        NodeRef group = null;
        String query = "+TYPE:\"cm:authorityContainer\" AND @cm\\:authorityName:*" + groupShortName;
        ResultSet results = null;
        try {
            results = this.searchService.query(new StoreRef("workspace", "SpacesStore"), "lucene", query);
            if (results.length() > 0) {
                group = (NodeRef)results.getNodeRefs().get(0);
            }
            Object var6_5 = null;
            if (results == null) return group;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (results == null) throw throwable;
            results.close();
            throw throwable;
        }
        results.close();
        return group;
    }
}

