/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.solr;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.solr.Acl;
import org.alfresco.repo.solr.AclChangeSet;
import org.alfresco.repo.solr.AlfrescoModelDiff;
import org.alfresco.repo.solr.MetaDataResultsFilter;
import org.alfresco.repo.solr.NodeMetaData;
import org.alfresco.repo.solr.NodeMetaDataParameters;
import org.alfresco.repo.solr.NodeParameters;
import org.alfresco.repo.solr.SOLRTrackingComponent;
import org.alfresco.repo.solr.Transaction;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOLRTrackingComponentTest
extends TestCase {
    private static final Log logger = LogFactory.getLog(SOLRTrackingComponentTest.class);
    private ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private TransactionService transactionService;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private RetryingTransactionHelper txnHelper;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private NodeDAO nodeDAO;
    private DictionaryDAO dictionaryDAO;
    private SOLRTrackingComponent solrTrackingComponent;
    private StoreRef storeRef;
    private NodeRef rootNodeRef;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.solrTrackingComponent = (SOLRTrackingComponent)this.ctx.getBean("solrTrackingComponent");
        this.nodeDAO = (NodeDAO)this.ctx.getBean("nodeDAO");
        this.dictionaryDAO = (DictionaryDAO)this.ctx.getBean("dictionaryDAO");
        this.nodeService = (NodeService)this.ctx.getBean("NodeService");
        this.fileFolderService = (FileFolderService)this.ctx.getBean("FileFolderService");
        this.dictionaryService = serviceRegistry.getDictionaryService();
        this.namespaceService = serviceRegistry.getNamespaceService();
        this.authenticationComponent = (AuthenticationComponent)this.ctx.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.storeRef = this.nodeService.createStore("workspace", this.getName() + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
    }

    public void testAclChnageSetLimits() {
        List<AclChangeSet> aclChangeSets = this.solrTrackingComponent.getAclChangeSets(null, null, null, null, 50);
        Long first = aclChangeSets.get(0).getId();
        Long firstTime = aclChangeSets.get(1).getId();
        List<AclChangeSet> testSets = this.solrTrackingComponent.getAclChangeSets(first, null, first, null, 50);
        SOLRTrackingComponentTest.assertEquals((int)0, (int)testSets.size());
        testSets = this.solrTrackingComponent.getAclChangeSets(first, firstTime, first + 1L, firstTime, 50);
        SOLRTrackingComponentTest.assertEquals((int)0, (int)testSets.size());
        testSets = this.solrTrackingComponent.getAclChangeSets(first, firstTime, first + 1L, firstTime + 1L, 50);
        SOLRTrackingComponentTest.assertEquals((int)0, (int)testSets.size());
    }

    public void testGetAcls_Simple() {
        List<Acl> acls;
        List<AclChangeSet> cs = this.solrTrackingComponent.getAclChangeSets(null, null, null, null, 50);
        SOLRTrackingComponentTest.assertTrue((String)"Expected results to be limited in number", (cs.size() <= 50 ? 1 : 0) != 0);
        ArrayList<Long> aclChangeSetIds = new ArrayList<Long>(50);
        int totalAcls = 0;
        for (AclChangeSet aclChangeSet : cs) {
            aclChangeSetIds.add(aclChangeSet.getId());
            totalAcls += aclChangeSet.getAclCount();
        }
        int totalAclsCheck = 0;
        Long fromAclId = null;
        while ((acls = this.solrTrackingComponent.getAcls(aclChangeSetIds, fromAclId, 2)).size() != 0) {
            totalAclsCheck += acls.size();
            fromAclId = acls.get(acls.size() - 1).getId() + 1L;
        }
        SOLRTrackingComponentTest.assertEquals((String)"ACL count should have matched", (int)totalAcls, (int)totalAclsCheck);
    }

    public void testGetNodeMetaData() {
        long startTime = System.currentTimeMillis();
        SOLRTest3 st = new SOLRTest3(this.txnHelper, this.fileFolderService, this.nodeDAO, this.nodeService, this.dictionaryService, this.rootNodeRef, "testGetNodeMetaData", true, true);
        List<Long> createdTransactions = st.buildTransactions();
        List<Transaction> txns = this.solrTrackingComponent.getTransactions(null, startTime, null, null, 50);
        int[] updates = new int[]{1, 1};
        int[] deletes = new int[]{0, 1};
        List<Transaction> checkedTransactions = this.checkTransactions(txns, createdTransactions, updates, deletes);
        NodeParameters nodeParameters = new NodeParameters();
        nodeParameters.setTransactionIds(this.getTransactionIds(checkedTransactions));
        this.getNodes(nodeParameters, st);
        NodeMetaDataParameters nodeMetaDataParams = new NodeMetaDataParameters();
        nodeMetaDataParams.setNodeIds(st.getNodeIds());
        this.getNodeMetaData(nodeMetaDataParams, null, st);
    }

    private List<Long> getTransactionIds(List<Transaction> checkedTransactions) {
        ArrayList<Long> txIds = new ArrayList<Long>(checkedTransactions.size());
        for (Transaction txn : checkedTransactions) {
            txIds.add(txn.getId());
        }
        return txIds;
    }

    public void testGetTransactionLimits() {
        long startTime = System.currentTimeMillis();
        SOLRTest3 st = new SOLRTest3(this.txnHelper, this.fileFolderService, this.nodeDAO, this.nodeService, this.dictionaryService, this.rootNodeRef, "testGetNodeMetaData", true, true);
        List<Long> createdTransactions = st.buildTransactions();
        List<Transaction> txns = this.solrTrackingComponent.getTransactions(null, startTime, null, null, 50);
        int[] updates = new int[]{1, 1};
        int[] deletes = new int[]{0, 1};
        List<Transaction> checkedTransactions = this.checkTransactions(txns, createdTransactions, updates, deletes);
        Long first = checkedTransactions.get(0).getId();
        Long firstTime = checkedTransactions.get(0).getCommitTimeMs();
        Long last = checkedTransactions.get(1).getId();
        Long lastTime = checkedTransactions.get(1).getCommitTimeMs();
        txns = this.solrTrackingComponent.getTransactions(first, null, first, null, 50);
        SOLRTrackingComponentTest.assertEquals((int)0, (int)txns.size());
        txns = this.solrTrackingComponent.getTransactions(first, null, first + 1L, null, 50);
        updates = new int[]{1};
        deletes = new int[]{0};
        ArrayList<Long> createdTransactionFirst = new ArrayList<Long>(1);
        createdTransactionFirst.add(createdTransactions.get(0));
        this.checkTransactions(txns, createdTransactionFirst, updates, deletes);
        txns = this.solrTrackingComponent.getTransactions(first, firstTime, first + 1L, firstTime + 1L, 50);
        this.checkTransactions(txns, createdTransactionFirst, updates, deletes);
        txns = this.solrTrackingComponent.getTransactions(first, firstTime - 1L, first + 1L, firstTime, 50);
        SOLRTrackingComponentTest.assertEquals((int)0, (int)txns.size());
        txns = this.solrTrackingComponent.getTransactions(last, null, last, null, 50);
        SOLRTrackingComponentTest.assertEquals((int)0, (int)txns.size());
        txns = this.solrTrackingComponent.getTransactions(last, null, last + 1L, null, 50);
        updates = new int[]{1};
        deletes = new int[]{1};
        ArrayList<Long> createdTransactionLast = new ArrayList<Long>(1);
        createdTransactionLast.add(createdTransactions.get(1));
        this.checkTransactions(txns, createdTransactionLast, updates, deletes);
        txns = this.solrTrackingComponent.getTransactions(last, lastTime, last + 1L, lastTime + 1L, 50);
        this.checkTransactions(txns, createdTransactionLast, updates, deletes);
        txns = this.solrTrackingComponent.getTransactions(last, lastTime - 1L, last + 1L, lastTime, 50);
        SOLRTrackingComponentTest.assertEquals((int)0, (int)txns.size());
    }

    public void testGetNodeMetaDataExludesResidualProperties() {
        long startTime = System.currentTimeMillis();
        SOLRTestResidualProperties st = new SOLRTestResidualProperties(this.txnHelper, this.fileFolderService, this.nodeDAO, this.nodeService, this.dictionaryService, this.rootNodeRef, "testNodeMetaDataNullPropertyValue", true, true);
        List<Long> createdTransactions = st.buildTransactions();
        List<Transaction> txns = this.solrTrackingComponent.getTransactions(null, startTime, null, null, 50);
        int[] updates = new int[]{2};
        int[] deletes = new int[]{0};
        List<Transaction> checkedTransactions = this.checkTransactions(txns, createdTransactions, updates, deletes);
        NodeParameters nodeParameters = new NodeParameters();
        nodeParameters.setTransactionIds(this.getTransactionIds(checkedTransactions));
        this.getNodes(nodeParameters, st);
        NodeMetaDataParameters nodeMetaDataParams = new NodeMetaDataParameters();
        nodeMetaDataParams.setNodeIds(st.getNodeIds());
        this.getNodeMetaData(nodeMetaDataParams, null, st);
    }

    public void testGetNodeMetaData100Nodes() {
        long startTime = System.currentTimeMillis();
        SOLRTest100Nodes st = new SOLRTest100Nodes(this.txnHelper, this.fileFolderService, this.nodeDAO, this.nodeService, this.dictionaryService, this.rootNodeRef, "testGetNodeMetaData", true, true);
        List<Long> createdTransactions = st.buildTransactions();
        List<Transaction> txns = this.solrTrackingComponent.getTransactions(null, startTime, null, null, 50);
        int[] updates = new int[]{100};
        int[] deletes = new int[]{0};
        List<Transaction> checkedTransactions = this.checkTransactions(txns, createdTransactions, updates, deletes);
        NodeParameters nodeParameters = new NodeParameters();
        nodeParameters.setTransactionIds(this.getTransactionIds(checkedTransactions));
        this.getNodes(nodeParameters, st);
        NodeMetaDataParameters nodeMetaDataParams = new NodeMetaDataParameters();
        nodeMetaDataParams.setNodeIds(st.getNodeIds());
        this.getNodeMetaData(nodeMetaDataParams, null, st);
        nodeMetaDataParams.setMaxResults(20);
        this.getNodeMetaData(nodeMetaDataParams, null, st);
    }

    public void testNodeMetaDataManyNodes() throws Exception {
        long fromCommitTime = System.currentTimeMillis();
        SOLRTest4 st = new SOLRTest4(this.txnHelper, this.fileFolderService, this.nodeDAO, this.nodeService, this.dictionaryService, this.rootNodeRef, "testNodeMetaDataManyNodes", true, false);
        List<Long> createdTransactions = st.buildTransactions();
        List<Transaction> txns = this.solrTrackingComponent.getTransactions(null, fromCommitTime, null, null, 50);
        int[] updates = new int[]{2001};
        int[] deletes = new int[]{0};
        List<Transaction> checkedTransactions = this.checkTransactions(txns, createdTransactions, updates, deletes);
        NodeParameters nodeParameters = new NodeParameters();
        nodeParameters.setTransactionIds(this.getTransactionIds(checkedTransactions));
        this.getNodes(nodeParameters, st);
        logger.debug((Object)"Cold cache");
        NodeMetaDataParameters nodeMetaDataParams = new NodeMetaDataParameters();
        nodeMetaDataParams.setNodeIds(st.getNodeIds());
        this.getNodeMetaData(nodeMetaDataParams, null, st);
        this.getNodeMetaData(nodeMetaDataParams, null, st);
        logger.debug((Object)"Warm cache");
        this.getNodeMetaData(nodeMetaDataParams, null, st);
        this.nodeDAO.clear();
        logger.debug((Object)"Cold cache - explicit clear");
        nodeMetaDataParams.setMaxResults(800);
        this.getNodeMetaData(nodeMetaDataParams, null, st);
        this.getNodeMetaData(nodeMetaDataParams, null, st);
        logger.debug((Object)"Warm cache");
        this.getNodeMetaData(nodeMetaDataParams, null, st);
        logger.debug((Object)"Cold cache - explicit clear");
        nodeMetaDataParams.setMaxResults(500);
        this.getNodeMetaData(nodeMetaDataParams, null, st);
        this.getNodeMetaData(nodeMetaDataParams, null, st);
        logger.debug((Object)"Warm cache");
        this.getNodeMetaData(nodeMetaDataParams, null, st);
        logger.debug((Object)"Cold cache - explicit clear");
        nodeMetaDataParams.setMaxResults(200);
        this.getNodeMetaData(nodeMetaDataParams, null, st);
        this.getNodeMetaData(nodeMetaDataParams, null, st);
        logger.debug((Object)"Warm cache");
        this.getNodeMetaData(nodeMetaDataParams, null, st);
        this.nodeDAO.clear();
        logger.debug((Object)"Cold cache - explicit clear");
        this.getNodeMetaData(nodeMetaDataParams, null, st);
    }

    public void testNodeMetaDataCache() throws Exception {
        long fromCommitTime = System.currentTimeMillis();
        SOLRTest4 st = new SOLRTest4(this.txnHelper, this.fileFolderService, this.nodeDAO, this.nodeService, this.dictionaryService, this.rootNodeRef, "testNodeMetaDataManyNodes", true, false);
        List<Long> createdTransactions = st.buildTransactions();
        List<Transaction> txns = this.solrTrackingComponent.getTransactions(null, fromCommitTime, null, null, 50);
        int[] updates = new int[]{2001};
        int[] deletes = new int[]{0};
        List<Transaction> checkedTransactions = this.checkTransactions(txns, createdTransactions, updates, deletes);
        NodeParameters nodeParameters = new NodeParameters();
        nodeParameters.setTransactionIds(this.getTransactionIds(checkedTransactions));
        this.getNodes(nodeParameters, st);
        this.nodeDAO.clear();
        logger.debug((Object)"Cold cache - explicit clear");
        NodeMetaDataParameters nodeMetaDataParams = new NodeMetaDataParameters();
        nodeMetaDataParams.setNodeIds(st.getNodeIds());
        MetaDataResultsFilter filter = new MetaDataResultsFilter();
        filter.setIncludeParentAssociations(false);
        filter.setIncludeChildAssociations(false);
        this.getNodeMetaData(nodeMetaDataParams, filter, st);
    }

    public void testNodeMetaDataNullPropertyValue() throws Exception {
        long fromCommitTime = System.currentTimeMillis();
        SOLRTest5 st = new SOLRTest5(this.txnHelper, this.fileFolderService, this.nodeDAO, this.nodeService, this.dictionaryService, this.rootNodeRef, "testNodeMetaDataNullPropertyValue", true, true);
        List<Long> createdTransactions = st.buildTransactions();
        List<Transaction> txns = this.solrTrackingComponent.getTransactions(null, fromCommitTime, null, null, 50);
        int[] updates = new int[]{11};
        int[] deletes = new int[]{0};
        List<Transaction> checkedTransactions = this.checkTransactions(txns, createdTransactions, updates, deletes);
        NodeParameters nodeParameters = new NodeParameters();
        nodeParameters.setTransactionIds(this.getTransactionIds(checkedTransactions));
        this.getNodes(nodeParameters, st);
        NodeMetaDataParameters nodeMetaDataParams = new NodeMetaDataParameters();
        nodeMetaDataParams.setNodeIds(st.getNodeIds());
        this.getNodeMetaData(nodeMetaDataParams, null, st);
    }

    public void testFilters() {
        long startTime = System.currentTimeMillis();
        SOLRTest1 st = new SOLRTest1(this.txnHelper, this.fileFolderService, this.nodeDAO, this.nodeService, this.dictionaryService, this.rootNodeRef, "testFilters", true, true);
        List<Long> createdTransactions = st.buildTransactions();
        List<Transaction> txns = this.solrTrackingComponent.getTransactions(null, startTime, null, null, 50);
        int[] updates = new int[]{1, 1};
        int[] deletes = new int[]{0, 1};
        List<Transaction> checkedTransactions = this.checkTransactions(txns, createdTransactions, updates, deletes);
        NodeParameters nodeParameters = new NodeParameters();
        nodeParameters.setTransactionIds(this.getTransactionIds(checkedTransactions));
        this.getNodes(nodeParameters, st);
        NodeMetaDataParameters nodeMetaDataParams = new NodeMetaDataParameters();
        nodeMetaDataParams.setNodeIds(st.getNodeIds());
        this.getNodeMetaData(nodeMetaDataParams, null, st);
    }

    public void testModelDiffs() {
        Collection allModels = this.dictionaryService.getAllModels();
        ModelDiffsTracker tracker = new ModelDiffsTracker();
        ModelDiffResults diffResults = tracker.diff();
        SOLRTrackingComponentTest.assertEquals((String)"Unexpected number of new models", (int)allModels.size(), (int)diffResults.getNewModels().size());
        SOLRTrackingComponentTest.assertEquals((String)"Expected no removed models", (int)0, (int)diffResults.getRemovedModels().size());
        SOLRTrackingComponentTest.assertEquals((String)"Expected no changed models", (int)0, (int)diffResults.getChangedModels().size());
        InputStream modelStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/solr/testModel.xml");
        M2Model testModel = M2Model.createModel((InputStream)modelStream);
        this.dictionaryDAO.putModel(testModel);
        ModelDiffResults diffResults1 = tracker.diff();
        SOLRTrackingComponentTest.assertEquals((String)"Expected 1 new model", (int)1, (int)diffResults1.getNewModels().size());
        SOLRTrackingComponentTest.assertEquals((String)"Unexpected number of changed models", (int)0, (int)diffResults1.getChangedModels().size());
        SOLRTrackingComponentTest.assertEquals((String)"Unexpected number of removed models", (int)0, (int)diffResults1.getRemovedModels().size());
        AlfrescoModelDiff diff = diffResults1.getNewModels().get(0);
        SOLRTrackingComponentTest.assertEquals((String)"Unexpected model name change", (String)QName.createQName((String)testModel.getName(), (NamespacePrefixResolver)this.namespaceService).toString(), (String)diff.getModelName());
        Long testModelChecksum = tracker.getChecksum(QName.createQName((String)testModel.getName(), (NamespacePrefixResolver)this.namespaceService));
        SOLRTrackingComponentTest.assertNotNull((String)"", (Object)testModelChecksum);
        M2Type anotherType = testModel.createType("anothertype");
        M2Property prop1 = anotherType.createProperty("prop1");
        prop1.setType("d:text");
        ModelDiffResults diffResults2 = tracker.diff();
        List<AlfrescoModelDiff> changedModels = diffResults2.getChangedModels();
        SOLRTrackingComponentTest.assertEquals((String)"Expected no new models", (int)0, (int)diffResults2.getNewModels().size());
        SOLRTrackingComponentTest.assertEquals((String)"Expected no removed models", (int)0, (int)diffResults2.getRemovedModels().size());
        SOLRTrackingComponentTest.assertEquals((String)"Expected detection of changed testmodel", (int)1, (int)changedModels.size());
        AlfrescoModelDiff changedModel = changedModels.get(0);
        SOLRTrackingComponentTest.assertEquals((String)"Unexpected changed model name", (String)QName.createQName((String)testModel.getName(), (NamespacePrefixResolver)this.namespaceService).toString(), (String)changedModel.getModelName());
        SOLRTrackingComponentTest.assertNotNull((String)"", (Object)changedModel.getOldChecksum());
        SOLRTrackingComponentTest.assertEquals((String)"Old checksum value is incorrect", (long)testModelChecksum, (long)changedModel.getOldChecksum());
        SOLRTrackingComponentTest.assertNotSame((String)"Expected checksums to be different", (Object)changedModel.getOldChecksum(), (Object)changedModel.getNewChecksum());
        this.dictionaryDAO.removeModel(QName.createQName((String)testModel.getName(), (NamespacePrefixResolver)this.namespaceService));
        ModelDiffResults diffResults3 = tracker.diff();
        List<AlfrescoModelDiff> removedModels = diffResults3.getRemovedModels();
        SOLRTrackingComponentTest.assertEquals((String)"Expected 1 removed model", (int)1, (int)removedModels.size());
        QName removedModelName = QName.createQName((String)removedModels.get(0).getModelName());
        String removedModelNamespace = removedModelName.getNamespaceURI();
        String removedModelLocalName = removedModelName.getLocalName();
        SOLRTrackingComponentTest.assertEquals((String)"Removed model namespace is incorrect", (String)"http://www.alfresco.org/model/solrtest/1.0", (String)removedModelNamespace);
        SOLRTrackingComponentTest.assertEquals((String)"Removed model name is incorrect", (String)"contentmodel", (String)removedModelLocalName);
        SOLRTrackingComponentTest.assertEquals((String)"Expected no new models", (int)0, (int)diffResults3.getNewModels().size());
        SOLRTrackingComponentTest.assertEquals((String)"Expected no changed modeks", (int)0, (int)diffResults3.getChangedModels().size());
    }

    private List<Transaction> checkTransactions(List<Transaction> txns, List<Long> createdTransaction, int[] updates, int[] deletes) {
        ArrayList<Transaction> matchedTransactions = new ArrayList<Transaction>();
        HashSet<Long> toMatch = new HashSet<Long>();
        toMatch.addAll(createdTransaction);
        for (Transaction found : txns) {
            if (found == null || !toMatch.contains(found.getId())) continue;
            matchedTransactions.add(found);
        }
        SOLRTrackingComponentTest.assertEquals((String)"Number of transactions is incorrect", (int)createdTransaction.size(), (int)matchedTransactions.size());
        int i = 0;
        for (Transaction txn : matchedTransactions) {
            SOLRTrackingComponentTest.assertEquals((String)"Number of deletes is incorrect", (int)deletes[i], (int)txn.getDeletes());
            SOLRTrackingComponentTest.assertEquals((String)"Number of updates is incorrect", (int)updates[i], (int)txn.getUpdates());
            ++i;
        }
        return matchedTransactions;
    }

    private void getNodes(NodeParameters nodeParameters, SOLRTest bt) {
        long startTime = System.currentTimeMillis();
        this.solrTrackingComponent.getNodes(nodeParameters, bt);
        long endTime = System.currentTimeMillis();
        bt.runNodeChecks(nodeParameters.getMaxResults());
        logger.debug((Object)("Got " + bt.getActualNodeCount() + " nodes in " + (endTime - startTime) + " ms"));
    }

    private void getNodeMetaData(final NodeMetaDataParameters params, final MetaDataResultsFilter filter, final SOLRTest bt) {
        bt.clearNodesMetaData();
        long startTime = System.currentTimeMillis();
        this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                SOLRTrackingComponentTest.this.solrTrackingComponent.getNodesMetadata(params, filter, bt);
                return null;
            }
        }, true, true);
        long endTime = System.currentTimeMillis();
        bt.runNodeMetaDataChecks(params.getMaxResults());
        logger.debug((Object)("Got " + bt.getActualNodeMetaDataCount() + " node metadatas in " + (endTime - startTime) + " ms"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SOLRTestResidualProperties
    extends SOLRTest {
        private NodeRef container;
        private NodeRef content;

        SOLRTestResidualProperties(RetryingTransactionHelper txnHelper, FileFolderService fileFolderService, NodeDAO nodeDAO, NodeService nodeService, DictionaryService dictionaryService, NodeRef rootNodeRef, String containerName, boolean doNodeChecks, boolean doMetaDataChecks) {
            super(txnHelper, fileFolderService, nodeDAO, nodeService, dictionaryService, rootNodeRef, containerName, doNodeChecks, doMetaDataChecks);
        }

        @Override
        public int getExpectedNumNodes() {
            return 2;
        }

        @Override
        protected List<Long> buildTransactionsInternal() {
            ArrayList<Long> txs = new ArrayList<Long>(2);
            txs.add(this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                @Override
                public Long execute() throws Throwable {
                    PropertyMap props = new PropertyMap();
                    props.put(ContentModel.PROP_NAME, "ContainerResidual");
                    SOLRTestResidualProperties.this.container = SOLRTestResidualProperties.this.nodeService.createNode(SOLRTestResidualProperties.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, (Map)props).getChildRef();
                    FileInfo contentInfo = SOLRTestResidualProperties.this.fileFolderService.create(SOLRTestResidualProperties.this.container, "ContentResidual", ContentModel.TYPE_CONTENT);
                    SOLRTestResidualProperties.this.content = contentInfo.getNodeRef();
                    SOLRTestResidualProperties.this.nodeService.setProperty(SOLRTestResidualProperties.this.content, QName.createQName((String)"{rubbish}rubbish"), (Serializable)((Object)"Rubbish"));
                    return SOLRTestResidualProperties.this.nodeDAO.getNodeRefStatus(SOLRTestResidualProperties.this.container).getDbTxnId();
                }
            }));
            this.setExpectedNodeStatus(this.container, NodeStatus.UPDATED);
            this.setExpectedNodeStatus(this.content, NodeStatus.UPDATED);
            return txs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SOLRTest5
    extends SOLRTest {
        private int numContentNodes = 10;

        SOLRTest5(RetryingTransactionHelper txnHelper, FileFolderService fileFolderService, NodeDAO nodeDAO, NodeService nodeService, DictionaryService dictionaryService, NodeRef rootNodeRef, String containerName, boolean doNodeChecks, boolean doMetaDataChecks) {
            super(txnHelper, fileFolderService, nodeDAO, nodeService, dictionaryService, rootNodeRef, containerName, doNodeChecks, doMetaDataChecks);
        }

        @Override
        public int getExpectedNumNodes() {
            return this.numContentNodes + 1;
        }

        @Override
        public List<Long> buildTransactionsInternal() {
            ArrayList<Long> txs = new ArrayList<Long>(2);
            final String[] titles = new String[]{"caf\u00e9", "\u00e7edilla", "\u00e0\u00e1\u00e2\u00e3", "\u00ec\u00ed\u00ee\u00ef", "\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6", "caf\u00e9", "\u00e7edilla", "\u00e0\u00e1\u00e2\u00e3", "\u00ec\u00ed\u00ee\u00ef", "\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6"};
            txs.add(this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                @Override
                public Long execute() throws Throwable {
                    PropertyMap props = new PropertyMap();
                    props.put(ContentModel.PROP_NAME, SOLRTest5.this.containerName);
                    NodeRef container = SOLRTest5.this.nodeService.createNode(SOLRTest5.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, (Map)props).getChildRef();
                    SOLRTest5.this.setExpectedNodeStatus(container, NodeStatus.UPDATED);
                    for (int i = 0; i < SOLRTest5.this.numContentNodes; ++i) {
                        FileInfo contentInfo = SOLRTest5.this.fileFolderService.create(container, "Content" + i, ContentModel.TYPE_CONTENT);
                        NodeRef nodeRef = contentInfo.getNodeRef();
                        SOLRTest5.this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_AUTHOR, null);
                        if (i % 5 == 1) {
                            SOLRTest5.this.nodeService.setProperty(nodeRef, ContentModel.PROP_AUTHOR, null);
                        } else {
                            SOLRTest5.this.nodeService.setProperty(nodeRef, ContentModel.PROP_AUTHOR, (Serializable)((Object)("author" + i)));
                        }
                        SOLRTest5.this.nodeService.setProperty(nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)titles[i]));
                        SOLRTest5.this.setExpectedNodeStatus(nodeRef, NodeStatus.UPDATED);
                    }
                    return SOLRTest5.this.nodeDAO.getNodeRefStatus(container).getDbTxnId();
                }
            }));
            return txs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SOLRTest4
    extends SOLRTest {
        private int numContentNodes = 2000;

        SOLRTest4(RetryingTransactionHelper txnHelper, FileFolderService fileFolderService, NodeDAO nodeDAO, NodeService nodeService, DictionaryService dictionaryService, NodeRef rootNodeRef, String containerName, boolean doNodeChecks, boolean doMetaDataChecks) {
            super(txnHelper, fileFolderService, nodeDAO, nodeService, dictionaryService, rootNodeRef, containerName, doNodeChecks, doMetaDataChecks);
        }

        @Override
        public int getExpectedNumNodes() {
            return this.numContentNodes + 1;
        }

        @Override
        public List<Long> buildTransactionsInternal() {
            ArrayList<Long> txs = new ArrayList<Long>(2);
            txs.add(this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                @Override
                public Long execute() throws Throwable {
                    PropertyMap props = new PropertyMap();
                    props.put(ContentModel.PROP_NAME, SOLRTest4.this.containerName);
                    NodeRef container = SOLRTest4.this.nodeService.createNode(SOLRTest4.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, (Map)props).getChildRef();
                    SOLRTest4.this.setExpectedNodeStatus(container, NodeStatus.UPDATED);
                    for (int i = 0; i < SOLRTest4.this.numContentNodes; ++i) {
                        FileInfo contentInfo = SOLRTest4.this.fileFolderService.create(container, "Content" + i, ContentModel.TYPE_CONTENT);
                        NodeRef nodeRef = contentInfo.getNodeRef();
                        if (i % 2 == 1) {
                            SOLRTest4.this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TEMPORARY, null);
                        }
                        SOLRTest4.this.nodeService.setProperty(nodeRef, ContentModel.PROP_AUTHOR, null);
                        SOLRTest4.this.setExpectedNodeStatus(nodeRef, NodeStatus.UPDATED);
                    }
                    return SOLRTest4.this.nodeDAO.getNodeRefStatus(container).getDbTxnId();
                }
            }));
            return txs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SOLRTest100Nodes
    extends SOLRTest {
        SOLRTest100Nodes(RetryingTransactionHelper txnHelper, FileFolderService fileFolderService, NodeDAO nodeDAO, NodeService nodeService, DictionaryService dictionaryService, NodeRef rootNodeRef, String containerName, boolean doNodeChecks, boolean doMetaDataChecks) {
            super(txnHelper, fileFolderService, nodeDAO, nodeService, dictionaryService, rootNodeRef, containerName, doNodeChecks, doMetaDataChecks);
        }

        @Override
        public int getExpectedNumNodes() {
            return 100;
        }

        @Override
        protected List<Long> buildTransactionsInternal() {
            ArrayList<Long> txs = new ArrayList<Long>(2);
            txs.add(this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                @Override
                public Long execute() throws Throwable {
                    PropertyMap props = new PropertyMap();
                    props.put(ContentModel.PROP_NAME, "Container100Nodes");
                    NodeRef container = SOLRTest100Nodes.this.nodeService.createNode(SOLRTest100Nodes.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, (Map)props).getChildRef();
                    SOLRTest100Nodes.this.setExpectedNodeStatus(container, NodeStatus.UPDATED);
                    for (int i = 0; i < 99; ++i) {
                        FileInfo contentInfo = SOLRTest100Nodes.this.fileFolderService.create(container, "Content" + i, ContentModel.TYPE_CONTENT);
                        NodeRef nodeRef = contentInfo.getNodeRef();
                        SOLRTest100Nodes.this.setExpectedNodeStatus(nodeRef, NodeStatus.UPDATED);
                    }
                    return SOLRTest100Nodes.this.nodeDAO.getNodeRefStatus(container).getDbTxnId();
                }
            }));
            return txs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SOLRTest3
    extends SOLRTest {
        private NodeRef container;
        private NodeRef content1;
        private NodeRef content2;

        SOLRTest3(RetryingTransactionHelper txnHelper, FileFolderService fileFolderService, NodeDAO nodeDAO, NodeService nodeService, DictionaryService dictionaryService, NodeRef rootNodeRef, String containerName, boolean doNodeChecks, boolean doMetaDataChecks) {
            super(txnHelper, fileFolderService, nodeDAO, nodeService, dictionaryService, rootNodeRef, containerName, doNodeChecks, doMetaDataChecks);
        }

        @Override
        public int getExpectedNumNodes() {
            return 3;
        }

        @Override
        protected List<Long> buildTransactionsInternal() {
            ArrayList<Long> txs = new ArrayList<Long>(2);
            txs.add(this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                @Override
                public Long execute() throws Throwable {
                    PropertyMap props = new PropertyMap();
                    props.put(ContentModel.PROP_NAME, "Container1");
                    SOLRTest3.this.container = SOLRTest3.this.nodeService.createNode(SOLRTest3.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, (Map)props).getChildRef();
                    FileInfo contentInfo = SOLRTest3.this.fileFolderService.create(SOLRTest3.this.container, "Content1", ContentModel.TYPE_CONTENT);
                    SOLRTest3.this.content1 = contentInfo.getNodeRef();
                    HashMap<QName, String> aspectProperties = new HashMap<QName, String>();
                    aspectProperties.put(ContentModel.PROP_AUTHOR, "steve");
                    SOLRTest3.this.nodeService.addAspect(SOLRTest3.this.content1, ContentModel.ASPECT_AUTHOR, aspectProperties);
                    return SOLRTest3.this.nodeDAO.getNodeRefStatus(SOLRTest3.this.content1).getDbTxnId();
                }
            }));
            txs.add(this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                @Override
                public Long execute() throws Throwable {
                    FileInfo contentInfo = SOLRTest3.this.fileFolderService.create(SOLRTest3.this.container, "Content2", ContentModel.TYPE_CONTENT);
                    SOLRTest3.this.content2 = contentInfo.getNodeRef();
                    SOLRTest3.this.nodeService.addAspect(SOLRTest3.this.content2, ContentModel.ASPECT_TEMPORARY, null);
                    SOLRTest3.this.fileFolderService.delete(SOLRTest3.this.content1);
                    return SOLRTest3.this.nodeDAO.getNodeRefStatus(SOLRTest3.this.content1).getDbTxnId();
                }
            }));
            this.setExpectedNodeStatus(this.container, NodeStatus.UPDATED);
            this.setExpectedNodeStatus(this.content1, NodeStatus.DELETED);
            this.setExpectedNodeStatus(this.content2, NodeStatus.UPDATED);
            return txs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SOLRTest1
    extends SOLRTest {
        private NodeRef container;
        private NodeRef content1;
        private NodeRef content2;

        SOLRTest1(RetryingTransactionHelper txnHelper, FileFolderService fileFolderService, NodeDAO nodeDAO, NodeService nodeService, DictionaryService dictionaryService, NodeRef rootNodeRef, String containerName, boolean doNodeChecks, boolean doMetaDataChecks) {
            super(txnHelper, fileFolderService, nodeDAO, nodeService, dictionaryService, rootNodeRef, containerName, doNodeChecks, doMetaDataChecks);
        }

        @Override
        public int getExpectedNumNodes() {
            return 3;
        }

        @Override
        protected List<Long> buildTransactionsInternal() {
            ArrayList<Long> txs = new ArrayList<Long>(2);
            txs.add(this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                @Override
                public Long execute() throws Throwable {
                    PropertyMap props = new PropertyMap();
                    props.put(ContentModel.PROP_NAME, "Container1");
                    SOLRTest1.this.container = SOLRTest1.this.nodeService.createNode(SOLRTest1.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, (Map)props).getChildRef();
                    FileInfo contentInfo = SOLRTest1.this.fileFolderService.create(SOLRTest1.this.container, "Content1", ContentModel.TYPE_CONTENT);
                    SOLRTest1.this.content1 = contentInfo.getNodeRef();
                    return SOLRTest1.this.nodeDAO.getNodeRefStatus(SOLRTest1.this.content1).getDbTxnId();
                }
            }));
            txs.add(this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                @Override
                public Long execute() throws Throwable {
                    FileInfo contentInfo = SOLRTest1.this.fileFolderService.create(SOLRTest1.this.container, "Content2", ContentModel.TYPE_CONTENT);
                    SOLRTest1.this.content2 = contentInfo.getNodeRef();
                    SOLRTest1.this.fileFolderService.delete(SOLRTest1.this.content1);
                    return SOLRTest1.this.nodeDAO.getNodeRefStatus(SOLRTest1.this.content1).getDbTxnId();
                }
            }));
            this.setExpectedNodeStatus(this.container, NodeStatus.UPDATED);
            this.setExpectedNodeStatus(this.content1, NodeStatus.DELETED);
            this.setExpectedNodeStatus(this.content2, NodeStatus.UPDATED);
            return txs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class SOLRTest
    implements SOLRTrackingComponent.NodeQueryCallback,
    SOLRTrackingComponent.NodeMetaDataQueryCallback {
        protected FileFolderService fileFolderService;
        protected RetryingTransactionHelper txnHelper;
        protected NodeService nodeService;
        protected NodeRef rootNodeRef;
        protected NodeDAO nodeDAO;
        protected DictionaryService dictionaryService;
        protected String containerName;
        protected Map<NodeRef, NodeAssertions> nodeAssertions;
        protected boolean doChecks;
        protected boolean doNodeChecks;
        protected boolean doMetaDataChecks;
        protected int successCount = 0;
        protected int failureCount = 0;
        protected List<Long> nodeIds;
        protected long expectedNumMetaDataNodes = 0L;
        protected long actualNodeCount = 0L;
        protected long actualNodeMetaDataCount = 0L;

        SOLRTest(RetryingTransactionHelper txnHelper, FileFolderService fileFolderService, NodeDAO nodeDAO, NodeService nodeService, DictionaryService dictionaryService, NodeRef rootNodeRef, String containerName, boolean doNodeChecks, boolean doMetaDataChecks) {
            this.txnHelper = txnHelper;
            this.nodeService = nodeService;
            this.rootNodeRef = rootNodeRef;
            this.fileFolderService = fileFolderService;
            this.nodeDAO = nodeDAO;
            this.dictionaryService = dictionaryService;
            this.containerName = containerName;
            this.nodeAssertions = new HashMap<NodeRef, NodeAssertions>();
            this.nodeIds = new ArrayList<Long>(this.getExpectedNumNodes());
            this.doNodeChecks = doNodeChecks;
            this.doMetaDataChecks = doMetaDataChecks;
            this.doChecks = doNodeChecks || doMetaDataChecks;
        }

        void runNodeChecks(int maxResults) {
            if (this.doNodeChecks) {
                if (maxResults != 0 && maxResults != Integer.MAX_VALUE) {
                    Assert.assertEquals((String)"Number of returned nodes is incorrect", (long)maxResults, (long)this.getActualNodeCount());
                } else {
                    Assert.assertEquals((String)"Number of returned nodes is incorrect", (long)this.getExpectedNumNodes(), (long)this.getActualNodeCount());
                }
                Assert.assertEquals((String)"Unexpected failures", (int)0, (int)this.getFailureCount());
                Assert.assertEquals((String)"Success count is incorrect", (long)this.getActualNodeCount(), (long)this.getSuccessCount());
            }
        }

        void runNodeMetaDataChecks(int maxResults) {
            if (maxResults != 0 && maxResults != Integer.MAX_VALUE) {
                Assert.assertEquals((String)"Number of returned nodes is incorrect", (long)maxResults, (long)this.getActualNodeMetaDataCount());
            } else {
                Assert.assertEquals((String)"Number of returned nodes is incorrect", (long)this.getExpectedNumMetaDataNodes(), (long)this.getActualNodeMetaDataCount());
            }
        }

        void clearNodesMetaData() {
            this.successCount = 0;
            this.failureCount = 0;
            this.actualNodeMetaDataCount = 0L;
            this.nodeAssertions.clear();
        }

        public long getActualNodeCount() {
            return this.actualNodeCount;
        }

        public long getActualNodeMetaDataCount() {
            return this.actualNodeMetaDataCount;
        }

        protected long getExpectedNumMetaDataNodes() {
            return this.expectedNumMetaDataNodes;
        }

        protected abstract int getExpectedNumNodes();

        protected abstract List<Long> buildTransactionsInternal();

        public NodeAssertions getNodeAssertions(NodeRef nodeRef) {
            NodeAssertions assertions = this.nodeAssertions.get(nodeRef);
            if (assertions == null) {
                assertions = new NodeAssertions();
                this.nodeAssertions.put(nodeRef, assertions);
            }
            return assertions;
        }

        protected void setExpectedNodeStatus(NodeRef nodeRef, NodeStatus nodeStatus) {
            if (nodeStatus == NodeStatus.UPDATED) {
                ++this.expectedNumMetaDataNodes;
            }
            if (this.doChecks) {
                NodeAssertions nodeAssertions = this.getNodeAssertions(nodeRef);
                nodeAssertions.setNodeStatus(nodeStatus);
            }
        }

        List<Long> buildTransactions() {
            return this.buildTransactionsInternal();
        }

        @Override
        public boolean handleNode(Node node) {
            ++this.actualNodeCount;
            if (this.doNodeChecks) {
                NodeRef nodeRef = node.getNodeRef();
                Boolean isDeleted = node.getDeleted();
                this.nodeIds.add(node.getId());
                NodeAssertions expectedStatus = this.getNodeAssertions(nodeRef);
                if (expectedStatus == null) {
                    throw new RuntimeException("Unexpected missing assertion for NodeRef " + nodeRef);
                }
                if (expectedStatus.getNodeStatus() == NodeStatus.DELETED && isDeleted.booleanValue() || expectedStatus.getNodeStatus() == NodeStatus.UPDATED && !isDeleted.booleanValue()) {
                    ++this.successCount;
                } else {
                    ++this.failureCount;
                }
            }
            return true;
        }

        private Map<QName, Serializable> filterResudualProperties(Map<QName, Serializable> sourceProps) {
            HashMap<QName, Serializable> props = new HashMap<QName, Serializable>((int)((double)sourceProps.size() * 1.3));
            for (QName propertyQName : sourceProps.keySet()) {
                PropertyDefinition propDef = this.dictionaryService.getProperty(propertyQName);
                if (propDef == null) continue;
                props.put(propertyQName, sourceProps.get(propertyQName));
            }
            return props;
        }

        @Override
        public boolean handleNodeMetaData(NodeMetaData nodeMetaData) {
            ++this.actualNodeMetaDataCount;
            if (this.doMetaDataChecks) {
                boolean expectAspects;
                Map<QName, Serializable> expectedProperties;
                Long nodeId = nodeMetaData.getNodeId();
                NodeRef nodeRef = nodeMetaData.getNodeRef();
                Set<QName> aspects = nodeMetaData.getAspects();
                Set actualAspects = this.nodeService.getAspects(nodeRef);
                Assert.assertEquals((String)"Aspects are incorrect", (Object)actualAspects, aspects);
                Map<QName, Serializable> properties = nodeMetaData.getProperties();
                Map<QName, Serializable> actualProperties = this.filterResudualProperties(this.nodeDAO.getNodeProperties(nodeId));
                Assert.assertEquals((String)"Properties are incorrect", actualProperties, properties);
                NodeAssertions assertions = this.getNodeAssertions(nodeRef);
                Set<QName> expectedAspects = assertions.getAspects();
                if (expectedAspects != null) {
                    for (QName aspect : expectedAspects) {
                        Assert.assertTrue((String)("Expected aspect" + aspect), (boolean)aspects.contains(aspect));
                    }
                }
                if ((expectedProperties = assertions.getProperties()) != null) {
                    for (QName propName : expectedProperties.keySet()) {
                        Serializable expectedPropValue = expectedProperties.get(propName);
                        Serializable actualPropValue = properties.get(propName);
                        Assert.assertNotNull((String)("Missing property " + propName), (Object)actualPropValue);
                        Assert.assertEquals((String)"Incorrect property value", (Object)expectedPropValue, (Object)actualPropValue);
                    }
                }
                if ((expectAspects = assertions.isExpectAspects()) && nodeMetaData.getAspects() == null) {
                    Assert.fail((String)"Expecting aspects but got no aspects");
                } else if (!expectAspects && nodeMetaData.getAspects() != null) {
                    Assert.fail((String)"Not expecting aspects but got aspects");
                }
                boolean expectProperties = assertions.isExpectProperties();
                if (expectProperties && nodeMetaData.getProperties() == null) {
                    Assert.fail((String)"Expecting properties but got no properties");
                } else if (!expectProperties && nodeMetaData.getProperties() != null) {
                    Assert.fail((String)"Not expecting properties but got properties");
                }
                boolean expectType = assertions.isExpectType();
                if (expectType && nodeMetaData.getNodeType() == null) {
                    Assert.fail((String)"Expecting type but got no type");
                } else if (!expectType && nodeMetaData.getNodeType() != null) {
                    Assert.fail((String)"Not expecting type but got type");
                }
                boolean expectAclId = assertions.isExpectAclId();
                if (expectAclId && nodeMetaData.getAclId() == null) {
                    Assert.fail((String)"Expecting acl id but got no acl id");
                } else if (!expectAclId && nodeMetaData.getAclId() != null) {
                    Assert.fail((String)"Not expecting acl id but got acl id");
                }
                boolean expectPaths = assertions.isExpectPaths();
                if (expectPaths && nodeMetaData.getPaths() == null) {
                    Assert.fail((String)"Expecting paths but got no paths");
                } else if (!expectPaths && nodeMetaData.getPaths() != null) {
                    Assert.fail((String)"Not expecting paths but got paths");
                }
                boolean expectAssociations = assertions.isExpectAssociations();
                if (expectAssociations && nodeMetaData.getChildAssocs() == null) {
                    Assert.fail((String)"Expecting associations but got no associations");
                } else if (!expectAssociations && nodeMetaData.getChildAssocs() != null) {
                    Assert.fail((String)"Not expecting associations but got associations");
                }
                boolean expectOwner = assertions.isExpectOwner();
                if (expectOwner && nodeMetaData.getOwner() == null) {
                    Assert.fail((String)"Expecting owner but got no owner");
                } else if (!expectOwner && nodeMetaData.getOwner() != null) {
                    Assert.fail((String)"Not expecting owner but got owner");
                }
            }
            ++this.successCount;
            return true;
        }

        public int getSuccessCount() {
            return this.successCount;
        }

        public int getFailureCount() {
            return this.failureCount;
        }

        public List<Long> getNodeIds() {
            return this.nodeIds;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeAssertions {
        private Set<QName> aspects;
        private Map<QName, Serializable> properties;
        private NodeStatus nodeStatus;
        private Boolean expectAspects = true;
        private Boolean expectProperties = true;
        private boolean expectType = true;
        private boolean expectOwner = true;
        private boolean expectAssociations = true;
        private boolean expectPaths = true;
        private boolean expectAclId = true;

        public boolean isExpectType() {
            return this.expectType;
        }

        public boolean isExpectOwner() {
            return this.expectOwner;
        }

        public boolean isExpectAssociations() {
            return this.expectAssociations;
        }

        public boolean isExpectPaths() {
            return this.expectPaths;
        }

        public boolean isExpectAclId() {
            return this.expectAclId;
        }

        public boolean isExpectAspects() {
            return this.expectAspects;
        }

        public boolean isExpectProperties() {
            return this.expectProperties;
        }

        public void setNodeStatus(NodeStatus nodeStatus) {
            this.nodeStatus = nodeStatus;
        }

        public NodeStatus getNodeStatus() {
            return this.nodeStatus;
        }

        public Set<QName> getAspects() {
            return this.aspects;
        }

        public Map<QName, Serializable> getProperties() {
            return this.properties;
        }
    }

    private class ModelDiffsTracker {
        private Map<QName, Long> trackedModels = new HashMap<QName, Long>();

        private ModelDiffsTracker() {
        }

        public ModelDiffResults diff() {
            List<AlfrescoModelDiff> modelDiffs = SOLRTrackingComponentTest.this.solrTrackingComponent.getModelDiffs(this.trackedModels);
            ArrayList<AlfrescoModelDiff> newModels = new ArrayList<AlfrescoModelDiff>();
            ArrayList<AlfrescoModelDiff> changedModels = new ArrayList<AlfrescoModelDiff>();
            ArrayList<AlfrescoModelDiff> removedModels = new ArrayList<AlfrescoModelDiff>();
            for (AlfrescoModelDiff diff : modelDiffs) {
                if (diff.getType().equals((Object)AlfrescoModelDiff.TYPE.NEW)) {
                    newModels.add(diff);
                    this.trackedModels.put(QName.createQName((String)diff.getModelName()), diff.getNewChecksum());
                    continue;
                }
                if (diff.getType().equals((Object)AlfrescoModelDiff.TYPE.CHANGED)) {
                    changedModels.add(diff);
                    continue;
                }
                if (!diff.getType().equals((Object)AlfrescoModelDiff.TYPE.REMOVED)) continue;
                removedModels.add(diff);
            }
            return new ModelDiffResults(newModels, changedModels, removedModels);
        }

        public Long getChecksum(QName modelName) {
            return this.trackedModels.get(modelName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelDiffResults {
        private List<AlfrescoModelDiff> newModels;
        private List<AlfrescoModelDiff> changedModels;
        private List<AlfrescoModelDiff> removedModels;

        public ModelDiffResults(List<AlfrescoModelDiff> newModels, List<AlfrescoModelDiff> changedModels, List<AlfrescoModelDiff> removedModels) {
            this.newModels = newModels;
            this.changedModels = changedModels;
            this.removedModels = removedModels;
        }

        public List<AlfrescoModelDiff> getNewModels() {
            return this.newModels;
        }

        public List<AlfrescoModelDiff> getChangedModels() {
            return this.changedModels;
        }

        public List<AlfrescoModelDiff> getRemovedModels() {
            return this.removedModels;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NodeStatus {
        UPDATED,
        DELETED;

    }
}

