/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.subscriptions;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.FeedGenerator;
import org.alfresco.repo.activities.feed.local.LocalFeedTaskProcessor;
import org.alfresco.repo.activities.post.lookup.PostLookup;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.subscriptions.SubscriptionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.quartz.Scheduler;
import org.springframework.context.ApplicationContext;

public class SubscriptionServiceActivitiesTest
extends TestCase {
    protected static final String TEST_TEMPLATES_LOCATION = "activities";
    protected ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    protected SubscriptionService subscriptionService;
    protected PersonService personService;
    protected PostLookup postLookup;
    protected FeedGenerator feedGenerator;

    public void setUp() throws Exception {
        Scheduler scheduler = (Scheduler)this.ctx.getBean("schedulerFactory");
        scheduler.shutdown();
        this.subscriptionService = (SubscriptionService)this.ctx.getBean("SubscriptionService");
        this.personService = (PersonService)this.ctx.getBean("PersonService");
        ChildApplicationContextFactory activitiesFeed = (ChildApplicationContextFactory)this.ctx.getBean("ActivitiesFeed");
        ApplicationContext activitiesFeedCtx = activitiesFeed.getApplicationContext();
        this.postLookup = (PostLookup)activitiesFeedCtx.getBean("postLookup");
        this.feedGenerator = (FeedGenerator)activitiesFeedCtx.getBean("feedGenerator");
        LocalFeedTaskProcessor feedProcessor = (LocalFeedTaskProcessor)activitiesFeedCtx.getBean("feedTaskProcessor");
        ArrayList<String> templateSearchPaths = new ArrayList<String>(1);
        templateSearchPaths.add(TEST_TEMPLATES_LOCATION);
        feedProcessor.setTemplateSearchPaths(templateSearchPaths);
        feedProcessor.setUseRemoteCallbacks(false);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
    }

    protected void deletePerson(String userId) {
        this.personService.deletePerson(userId);
    }

    protected NodeRef createPerson(String userId) {
        this.deletePerson(userId);
        PropertyMap properties = new PropertyMap(5);
        properties.put(ContentModel.PROP_USERNAME, userId);
        properties.put(ContentModel.PROP_FIRSTNAME, userId);
        properties.put(ContentModel.PROP_LASTNAME, "Test");
        properties.put(ContentModel.PROP_EMAIL, userId + "@email.com");
        return this.personService.createPerson(properties);
    }

    protected void generateFeed() throws Exception {
        this.postLookup.execute();
        this.feedGenerator.execute();
    }

    public void testFollowingActivity() throws Exception {
        String userId1 = "bob";
        String userId2 = "tom";
        this.createPerson("bob");
        this.createPerson("tom");
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                SubscriptionServiceActivitiesTest.this.subscriptionService.follow("bob", "tom");
                return null;
            }
        }, (String)"bob");
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                SubscriptionServiceActivitiesTest.this.subscriptionService.follow("tom", "bob");
                return null;
            }
        }, (String)"tom");
        this.generateFeed();
        this.deletePerson("bob");
        this.deletePerson("tom");
    }
}

