/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.subscriptions;

import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.subscriptions.PagingFollowingResults;
import org.alfresco.service.cmr.subscriptions.PrivateSubscriptionListException;
import org.alfresco.service.cmr.subscriptions.SubscriptionService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.springframework.context.ApplicationContext;

public class SubscriptionServiceImplTest
extends TestCase {
    public static final String USER_BOB = "bob";
    public static final String USER_TOM = "tom";
    public static final String USER_LISA = "lisa";
    private UserTransaction txn;
    protected ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    protected TransactionService transactionService;
    protected SubscriptionService subscriptionService;
    protected PersonService personService;

    public void setUp() throws Exception {
        this.transactionService = (TransactionService)this.ctx.getBean("TransactionService");
        this.subscriptionService = (SubscriptionService)this.ctx.getBean("SubscriptionService");
        this.personService = (PersonService)this.ctx.getBean("PersonService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.txn = this.transactionService.getNonPropagatingUserTransaction(false);
        this.txn.begin();
        this.createPerson(USER_BOB);
        this.createPerson(USER_TOM);
        this.createPerson(USER_LISA);
    }

    protected void tearDown() throws Exception {
        this.deletePerson(USER_BOB);
        this.deletePerson(USER_TOM);
        this.deletePerson(USER_LISA);
        if (this.txn != null) {
            if (this.txn.getStatus() == 1) {
                this.txn.rollback();
            } else {
                this.txn.commit();
            }
            this.txn = null;
        }
    }

    protected void deletePerson(String userId) {
        this.personService.deletePerson(userId);
    }

    protected NodeRef createPerson(String userId) {
        this.deletePerson(userId);
        PropertyMap properties = new PropertyMap(5);
        properties.put(ContentModel.PROP_USERNAME, userId);
        properties.put(ContentModel.PROP_FIRSTNAME, userId);
        properties.put(ContentModel.PROP_LASTNAME, "Test");
        properties.put(ContentModel.PROP_EMAIL, userId + "@test.demo.alfresco.com");
        return this.personService.createPerson(properties);
    }

    public void testFollow() throws Exception {
        String userId1 = USER_BOB;
        String userId2 = USER_TOM;
        String userId3 = USER_LISA;
        if (this.subscriptionService.follows(userId1, userId2)) {
            this.subscriptionService.unfollow(userId1, userId2);
        }
        SubscriptionServiceImplTest.assertFalse((boolean)this.subscriptionService.follows(userId1, userId2));
        int count = this.subscriptionService.getFollowingCount(userId1);
        SubscriptionServiceImplTest.assertTrue((count >= 0 ? 1 : 0) != 0);
        this.subscriptionService.follow(userId1, userId2);
        this.subscriptionService.follow(userId1, userId2);
        SubscriptionServiceImplTest.assertEquals((int)(count + 1), (int)this.subscriptionService.getFollowingCount(userId1));
        SubscriptionServiceImplTest.assertTrue((boolean)this.subscriptionService.follows(userId1, userId2));
        this.subscriptionService.follow(userId1, userId3);
        SubscriptionServiceImplTest.assertEquals((int)(count + 2), (int)this.subscriptionService.getFollowingCount(userId1));
        SubscriptionServiceImplTest.assertTrue((boolean)this.subscriptionService.follows(userId1, userId3));
        PagingFollowingResults following = this.subscriptionService.getFollowing(userId1, new PagingRequest(100000, null));
        SubscriptionServiceImplTest.assertNotNull((Object)following);
        SubscriptionServiceImplTest.assertNotNull((Object)following.getPage());
        SubscriptionServiceImplTest.assertTrue((boolean)following.getPage().contains(userId2));
        SubscriptionServiceImplTest.assertTrue((boolean)following.getPage().contains(userId3));
        int followerCount = this.subscriptionService.getFollowersCount(userId2);
        SubscriptionServiceImplTest.assertTrue((followerCount > 0 ? 1 : 0) != 0);
        PagingFollowingResults followers = this.subscriptionService.getFollowers(userId2, new PagingRequest(100000, null));
        SubscriptionServiceImplTest.assertNotNull((Object)followers);
        SubscriptionServiceImplTest.assertNotNull((Object)followers.getPage());
        SubscriptionServiceImplTest.assertTrue((boolean)followers.getPage().contains(userId1));
        this.subscriptionService.unfollow(userId1, userId2);
        SubscriptionServiceImplTest.assertEquals((int)(count + 1), (int)this.subscriptionService.getFollowingCount(userId1));
        SubscriptionServiceImplTest.assertFalse((boolean)this.subscriptionService.follows(userId1, userId2));
        SubscriptionServiceImplTest.assertTrue((boolean)this.subscriptionService.follows(userId1, userId3));
        this.subscriptionService.unfollow(userId1, userId3);
        SubscriptionServiceImplTest.assertEquals((int)count, (int)this.subscriptionService.getFollowingCount(userId1));
        SubscriptionServiceImplTest.assertFalse((boolean)this.subscriptionService.follows(userId1, userId3));
    }

    public void testDeletePerson() throws Exception {
        String userId1 = USER_BOB;
        String userId2 = "subscription-temp-user";
        this.createPerson(userId2);
        this.subscriptionService.follow(userId1, userId2);
        SubscriptionServiceImplTest.assertTrue((boolean)this.subscriptionService.follows(userId1, userId2));
        this.deletePerson(userId2);
        PagingFollowingResults following = this.subscriptionService.getFollowing(userId1, new PagingRequest(100000, null));
        SubscriptionServiceImplTest.assertNotNull((Object)following);
        SubscriptionServiceImplTest.assertNotNull((Object)following.getPage());
        SubscriptionServiceImplTest.assertFalse((boolean)following.getPage().contains(userId2));
    }

    public void testPrivateList() throws Exception {
        String userId1 = USER_BOB;
        String userId2 = USER_TOM;
        SubscriptionServiceImplTest.assertFalse((boolean)this.subscriptionService.isSubscriptionListPrivate(USER_BOB));
        this.subscriptionService.setSubscriptionListPrivate(USER_BOB, false);
        SubscriptionServiceImplTest.assertFalse((boolean)this.subscriptionService.isSubscriptionListPrivate(USER_BOB));
        this.subscriptionService.setSubscriptionListPrivate(USER_BOB, true);
        SubscriptionServiceImplTest.assertTrue((boolean)this.subscriptionService.isSubscriptionListPrivate(USER_BOB));
        this.subscriptionService.setSubscriptionListPrivate(USER_BOB, false);
        SubscriptionServiceImplTest.assertFalse((boolean)this.subscriptionService.isSubscriptionListPrivate(USER_BOB));
        this.subscriptionService.setSubscriptionListPrivate(USER_BOB, true);
        SubscriptionServiceImplTest.assertTrue((boolean)this.subscriptionService.isSubscriptionListPrivate(USER_BOB));
        this.subscriptionService.follow(USER_BOB, USER_TOM);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                Assert.assertNotNull((Object)SubscriptionServiceImplTest.this.subscriptionService.getFollowing(SubscriptionServiceImplTest.USER_BOB, new PagingRequest(100000, null)));
                return null;
            }
        }, (String)USER_BOB);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                Assert.assertNotNull((Object)SubscriptionServiceImplTest.this.subscriptionService.getFollowing(SubscriptionServiceImplTest.USER_BOB, new PagingRequest(100000, null)));
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                try {
                    SubscriptionServiceImplTest.this.subscriptionService.getFollowing(SubscriptionServiceImplTest.USER_BOB, new PagingRequest(100000, null));
                    Assert.fail((String)"Expected PrivateSubscriptionListException!");
                }
                catch (PrivateSubscriptionListException privateSubscriptionListException) {
                    // empty catch block
                }
                return null;
            }
        }, (String)USER_TOM);
    }
}

