/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.io.Serializable;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.MultiTAdminServiceImpl;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantDisabledException;
import org.alfresco.repo.tenant.TenantDomainMismatchException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTServiceImpl
implements TenantService {
    private static Log logger = LogFactory.getLog(MultiTServiceImpl.class);
    private SimpleCache<String, Tenant> tenantsCache;
    private MultiTAdminServiceImpl tenantAdminService = null;

    public void setTenantsCache(SimpleCache<String, Tenant> tenantsCache) {
        this.tenantsCache = tenantsCache;
    }

    public NodeRef getName(NodeRef nodeRef) {
        if (nodeRef == null) {
            return null;
        }
        return new NodeRef(nodeRef.getStoreRef().getProtocol(), this.getName(nodeRef.getStoreRef().getIdentifier()), nodeRef.getId());
    }

    public NodeRef getName(NodeRef inNodeRef, NodeRef nodeRef) {
        if (inNodeRef == null || nodeRef == null) {
            return null;
        }
        int idx = inNodeRef.getStoreRef().getIdentifier().lastIndexOf("@");
        if (idx != -1) {
            String tenantDomain = inNodeRef.getStoreRef().getIdentifier().substring(1, idx);
            return new NodeRef(nodeRef.getStoreRef().getProtocol(), this.getName(nodeRef.getStoreRef().getIdentifier(), tenantDomain), nodeRef.getId());
        }
        return nodeRef;
    }

    public StoreRef getName(StoreRef storeRef) {
        if (storeRef == null) {
            return null;
        }
        return new StoreRef(storeRef.getProtocol(), this.getName(storeRef.getIdentifier()));
    }

    public ChildAssociationRef getName(ChildAssociationRef childAssocRef) {
        if (childAssocRef == null) {
            return null;
        }
        return new ChildAssociationRef(childAssocRef.getTypeQName(), this.getName(childAssocRef.getParentRef()), childAssocRef.getQName(), this.getName(childAssocRef.getChildRef()), childAssocRef.isPrimary(), childAssocRef.getNthSibling());
    }

    public AssociationRef getName(AssociationRef assocRef) {
        if (assocRef == null) {
            return null;
        }
        return new AssociationRef(assocRef.getId(), this.getName(assocRef.getSourceRef()), assocRef.getTypeQName(), this.getName(assocRef.getTargetRef()));
    }

    public StoreRef getName(String username, StoreRef storeRef) {
        int idx;
        if (storeRef == null) {
            return null;
        }
        if (username != null && (idx = username.lastIndexOf("@")) > 0 && idx < username.length() - 1) {
            String tenantDomain = username.substring(idx + 1);
            return new StoreRef(storeRef.getProtocol(), this.getName(storeRef.getIdentifier(), tenantDomain));
        }
        return storeRef;
    }

    protected String getName(String name, String tenantDomain) {
        ParameterCheck.mandatory((String)"name", (Object)name);
        ParameterCheck.mandatory((String)"tenantDomain", (Object)tenantDomain);
        this.checkTenantEnabled(tenantDomain);
        int idx1 = name.indexOf("@");
        if (idx1 != 0) {
            name = "@" + tenantDomain + "@" + name;
        } else {
            int idx2 = name.indexOf("@", 1);
            String nameDomain = name.substring(1, idx2);
            if (!tenantDomain.equals(nameDomain)) {
                throw new AlfrescoRuntimeException("domain mismatch: expected = " + tenantDomain + ", actual = " + nameDomain);
            }
        }
        return name;
    }

    public QName getName(QName name) {
        ParameterCheck.mandatory((String)"Name", (Object)name);
        String tenantDomain = this.getCurrentUserDomain();
        if (!tenantDomain.equals("")) {
            this.checkTenantEnabled(tenantDomain);
            name = this.getName(name, tenantDomain);
        }
        return name;
    }

    public QName getName(NodeRef inNodeRef, QName name) {
        ParameterCheck.mandatory((String)"InNodeRef", (Object)inNodeRef);
        ParameterCheck.mandatory((String)"Name", (Object)name);
        int idx = inNodeRef.getStoreRef().getIdentifier().lastIndexOf("@");
        if (idx != -1) {
            String tenantDomain = inNodeRef.getStoreRef().getIdentifier().substring(1, idx);
            this.checkTenantEnabled(tenantDomain);
            return this.getName(name, tenantDomain);
        }
        return name;
    }

    private QName getName(QName name, String tenantDomain) {
        String namespace = name.getNamespaceURI();
        int idx1 = namespace.indexOf("@");
        if (idx1 == -1) {
            namespace = "@" + tenantDomain + "@" + namespace;
            name = QName.createQName((String)namespace, (String)name.getLocalName());
        } else {
            int idx2 = namespace.indexOf("@", 1);
            String nameDomain = namespace.substring(1, idx2);
            if (!tenantDomain.equals(nameDomain)) {
                throw new AlfrescoRuntimeException("domain mismatch: expected = " + tenantDomain + ", actual = " + nameDomain);
            }
        }
        return name;
    }

    public String getName(String name) {
        ParameterCheck.mandatory((String)"name", (Object)name);
        String tenantDomain = this.getCurrentUserDomain();
        if (!tenantDomain.equals("")) {
            int idx1 = name.indexOf("@");
            if (idx1 != 0) {
                name = "@" + tenantDomain + "@" + name;
            } else {
                int idx2 = name.indexOf("@", 1);
                String nameDomain = name.substring(1, idx2);
                if (!tenantDomain.equals(nameDomain)) {
                    throw new AlfrescoRuntimeException("domain mismatch: expected = " + tenantDomain + ", actual = " + nameDomain);
                }
            }
        }
        return name;
    }

    public QName getBaseName(QName name, boolean forceForNonTenant) {
        String baseNamespaceURI = this.getBaseName(name.getNamespaceURI(), forceForNonTenant);
        return QName.createQName((String)baseNamespaceURI, (String)name.getLocalName());
    }

    public NodeRef getBaseName(NodeRef nodeRef) {
        return this.getBaseName(nodeRef, false);
    }

    public NodeRef getBaseName(NodeRef nodeRef, boolean forceForNonTenant) {
        if (nodeRef == null) {
            return null;
        }
        return new NodeRef(nodeRef.getStoreRef().getProtocol(), this.getBaseName(nodeRef.getStoreRef().getIdentifier(), forceForNonTenant), nodeRef.getId());
    }

    public StoreRef getBaseName(StoreRef storeRef) {
        if (storeRef == null) {
            return null;
        }
        return new StoreRef(storeRef.getProtocol(), this.getBaseName(storeRef.getIdentifier()));
    }

    public ChildAssociationRef getBaseName(ChildAssociationRef childAssocRef) {
        return this.getBaseName(childAssocRef, false);
    }

    public ChildAssociationRef getBaseName(ChildAssociationRef childAssocRef, boolean forceForNonTenant) {
        if (childAssocRef == null) {
            return null;
        }
        return new ChildAssociationRef(childAssocRef.getTypeQName(), this.getBaseName(childAssocRef.getParentRef(), forceForNonTenant), childAssocRef.getQName(), this.getBaseName(childAssocRef.getChildRef(), forceForNonTenant), childAssocRef.isPrimary(), childAssocRef.getNthSibling());
    }

    public AssociationRef getBaseName(AssociationRef assocRef) {
        if (assocRef == null) {
            return null;
        }
        return new AssociationRef(assocRef.getId(), this.getBaseName(assocRef.getSourceRef()), assocRef.getTypeQName(), this.getBaseName(assocRef.getTargetRef()));
    }

    public String getBaseName(String name) {
        return this.getBaseName(name, false);
    }

    public String getBaseName(String name, boolean forceForNonTenant) {
        ParameterCheck.mandatory((String)"name", (Object)name);
        String tenantDomain = this.getCurrentUserDomain();
        int idx1 = name.indexOf("@");
        if (idx1 == 0) {
            int idx2 = name.indexOf("@", 1);
            String nameDomain = name.substring(1, idx2);
            if (!tenantDomain.equals("") && !tenantDomain.equals(nameDomain)) {
                throw new AlfrescoRuntimeException("domain mismatch: expected = " + tenantDomain + ", actual = " + nameDomain);
            }
            if (!tenantDomain.equals("") || forceForNonTenant) {
                name = name.substring(idx2 + 1);
            }
        }
        return name;
    }

    public String getBaseNameUser(String name) {
        int idx;
        if (name != null && (idx = name.lastIndexOf("@")) != -1) {
            return name.substring(0, idx);
        }
        return name;
    }

    public void checkDomainUser(String username) {
        ParameterCheck.mandatory((String)"Username", (Object)username);
        String tenantDomain = this.getCurrentUserDomain();
        if (!tenantDomain.equals("")) {
            int idx2 = username.lastIndexOf("@");
            if (idx2 > 0 && idx2 < username.length() - 1) {
                String tenantUserDomain = username.substring(idx2 + 1);
                if (tenantUserDomain == null || !tenantDomain.equals(tenantUserDomain)) {
                    throw new TenantDomainMismatchException(tenantDomain, tenantUserDomain);
                }
            } else {
                throw new TenantDomainMismatchException(tenantDomain, null);
            }
        }
    }

    public void checkDomain(String name) {
        ParameterCheck.mandatory((String)"Name", (Object)name);
        String nameDomain = null;
        int idx1 = name.indexOf("@");
        if (idx1 == 0) {
            int idx2 = name.indexOf("@", 1);
            nameDomain = name.substring(1, idx2);
        }
        String tenantDomain = this.getCurrentUserDomain();
        if (nameDomain == null && !tenantDomain.equals("") || nameDomain != null && !nameDomain.equals(tenantDomain)) {
            throw new AlfrescoRuntimeException("domain mismatch: expected = " + tenantDomain + ", actual = " + nameDomain);
        }
    }

    public NodeRef getRootNode(NodeService nodeService, SearchService searchService, NamespaceService namespaceService, String rootPath, NodeRef rootNodeRef) {
        ParameterCheck.mandatory((String)"NodeService", (Object)nodeService);
        ParameterCheck.mandatory((String)"SearchService", (Object)searchService);
        ParameterCheck.mandatory((String)"NamespaceService", (Object)namespaceService);
        ParameterCheck.mandatory((String)"RootPath", (Object)rootPath);
        ParameterCheck.mandatory((String)"RootNodeRef", (Object)rootNodeRef);
        String username = AuthenticationUtil.getFullyAuthenticatedUser();
        StoreRef storeRef = this.getName(username, rootNodeRef.getStoreRef());
        GetRootNode action = new GetRootNode(nodeService, searchService, namespaceService, rootPath, rootNodeRef, storeRef);
        return this.getBaseName((NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)action, (String)AuthenticationUtil.getSystemUserName()));
    }

    public boolean isTenantUser() {
        return this.isTenantUser(AuthenticationUtil.getRunAsUser());
    }

    public boolean isTenantUser(String username) {
        int idx;
        return username != null && (idx = username.lastIndexOf("@")) > 0 && idx < username.length() - 1;
    }

    public boolean isTenantName(String name) {
        return !"".equals(this.getDomain(name, false));
    }

    public String getUserDomain(String username) {
        int idx;
        if (username != null && (idx = username.lastIndexOf("@")) > 0 && idx < username.length() - 1) {
            String tenantDomain = this.getTenantDomain(username.substring(idx + 1));
            this.checkTenantEnabled(tenantDomain);
            return tenantDomain;
        }
        return "";
    }

    public String getCurrentUserDomain() {
        String user = AuthenticationUtil.getRunAsUser();
        return this.getUserDomain(user);
    }

    public String getDomain(String name) {
        return this.getDomain(name, false);
    }

    public String getDomain(String name, boolean checkCurrentDomain) {
        ParameterCheck.mandatory((String)"name", (Object)name);
        String nameDomain = "";
        int idx1 = name.indexOf("@");
        if (idx1 == 0) {
            String tenantDomain;
            int idx2 = name.indexOf("@", 1);
            nameDomain = this.getTenantDomain(name.substring(1, idx2));
            if (checkCurrentDomain && !(tenantDomain = this.getCurrentUserDomain()).equals("") && !tenantDomain.equals(nameDomain)) {
                throw new AlfrescoRuntimeException("domain mismatch: expected = " + tenantDomain + ", actual = " + nameDomain);
            }
        }
        return nameDomain;
    }

    public static String getMultiTenantDomainName(String name) {
        int idx2;
        ParameterCheck.mandatory((String)"name", (Object)name);
        int idx1 = name.indexOf("@");
        if (idx1 == 0 && (idx2 = name.indexOf("@", 1)) != -1) {
            return name.substring(1, idx2);
        }
        return "";
    }

    public String getDomainUser(String baseUsername, String tenantDomain) {
        ParameterCheck.mandatory((String)"baseUsername", (Object)baseUsername);
        if (tenantDomain == null || tenantDomain.equals("")) {
            return baseUsername;
        }
        if (baseUsername.contains("@")) {
            throw new AlfrescoRuntimeException("Invalid base username: " + baseUsername);
        }
        if (tenantDomain.contains("@")) {
            throw new AlfrescoRuntimeException("Invalid tenant domain: " + tenantDomain);
        }
        tenantDomain = this.getTenantDomain(tenantDomain);
        return baseUsername + "@" + tenantDomain;
    }

    protected void checkTenantEnabled(String tenantDomain) {
        if (!AuthenticationUtil.isRunAsUserTheSystemUser() && !this.getTenant(tenantDomain).isEnabled()) {
            throw new TenantDisabledException(tenantDomain);
        }
    }

    public Tenant getTenant(String tenantDomain) {
        Tenant tenant = (Tenant)this.tenantsCache.get((Serializable)((Object)(tenantDomain = this.getTenantDomain(tenantDomain))));
        if (tenant == null && this.tenantAdminService != null) {
            tenant = this.tenantAdminService.getTenant(tenantDomain);
            if (tenant == null) {
                throw new AlfrescoRuntimeException("No such tenant " + tenantDomain);
            }
            this.putTenant(tenantDomain, tenant);
        }
        return tenant;
    }

    public boolean isEnabled() {
        return true;
    }

    protected void register(MultiTAdminServiceImpl tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    protected void putTenant(String tenantDomain, Tenant tenant) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("putTenant " + tenantDomain));
        }
        this.tenantsCache.put((Serializable)((Object)tenantDomain), (Object)tenant);
    }

    protected void removeTenant(String tenantDomain) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removeTenant " + tenantDomain));
        }
        this.tenantsCache.remove((Serializable)((Object)tenantDomain));
    }

    private String getTenantDomain(String tenantDomain) {
        return tenantDomain.toLowerCase(I18NUtil.getLocale());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetRootNode
    implements AuthenticationUtil.RunAsWork<NodeRef> {
        NodeService nodeService;
        SearchService searchService;
        NamespaceService namespaceService;
        String rootPath;
        NodeRef rootNodeRef;
        StoreRef storeRef;

        GetRootNode(NodeService nodeService, SearchService searchService, NamespaceService namespaceService, String rootPath, NodeRef rootNodeRef, StoreRef storeRef) {
            this.nodeService = nodeService;
            this.searchService = searchService;
            this.namespaceService = namespaceService;
            this.rootPath = rootPath;
            this.rootNodeRef = rootNodeRef;
            this.storeRef = storeRef;
        }

        public NodeRef doWork() throws Exception {
            if (!this.nodeService.exists(this.storeRef)) {
                throw new AlfrescoRuntimeException("Store not created prior to application startup: " + this.storeRef);
            }
            NodeRef storeRootNodeRef = this.nodeService.getRootNode(this.storeRef);
            List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, this.rootPath, null, (NamespacePrefixResolver)this.namespaceService, false);
            if (nodeRefs.size() > 1) {
                throw new AlfrescoRuntimeException("Multiple possible roots for device: \n   root path: " + this.rootPath + "\n" + "   results: " + nodeRefs);
            }
            if (nodeRefs.size() == 0) {
                throw new AlfrescoRuntimeException("No root found for device: \n   root path: " + this.rootPath);
            }
            this.rootNodeRef = (NodeRef)nodeRefs.get(0);
            return this.rootNodeRef;
        }
    }
}

