/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tenant;

import java.util.List;
import org.alfresco.repo.admin.patch.AppliedPatch;
import org.alfresco.repo.admin.patch.PatchService;
import org.alfresco.repo.admin.patch.impl.MigrateAttrTenantsPatch;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.util.PropertyCheck;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class MultiTenantBootstrap
extends AbstractLifecycleBean {
    private TenantAdminService tenantAdminService;
    private PatchService patchService;
    private MigrateAttrTenantsPatch migrateAttrTenantsPatch;
    private DescriptorService descriptorService;

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setPatchService(PatchService patchService) {
        this.patchService = patchService;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setMigrateAttrTenantsPatch(MigrateAttrTenantsPatch migrateAttrTenantsPatch) {
        this.migrateAttrTenantsPatch = migrateAttrTenantsPatch;
    }

    protected void onBootstrap(ApplicationEvent event) {
        PropertyCheck.mandatory((Object)((Object)this), (String)"tenantAdminService", (Object)this.tenantAdminService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"patchService", (Object)this.patchService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"descriptorService", (Object)this.descriptorService);
        if (this.tenantAdminService.isEnabled()) {
            Descriptor desc = this.descriptorService.getInstalledRepositoryDescriptor();
            if (desc != null && desc.getSchema() < 5007 && this.tenantAdminService.getAllTenants().size() == 0) {
                boolean applied = false;
                List<AppliedPatch> appliedPatches = this.patchService.getPatches(null, null);
                for (AppliedPatch appliedPatch : appliedPatches) {
                    if (!appliedPatch.getId().equals("patch.migrateAttrTenants")) continue;
                    applied = true;
                    break;
                }
                if (!applied) {
                    this.migrateAttrTenantsPatch.apply();
                }
            }
            this.tenantAdminService.startTenants();
        }
    }

    protected void onShutdown(ApplicationEvent event) {
        this.tenantAdminService.stopTenants();
    }
}

