/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.repo.thumbnail.ThumbnailRenditionConvertor;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.thumbnail.ThumbnailException;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailRegistry
implements ApplicationContextAware,
ApplicationListener<ApplicationContextEvent> {
    private static Log logger = LogFactory.getLog(ThumbnailRegistry.class);
    private ContentService contentService;
    private TransactionService transactionService;
    private RenditionService renditionService;
    private Map<String, ThumbnailDefinition> thumbnailDefinitions = new HashMap<String, ThumbnailDefinition>();
    private Map<String, List<ThumbnailDefinition>> mimetypeMap = new HashMap<String, List<ThumbnailDefinition>>(17);
    private ThumbnailRenditionConvertor thumbnailRenditionConvertor;
    private RegistryLifecycle lifecycle = new RegistryLifecycle();

    public void setThumbnailRenditionConvertor(ThumbnailRenditionConvertor thumbnailRenditionConvertor) {
        this.thumbnailRenditionConvertor = thumbnailRenditionConvertor;
    }

    public ThumbnailRenditionConvertor getThumbnailRenditionConvertor() {
        return this.thumbnailRenditionConvertor;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setThumbnailDefinitions(List<ThumbnailDefinition> thumbnailDefinitions) {
        for (ThumbnailDefinition td : thumbnailDefinitions) {
            String thumbnailName = td.getName();
            if (thumbnailName == null) {
                throw new ThumbnailException("When adding a thumbnail details object make sure the name is set.");
            }
            this.thumbnailDefinitions.put(thumbnailName, td);
        }
    }

    private void initThumbnailDefinitions() {
        if (this.transactionService.isReadOnly()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"TransactionService is in read-only mode. Therefore no thumbnail definitions have been initialised.");
            }
            return;
        }
        RetryingTransactionHelper transactionHelper = this.transactionService.getRetryingTransactionHelper();
        transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        for (String thumbnailDefName : ThumbnailRegistry.this.thumbnailDefinitions.keySet()) {
                            ThumbnailDefinition thumbnailDefinition = (ThumbnailDefinition)ThumbnailRegistry.this.thumbnailDefinitions.get(thumbnailDefName);
                            RenditionDefinition renditionDef = ThumbnailRegistry.this.thumbnailRenditionConvertor.convert(thumbnailDefinition, null);
                            ThumbnailRegistry.this.renditionService.saveRenditionDefinition(renditionDef);
                        }
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
                return null;
            }
        });
    }

    public List<ThumbnailDefinition> getThumbnailDefinitions() {
        return new ArrayList<ThumbnailDefinition>(this.thumbnailDefinitions.values());
    }

    public List<ThumbnailDefinition> getThumbnailDefinitions(String mimetype) {
        return this.getThumbnailDefinitions(null, mimetype, -1L);
    }

    public List<ThumbnailDefinition> getThumbnailDefinitions(String sourceUrl, String mimetype, long sourceSize) {
        List<ThumbnailDefinition> result = this.mimetypeMap.get(mimetype);
        if (result == null) {
            boolean foundAtLeastOneTransformer = false;
            result = new ArrayList<ThumbnailDefinition>(7);
            for (ThumbnailDefinition thumbnailDefinition : this.thumbnailDefinitions.values()) {
                if (!this.isThumbnailDefinitionAvailable(sourceUrl, mimetype, sourceSize, thumbnailDefinition)) continue;
                result.add(thumbnailDefinition);
                foundAtLeastOneTransformer = true;
            }
            if (foundAtLeastOneTransformer) {
                this.mimetypeMap.put(mimetype, result);
            }
        }
        return result;
    }

    @Deprecated
    public List<ThumbnailDefinition> getThumnailDefintions(String mimetype) {
        return this.getThumbnailDefinitions(mimetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThumbnailDefinitionAvailable(String sourceUrl, String sourceMimeType, long sourceSize, ThumbnailDefinition thumbnailDefinition) {
        boolean orig = TransformerDebug.setDebugOutput(false);
        try {
            boolean bl = this.contentService.getTransformer(sourceUrl, sourceMimeType, sourceSize, thumbnailDefinition.getMimetype(), thumbnailDefinition.getTransformationOptions()) != null;
            return bl;
        }
        finally {
            TransformerDebug.setDebugOutput(orig);
        }
    }

    public void addThumbnailDefinition(ThumbnailDefinition thumbnailDetails) {
        String thumbnailName = thumbnailDetails.getName();
        if (thumbnailName == null) {
            throw new ThumbnailException("When adding a thumbnail details object make sure the name is set.");
        }
        this.thumbnailDefinitions.put(thumbnailName, thumbnailDetails);
    }

    public ThumbnailDefinition getThumbnailDefinition(String thumbnailName) {
        return this.thumbnailDefinitions.get(thumbnailName);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.lifecycle.setApplicationContext(applicationContext);
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        this.lifecycle.onApplicationEvent((ApplicationEvent)event);
    }

    private class RegistryLifecycle
    extends AbstractLifecycleBean {
        private RegistryLifecycle() {
        }

        protected void onBootstrap(ApplicationEvent event) {
            ThumbnailRegistry.this.initThumbnailDefinitions();
        }

        protected void onShutdown(ApplicationEvent event) {
        }
    }
}

