/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.cache.TransactionalCache;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerAndSearcher;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.repo.transaction.TransactionalDao;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AlfrescoTransactionSupport {
    public static final int SESSION_SYNCHRONIZATION_ORDER = 800;
    private static final String RESOURCE_KEY_TXN_SYNCH = "txnSynch";
    private static final String RESOURCE_KEY_TXN_COMPLETING = "AlfrescoTransactionSupport.txnCompleting";
    private static Log logger = LogFactory.getLog(AlfrescoTransactionSupport.class);

    public static long getTransactionStartTime() {
        TransactionSynchronizationImpl txnSynch = (TransactionSynchronizationImpl)((Object)TransactionSynchronizationManager.getResource((Object)RESOURCE_KEY_TXN_SYNCH));
        if (txnSynch == null) {
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                return AlfrescoTransactionSupport.registerSynchronizations().getTransactionStartTime();
            }
            return -1L;
        }
        return txnSynch.getTransactionStartTime();
    }

    public static String getTransactionId() {
        TransactionSynchronizationImpl txnSynch = (TransactionSynchronizationImpl)((Object)TransactionSynchronizationManager.getResource((Object)RESOURCE_KEY_TXN_SYNCH));
        if (txnSynch == null) {
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                return AlfrescoTransactionSupport.registerSynchronizations().getTransactionId();
            }
            return null;
        }
        return txnSynch.getTransactionId();
    }

    public static boolean isActualTransactionActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    public static TxnReadState getTransactionReadState() {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return TxnReadState.TXN_NONE;
        }
        if (AlfrescoTransactionSupport.getResource(RESOURCE_KEY_TXN_COMPLETING) != null) {
            return TxnReadState.TXN_NONE;
        }
        if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
            return TxnReadState.TXN_READ_ONLY;
        }
        return TxnReadState.TXN_READ_WRITE;
    }

    public static void checkTransactionReadState(boolean requireReadWrite) {
        TxnReadState readState = AlfrescoTransactionSupport.getTransactionReadState();
        switch (readState) {
            case TXN_NONE: {
                throw new IllegalStateException("The current operation requires an active " + (requireReadWrite ? "read-write" : "") + "transaction.");
            }
            case TXN_READ_ONLY: {
                if (!requireReadWrite) break;
                throw new IllegalStateException("The current operation requires an active read-write transaction.");
            }
        }
    }

    public static boolean isDirty() {
        TransactionSynchronizationImpl synch = AlfrescoTransactionSupport.getSynchronization();
        Set<TransactionalDao> services = synch.getDaoServices();
        for (TransactionalDao service : services) {
            if (!service.isDirty()) continue;
            return true;
        }
        return false;
    }

    public static <R> R getResource(Object key) {
        TransactionSynchronizationImpl txnSynch = AlfrescoTransactionSupport.getSynchronization();
        Object resource = txnSynch.resources.get(key);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetched resource: \n   key: " + key + "\n" + "   resource: " + resource));
        }
        return (R)resource;
    }

    public static void bindResource(Object key, Object resource) {
        TransactionSynchronizationImpl txnSynch = AlfrescoTransactionSupport.getSynchronization();
        txnSynch.resources.put(key, resource);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bound resource: \n   key: " + key + "\n" + "   resource: " + resource));
        }
    }

    public static void unbindResource(Object key) {
        TransactionSynchronizationImpl txnSynch = AlfrescoTransactionSupport.getSynchronization();
        txnSynch.resources.remove(key);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unbound resource: \n   key: " + key));
        }
    }

    public static void bindDaoService(TransactionalDao daoService) {
        TransactionSynchronizationImpl synch = AlfrescoTransactionSupport.getSynchronization();
        boolean bound = synch.getDaoServices().add(daoService);
        if (logger.isDebugEnabled()) {
            AlfrescoTransactionSupport.logBoundService(daoService, bound);
        }
    }

    public static void bindIntegrityChecker(IntegrityChecker integrityChecker) {
        TransactionSynchronizationImpl synch = AlfrescoTransactionSupport.getSynchronization();
        boolean bound = synch.getIntegrityCheckers().add(integrityChecker);
        if (logger.isDebugEnabled()) {
            AlfrescoTransactionSupport.logBoundService(integrityChecker, bound);
        }
    }

    public static void bindLucene(LuceneIndexerAndSearcher indexerAndSearcher) {
        TransactionSynchronizationImpl synch = AlfrescoTransactionSupport.getSynchronization();
        boolean bound = synch.getLucenes().add(indexerAndSearcher);
        if (logger.isDebugEnabled()) {
            AlfrescoTransactionSupport.logBoundService(indexerAndSearcher, bound);
        }
    }

    public static void bindListener(TransactionListener listener) {
        TransactionSynchronizationImpl synch = AlfrescoTransactionSupport.getSynchronization();
        boolean bound = synch.addListener(listener);
        if (logger.isDebugEnabled()) {
            AlfrescoTransactionSupport.logBoundService(listener, bound);
        }
    }

    private static void logBoundService(Object service, boolean bound) {
        if (bound) {
            logger.debug((Object)("Bound service: \n   transaction: " + AlfrescoTransactionSupport.getTransactionId() + "\n" + "   service: " + service));
        } else {
            logger.debug((Object)("Service already bound: \n   transaction: " + AlfrescoTransactionSupport.getTransactionId() + "\n" + "   service: " + service));
        }
    }

    public static void flush() {
    }

    private static TransactionSynchronizationImpl getSynchronization() {
        return AlfrescoTransactionSupport.registerSynchronizations();
    }

    private static TransactionSynchronizationImpl registerSynchronizations() {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            Thread currentThread = Thread.currentThread();
            throw new AlfrescoRuntimeException("Transaction must be active and synchronization is required: " + currentThread);
        }
        TransactionSynchronizationImpl txnSynch = (TransactionSynchronizationImpl)((Object)TransactionSynchronizationManager.getResource((Object)RESOURCE_KEY_TXN_SYNCH));
        if (txnSynch != null) {
            return txnSynch;
        }
        String txnId = GUID.generate();
        txnSynch = new TransactionSynchronizationImpl(txnId);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)txnSynch);
        TransactionSynchronizationManager.bindResource((Object)RESOURCE_KEY_TXN_SYNCH, (Object)((Object)txnSynch));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bound txn synch: " + (Object)((Object)txnSynch)));
        }
        return txnSynch;
    }

    private static void clearSynchronization() {
        if (TransactionSynchronizationManager.hasResource((Object)RESOURCE_KEY_TXN_SYNCH)) {
            Object txnSynch = TransactionSynchronizationManager.unbindResource((Object)RESOURCE_KEY_TXN_SYNCH);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unbound txn synch:" + txnSynch));
            }
        }
    }

    private static void rebindSynchronization(TransactionSynchronizationImpl txnSynch) {
        TransactionSynchronizationManager.bindResource((Object)RESOURCE_KEY_TXN_SYNCH, (Object)((Object)txnSynch));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bound txn synch: " + (Object)((Object)txnSynch)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransactionSynchronizationImpl
    extends TransactionSynchronizationAdapter {
        private long txnStartTime = System.currentTimeMillis();
        private final String txnId;
        private final Set<TransactionalDao> daoServices;
        private final Set<IntegrityChecker> integrityCheckers;
        private final Set<LuceneIndexerAndSearcher> lucenes;
        private final LinkedHashSet<TransactionListener> listeners;
        private final Set<TransactionalCache<Serializable, Object>> transactionalCaches;
        private final Map<Object, Object> resources;

        public TransactionSynchronizationImpl(String txnId) {
            this.txnId = txnId;
            this.daoServices = new HashSet<TransactionalDao>(3);
            this.integrityCheckers = new HashSet<IntegrityChecker>(3);
            this.lucenes = new HashSet<LuceneIndexerAndSearcher>(3);
            this.listeners = new LinkedHashSet(5);
            this.transactionalCaches = new HashSet<TransactionalCache<Serializable, Object>>(3);
            this.resources = new HashMap<Object, Object>(17);
        }

        public long getTransactionStartTime() {
            return this.txnStartTime;
        }

        public String getTransactionId() {
            return this.txnId;
        }

        public Set<TransactionalDao> getDaoServices() {
            return this.daoServices;
        }

        public Set<IntegrityChecker> getIntegrityCheckers() {
            return this.integrityCheckers;
        }

        public Set<LuceneIndexerAndSearcher> getLucenes() {
            return this.lucenes;
        }

        public boolean addListener(TransactionListener listener) {
            ParameterCheck.mandatory((String)"listener", (Object)listener);
            if (listener instanceof TransactionalCache) {
                return this.transactionalCaches.add((TransactionalCache)listener);
            }
            return this.listeners.add(listener);
        }

        private List<TransactionListener> getListenersIterable() {
            return new ArrayList<TransactionListener>(this.listeners);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append("TransactionSychronizationImpl").append("[ txnId=").append(this.txnId).append(", daos=").append(this.daoServices.size()).append(", integrity=").append(this.integrityCheckers.size()).append(", indexers=").append(this.lucenes.size()).append(", resources=").append(this.resources).append("]");
            return sb.toString();
        }

        public int getOrder() {
            return 800;
        }

        public void suspend() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Suspending transaction: " + (Object)((Object)this)));
            }
            AlfrescoTransactionSupport.clearSynchronization();
        }

        public void resume() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resuming transaction: " + (Object)((Object)this)));
            }
            AlfrescoTransactionSupport.rebindSynchronization(this);
        }

        public void beforeCommit(boolean readOnly) {
            TransactionSynchronizationImpl synch;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Before commit " + (readOnly ? "read-only" : "") + ": " + (Object)((Object)this)));
            }
            if ((synch = (TransactionSynchronizationImpl)((Object)TransactionSynchronizationManager.getResource((Object)AlfrescoTransactionSupport.RESOURCE_KEY_TXN_SYNCH))) == null) {
                throw new AlfrescoRuntimeException("No synchronization bound to thread");
            }
            this.doBeforeCommit(readOnly);
            for (IntegrityChecker integrityChecker : this.integrityCheckers) {
                integrityChecker.checkIntegrity();
            }
            for (LuceneIndexerAndSearcher luceneIndexerAndSearcher : this.lucenes) {
                luceneIndexerAndSearcher.prepare();
            }
            for (TransactionalDao transactionalDao : this.daoServices) {
                transactionalDao.beforeCommit();
            }
            for (TransactionalCache transactionalCache : this.transactionalCaches) {
                transactionalCache.beforeCommit(readOnly);
            }
        }

        private void doBeforeCommit(boolean readOnly) {
            this.doBeforeCommit(new HashSet<TransactionListener>(this.listeners.size()), readOnly);
        }

        private void doBeforeCommit(Set<TransactionListener> visitedListeners, boolean readOnly) {
            HashSet<TransactionListener> pendingListeners = new HashSet<TransactionListener>(this.listeners);
            pendingListeners.removeAll(visitedListeners);
            if (pendingListeners.size() != 0) {
                for (TransactionListener listener : pendingListeners) {
                    listener.beforeCommit(readOnly);
                    visitedListeners.add(listener);
                }
                this.doBeforeCommit(visitedListeners, readOnly);
            }
        }

        public void beforeCompletion() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Before completion: " + (Object)((Object)this)));
            }
            for (TransactionListener listener : this.getListenersIterable()) {
                listener.beforeCompletion();
            }
        }

        public void afterCompletion(int status) {
            String statusStr = "unknown";
            switch (status) {
                case 0: {
                    statusStr = "committed";
                    break;
                }
                case 1: {
                    statusStr = "rolled-back";
                    break;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("After completion (" + statusStr + "): " + (Object)((Object)this)));
            }
            AlfrescoTransactionSupport.bindResource(AlfrescoTransactionSupport.RESOURCE_KEY_TXN_COMPLETING, Boolean.TRUE);
            for (TransactionalCache<Serializable, Object> cache : this.transactionalCaches) {
                try {
                    if (status == 0) {
                        cache.afterCommit();
                        continue;
                    }
                    cache.afterRollback();
                }
                catch (RuntimeException e) {
                    logger.error((Object)("After completion (" + statusStr + ") TransactionalCache exception"), (Throwable)e);
                }
            }
            for (LuceneIndexerAndSearcher lucene : this.lucenes) {
                try {
                    if (status == 0) {
                        lucene.commit();
                        continue;
                    }
                    lucene.rollback();
                }
                catch (RuntimeException e) {
                    logger.error((Object)("After completion (" + statusStr + ") Lucene exception"), (Throwable)e);
                }
            }
            List<TransactionListener> iterableListeners = this.getListenersIterable();
            if (status == 0) {
                for (TransactionListener listener : iterableListeners) {
                    try {
                        listener.afterCommit();
                    }
                    catch (RuntimeException e) {
                        logger.error((Object)("After completion (" + statusStr + ") listener exception: \n" + "   listener: " + listener), (Throwable)e);
                    }
                }
            } else {
                for (TransactionListener listener : iterableListeners) {
                    try {
                        listener.afterRollback();
                    }
                    catch (RuntimeException e) {
                        logger.error((Object)("After completion (" + statusStr + ") listener exception: \n" + "   listener: " + listener), (Throwable)e);
                    }
                }
            }
            AlfrescoTransactionSupport.clearSynchronization();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TxnReadState {
        TXN_NONE,
        TXN_READ_ONLY,
        TXN_READ_WRITE;

    }
}

