/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.alfresco.repo.transfer.TransferProgressMonitor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;

final class ChangeCapturingProgressMonitor
implements TransferProgressMonitor {
    private final TransferProgressMonitor delegate;
    private final TreeMap<String, TransferChangesRecord> changeRecords = new TreeMap();

    public ChangeCapturingProgressMonitor(TransferProgressMonitor delegatedProgressMonitor) {
        this.delegate = delegatedProgressMonitor;
    }

    public InputStream getLogInputStream(String transferId) throws TransferException {
        return this.delegate.getLogInputStream(transferId);
    }

    public TransferProgress getProgress(String transferId) throws TransferException {
        return this.delegate.getProgress(transferId);
    }

    public void logComment(String transferId, Object obj) throws TransferException {
        this.delegate.logComment(transferId, obj);
    }

    public void logCreated(String transferId, NodeRef sourceNode, NodeRef destNode, NodeRef newParent, String newPath, boolean orphan) {
        this.delegate.logCreated(transferId, sourceNode, destNode, newParent, newPath, orphan);
        this.getChangesRecord(transferId).addCreatedNode(destNode);
    }

    public void logDeleted(String transferId, NodeRef sourceNode, NodeRef destNode, String parentPath) {
        this.delegate.logDeleted(transferId, sourceNode, destNode, parentPath);
        this.getChangesRecord(transferId).addDeletedNode(destNode);
    }

    public void logException(String transferId, Object obj, Throwable ex) throws TransferException {
        this.delegate.logException(transferId, obj, ex);
    }

    public void logMoved(String transferId, NodeRef sourceNodeRef, NodeRef destNodeRef, String oldPath, NodeRef newParent, String newPath) {
        this.delegate.logMoved(transferId, sourceNodeRef, destNodeRef, oldPath, newParent, newPath);
    }

    public void logUpdated(String transferId, NodeRef sourceNode, NodeRef destNode, String parentPath) {
        this.delegate.logUpdated(transferId, sourceNode, destNode, parentPath);
        this.getChangesRecord(transferId).addUpdatedNode(destNode);
    }

    public void updateProgress(String transferId, int currPos, int endPos) throws TransferException {
        this.delegate.updateProgress(transferId, currPos, endPos);
    }

    public void updateProgress(String transferId, int currPos) throws TransferException {
        this.delegate.updateProgress(transferId, currPos);
    }

    public void updateStatus(String transferId, TransferProgress.Status status) throws TransferException {
        this.delegate.updateStatus(transferId, status);
        if (status == TransferProgress.Status.CANCELLED || status == TransferProgress.Status.ERROR) {
            this.getChangesRecord(transferId).reset();
        }
    }

    public TransferChangesRecord removeChangeRecord(String transferId) {
        return this.changeRecords.remove(transferId);
    }

    private TransferChangesRecord getChangesRecord(String transferId) {
        TransferChangesRecord record = this.changeRecords.get(transferId);
        if (record == null) {
            record = new TransferChangesRecord();
            this.changeRecords.put(transferId, record);
        }
        return record;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TransferChangesRecord {
        private final List<NodeRef> createdNodes = new LinkedList<NodeRef>();
        private final List<NodeRef> updatedNodes = new LinkedList<NodeRef>();
        private final List<NodeRef> deletedNodes = new LinkedList<NodeRef>();

        public List<NodeRef> getCreatedNodes() {
            return this.createdNodes;
        }

        public List<NodeRef> getUpdatedNodes() {
            return this.updatedNodes;
        }

        public List<NodeRef> getDeletedNodes() {
            return this.deletedNodes;
        }

        public void addDeletedNode(NodeRef nodeRef) {
            this.deletedNodes.add(nodeRef);
        }

        public void addUpdatedNode(NodeRef nodeRef) {
            this.updatedNodes.add(nodeRef);
        }

        public void addCreatedNode(NodeRef nodeRef) {
            this.createdNodes.add(nodeRef);
        }

        public void reset() {
            this.createdNodes.clear();
            this.updatedNodes.clear();
            this.deletedNodes.clear();
        }
    }
}

