/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.Arrays;
import java.util.Collection;
import org.alfresco.repo.transfer.AbstractNodeFilter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.transfer.NodeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeNodeFilter
extends AbstractNodeFilter {
    private final Collection<NodeFilter> filters;

    public CompositeNodeFilter(NodeFilter ... filters) {
        this.filters = Arrays.asList(filters);
    }

    public CompositeNodeFilter(Collection<NodeFilter> filters) {
        this.filters = filters;
    }

    @Override
    public void init() {
        super.init();
        for (NodeFilter filter : this.filters) {
            if (!(filter instanceof AbstractNodeFilter)) continue;
            AbstractNodeFilter nodeFilter = (AbstractNodeFilter)filter;
            nodeFilter.setServiceRegistry(this.serviceRegistry);
            nodeFilter.init();
        }
    }

    @Override
    public boolean accept(NodeRef thisNode) {
        for (NodeFilter filter : this.filters) {
            if (filter.accept(thisNode)) continue;
            return false;
        }
        return true;
    }
}

