/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.nio.channels.Channels;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transfer.AbstractTransferProgressMonitor;
import org.alfresco.repo.transfer.TransferFatalException;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;

public class RepoTransferProgressMonitorImpl
extends AbstractTransferProgressMonitor {
    private NodeService nodeService;
    private ContentService contentService;

    public TransferProgress getProgressInternal(String transferId) {
        NodeRef nodeRef = this.getTransferRecord(transferId);
        TransferProgress progress = new TransferProgress();
        progress.setStatus(TransferProgress.Status.valueOf((String)((Object)this.nodeService.getProperty(nodeRef, TransferModel.PROP_TRANSFER_STATUS))));
        progress.setCurrentPosition((Integer)this.nodeService.getProperty(nodeRef, TransferModel.PROP_PROGRESS_POSITION));
        progress.setEndPosition((Integer)this.nodeService.getProperty(nodeRef, TransferModel.PROP_PROGRESS_ENDPOINT));
        progress.setError((Throwable)this.nodeService.getProperty(nodeRef, TransferModel.PROP_TRANSFER_ERROR));
        return progress;
    }

    public void storeError(String transferId, Throwable ex) {
        NodeRef nodeRef = this.getTransferRecord(transferId);
        this.nodeService.setProperty(nodeRef, TransferModel.PROP_TRANSFER_ERROR, (Serializable)ex);
    }

    public void updateProgressInternal(String transferId, int currPos) {
        NodeRef nodeRef = this.getTransferRecord(transferId);
        this.testCancelled(nodeRef);
        this.nodeService.setProperty(nodeRef, TransferModel.PROP_PROGRESS_POSITION, (Serializable)new Integer(currPos));
    }

    public void updateProgressInternal(String transferId, int currPos, int endPos) {
        NodeRef nodeRef = this.getTransferRecord(transferId);
        this.testCancelled(nodeRef);
        this.nodeService.setProperty(nodeRef, TransferModel.PROP_PROGRESS_POSITION, (Serializable)new Integer(currPos));
        this.nodeService.setProperty(nodeRef, TransferModel.PROP_PROGRESS_ENDPOINT, (Serializable)new Integer(endPos));
    }

    public void updateStatusInternal(String transferId, TransferProgress.Status status) {
        NodeRef nodeRef = this.getTransferRecord(transferId);
        this.nodeService.setProperty(nodeRef, TransferModel.PROP_TRANSFER_STATUS, (Serializable)((Object)status.toString()));
    }

    private void testCancelled(NodeRef transferRecord) throws TransferFatalException {
        TransferProgress.Status currentStatus = TransferProgress.Status.valueOf((String)((Object)this.nodeService.getProperty(transferRecord, TransferModel.PROP_TRANSFER_STATUS)));
        if (TransferProgress.Status.CANCELLED.equals((Object)currentStatus)) {
            throw new TransferFatalException("transfer_service.receiver.transfer_cancelled", new Object[]{transferRecord.toString()});
        }
    }

    private NodeRef getTransferRecord(String transferId) throws TransferException {
        NodeRef nodeRef = new NodeRef(transferId);
        if (!this.nodeService.exists(nodeRef) || !this.nodeService.getType(nodeRef).equals((Object)TransferModel.TYPE_TRANSFER_RECORD)) {
            throw new TransferException("transfer_service.receiver.transfer_not_found", new Object[]{transferId});
        }
        return nodeRef;
    }

    public InputStream getLogInputStream(String transferId) throws TransferException {
        NodeRef transferRecord = this.getTransferRecord(transferId);
        ContentReader reader = this.contentService.getReader(transferRecord, ContentModel.PROP_CONTENT);
        if (reader != null) {
            return reader.getContentInputStream();
        }
        return null;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    protected Writer createUnderlyingLogWriter(String transferId) {
        NodeRef node = new NodeRef(transferId);
        ContentWriter contentWriter = this.contentService.getWriter(node, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/xml");
        contentWriter.setEncoding("UTF-8");
        return Channels.newWriter(contentWriter.getWritableChannel(), "UTF-8");
    }
}

