/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.urlshortening;

import java.util.ArrayList;
import org.alfresco.service.cmr.urlshortening.UrlShortener;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BitlyUrlShortenerImpl
implements UrlShortener {
    private static final Log log = LogFactory.getLog(BitlyUrlShortenerImpl.class);
    private int urlLength = 20;
    private String username;
    private String apiKey = "R_ca15c6c89e9b25ccd170bafd209a0d4f";
    private HttpClient httpClient = new HttpClient();

    public BitlyUrlShortenerImpl() {
        this.httpClient.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setHost("api-ssl.bitly.com", 443, Protocol.getProtocol((String)"https"));
        this.httpClient.setHostConfiguration(hostConfiguration);
    }

    public String shortenUrl(String longUrl) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Shortening URL: " + longUrl));
        }
        String shortUrl = longUrl;
        if (longUrl.length() > this.urlLength) {
            GetMethod getMethod = new GetMethod();
            getMethod.setPath("/v3/shorten");
            ArrayList<NameValuePair> args = new ArrayList<NameValuePair>();
            args.add(new NameValuePair("login", this.username));
            args.add(new NameValuePair("apiKey", this.apiKey));
            args.add(new NameValuePair("longUrl", longUrl));
            args.add(new NameValuePair("format", "txt"));
            getMethod.setQueryString(args.toArray(new NameValuePair[args.size()]));
            try {
                int resultCode = this.httpClient.executeMethod((HttpMethod)getMethod);
                if (resultCode == 200) {
                    shortUrl = getMethod.getResponseBodyAsString();
                } else {
                    log.warn((Object)("Failed to shorten URL " + longUrl + "  - response code == " + resultCode));
                    log.warn((Object)getMethod.getResponseBodyAsString());
                }
            }
            catch (Exception ex) {
                log.error((Object)("Failed to shorten URL " + longUrl), (Throwable)ex);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("URL " + longUrl + " has been shortened to " + shortUrl));
            }
        }
        return shortUrl.trim();
    }

    public int getUrlLength() {
        return this.urlLength;
    }

    public void setUrlLength(int urlLength) {
        this.urlLength = urlLength;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }
}

