/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.usage;

import java.util.Date;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.repo.usage.RepoUsageComponent;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.admin.RepoUsageStatus;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

public class RepoUsageMonitor
implements RepoUsageComponent.RestrictionObserver {
    private static Log logger = LogFactory.getLog(RepoUsageMonitor.class);
    private Scheduler scheduler;
    private TransactionServiceImpl transactionService;
    private RepoUsageComponent repoUsageComponent;
    private final QName vetoName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"RepoUsageMonitor");

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setTransactionService(TransactionService transactionService) {
        try {
            this.transactionService = (TransactionServiceImpl)transactionService;
        }
        catch (ClassCastException e) {
            throw new AlfrescoRuntimeException("The RepoUsageMonitor needs direct access to the TransactionServiceImpl");
        }
    }

    public void setRepoUsageComponent(RepoUsageComponent repoUsageComponent) {
        this.repoUsageComponent = repoUsageComponent;
    }

    public void init() throws SchedulerException {
        PropertyCheck.mandatory((Object)this, (String)"scheduler", (Object)this.scheduler);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"repoUsageComponent", (Object)this.repoUsageComponent);
        JobDetail jobDetail = new JobDetail("rmj", "DEFAULT", RepoUsageMonitorJob.class);
        jobDetail.getJobDataMap().put((Object)"RepoUsageMonitor", (Object)this);
        Trigger trigger = TriggerUtils.makeHourlyTrigger((int)12);
        trigger.setStartTime(new Date(System.currentTimeMillis() + 3600000L));
        trigger.setName("rmt");
        trigger.setGroup("DEFAULT");
        this.repoUsageComponent.observeRestrictions(this);
        this.scheduler.unscheduleJob("rmt", "DEFAULT");
        this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public void checkUsages() {
        final RetryingTransactionHelper.RetryingTransactionCallback<Void> checkWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                RepoUsage restrictions = RepoUsageMonitor.this.repoUsageComponent.getRestrictions();
                if (restrictions.getUsers() == null && restrictions.getDocuments() == null) {
                    RepoUsageMonitor.this.transactionService.setAllowWrite(true, RepoUsageMonitor.this.vetoName);
                    return null;
                }
                if (restrictions.getUsers() != null) {
                    RepoUsageMonitor.this.repoUsageComponent.updateUsage(RepoUsage.UsageType.USAGE_USERS);
                }
                if (restrictions.getDocuments() != null) {
                    RepoUsageMonitor.this.repoUsageComponent.updateUsage(RepoUsage.UsageType.USAGE_DOCUMENTS);
                }
                RepoUsageMonitor.this.onChangeRestriction(restrictions);
                return null;
            }
        };
        AuthenticationUtil.RunAsWork<Void> runAs = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoUsageMonitor.this.transactionService.getRetryingTransactionHelper().doInTransaction(checkWork, false);
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)runAs, (String)AuthenticationUtil.getSystemUserName());
    }

    public void onChangeRestriction(RepoUsage restrictions) {
        RepoUsageStatus status = this.repoUsageComponent.getUsageStatus();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Current status is " + status));
        }
        status.logMessages(logger);
        if (status.getLevel() == RepoUsageStatus.RepoUsageLevel.LOCKED_DOWN) {
            this.transactionService.setAllowWrite(false, this.vetoName);
        } else {
            this.transactionService.setAllowWrite(true, this.vetoName);
        }
    }

    public static class RepoUsageMonitorJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap jdm = context.getJobDetail().getJobDataMap();
            RepoUsageMonitor repoUsageMonitor = (RepoUsageMonitor)jdm.get((Object)"RepoUsageMonitor");
            repoUsageMonitor.checkUsages();
        }
    }
}

