/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common.versionlabel;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.VersionNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialVersionLabelPolicy
implements VersionServicePolicies.CalculateVersionLabelPolicy {
    public String calculateVersionLabel(QName classRef, Version preceedingVersion, Map<String, Serializable> versionProperties) {
        return this.calculateVersionLabel(classRef, preceedingVersion, 0, versionProperties);
    }

    @Override
    public String calculateVersionLabel(QName classRef, Version preceedingVersion, int versionNumber, Map<String, Serializable> versionProperties) {
        SerialVersionLabel serialVersionNumber = null;
        VersionType versionType = null;
        if (versionProperties != null) {
            versionType = (VersionType)((Object)versionProperties.get("versionType"));
        }
        serialVersionNumber = preceedingVersion != null ? new SerialVersionLabel(preceedingVersion.getVersionLabel()) : new SerialVersionLabel(null);
        if (VersionType.MAJOR.equals((Object)versionType)) {
            serialVersionNumber.majorIncrement();
        } else {
            serialVersionNumber.minorIncrement();
        }
        return serialVersionNumber.toString();
    }

    private class SerialVersionLabel {
        private static final String DELIMITER = ".";
        private int majorRevisionNumber;
        private int minorRevisionNumber;

        public SerialVersionLabel(String versionLabel) {
            if (versionLabel != null && versionLabel.length() != 0) {
                VersionNumber versionNumber = new VersionNumber(versionLabel);
                this.majorRevisionNumber = versionNumber.getPart(0);
                this.minorRevisionNumber = versionNumber.getPart(1);
            } else {
                this.majorRevisionNumber = 0;
                this.minorRevisionNumber = 0;
            }
        }

        public void majorIncrement() {
            ++this.majorRevisionNumber;
            this.minorRevisionNumber = 0;
        }

        public void minorIncrement() {
            ++this.minorRevisionNumber;
        }

        public String toString() {
            return this.majorRevisionNumber + DELIMITER + this.minorRevisionNumber;
        }
    }
}

