/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.PropertyCheck;

public class MTNodesCache2 {
    private boolean enabled = false;
    private NodeService nodeService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private TenantService tenantService;
    private Map<String, NodeRef> nodesCache = new ConcurrentHashMap<String, NodeRef>();
    private NodeRef defaultNode = null;
    private String storeName;
    private String rootPath;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.getNodeService());
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.getSearchService());
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.getNamespaceService());
        PropertyCheck.mandatory((Object)this, (String)"tenantService", (Object)this.getTenantService());
        PropertyCheck.mandatory((Object)this, (String)"storeName", (Object)this.storeName);
        PropertyCheck.mandatory((Object)this, (String)"rootPath", (Object)this.rootPath);
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public NodeRef getNodeForCurrentTenant() {
        NodeRef result = null;
        if (!this.getTenantService().isEnabled()) {
            result = this.defaultNode;
        } else {
            String domain = this.getTenantService().getCurrentUserDomain();
            if (this.nodesCache.containsKey(domain)) {
                result = this.nodesCache.get(domain);
            } else {
                result = this.getTenantService().getRootNode(this.nodeService, this.getSearchService(), this.getNamespaceService(), this.rootPath, this.defaultNode);
                this.nodesCache.put(domain, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBootstrap() {
        if (!this.enabled) {
            return;
        }
        this.nodesCache.clear();
        AuthenticationUtil.setRunAsUserSystem();
        try {
            StoreRef storeRef = new StoreRef(this.storeName);
            if (!this.nodeService.exists(storeRef)) {
                throw new RuntimeException("No store for path: " + this.storeName);
            }
            NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
            List nodeRefs = this.getSearchService().selectNodes(storeRootNodeRef, this.rootPath, null, (NamespacePrefixResolver)this.getNamespaceService(), false);
            if (nodeRefs.size() > 1) {
                throw new RuntimeException("Multiple possible children for : \n   path: " + this.rootPath + "\n" + "   results: " + nodeRefs);
            }
            if (nodeRefs.size() == 0) {
                throw new RuntimeException("Node is not found for : \n   root path: " + this.rootPath);
            }
            this.defaultNode = (NodeRef)nodeRefs.get(0);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            AuthenticationUtil.clearCurrentSecurityContext();
            throw throwable;
        }
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

