/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.wiki;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.wiki.WikiPageInfoImpl;
import org.alfresco.repo.wiki.WikiServiceImpl;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.cmr.wiki.WikiPageInfo;
import org.alfresco.service.cmr.wiki.WikiService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiServiceImplTest {
    private static final String TEST_SITE_PREFIX = "WikiSiteTest";
    private static final long ONE_DAY_MS = 86400000L;
    private static final ApplicationContext testContext = ApplicationContextHelper.getApplicationContext();
    private static MutableAuthenticationService AUTHENTICATION_SERVICE;
    private static BehaviourFilter BEHAVIOUR_FILTER;
    private static WikiService WIKI_SERVICE;
    private static ContentService CONTENT_SERVICE;
    private static DictionaryService DICTIONARY_SERVICE;
    private static NodeService NODE_SERVICE;
    private static NodeService PUBLIC_NODE_SERVICE;
    private static PersonService PERSON_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static TransactionService TRANSACTION_SERVICE;
    private static PermissionService PERMISSION_SERVICE;
    private static SiteService SITE_SERVICE;
    private static TaggingService TAGGING_SERVICE;
    private static final String TEST_USER;
    private static final String ADMIN_USER;
    private static SiteInfo WIKI_SITE;
    private static SiteInfo ALTERNATE_WIKI_SITE;
    private List<NodeRef> testNodesToTidy = new ArrayList<NodeRef>();
    private static List<NodeRef> CLASS_TEST_NODES_TO_TIDY;

    @BeforeClass
    public static void initTestsContext() throws Exception {
        AUTHENTICATION_SERVICE = (MutableAuthenticationService)testContext.getBean("authenticationService");
        BEHAVIOUR_FILTER = (BehaviourFilter)testContext.getBean("policyBehaviourFilter");
        WIKI_SERVICE = (WikiService)testContext.getBean("WikiService");
        CONTENT_SERVICE = (ContentService)testContext.getBean("ContentService");
        DICTIONARY_SERVICE = (DictionaryService)testContext.getBean("dictionaryService");
        NODE_SERVICE = (NodeService)testContext.getBean("nodeService");
        PUBLIC_NODE_SERVICE = (NodeService)testContext.getBean("NodeService");
        PERSON_SERVICE = (PersonService)testContext.getBean("personService");
        TRANSACTION_HELPER = (RetryingTransactionHelper)testContext.getBean("retryingTransactionHelper");
        TRANSACTION_SERVICE = (TransactionService)testContext.getBean("TransactionService");
        PERMISSION_SERVICE = (PermissionService)testContext.getBean("permissionService");
        SITE_SERVICE = (SiteService)testContext.getBean("siteService");
        TAGGING_SERVICE = (TaggingService)testContext.getBean("TaggingService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        WikiServiceImplTest.createUser(TEST_USER);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        WikiServiceImplTest.createTestSites();
    }

    @Test
    public void createNewEntry() throws Exception {
        PagingResults<WikiPageInfo> results = WIKI_SERVICE.listWikiPages(WIKI_SITE.getShortName(), new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        WikiPageInfo page = WIKI_SERVICE.getWikiPage(WIKI_SITE.getShortName(), "madeUp");
        Assert.assertEquals(null, (Object)page);
        page = WIKI_SERVICE.getWikiPage(WIKI_SITE.getShortName(), "madeUp2");
        Assert.assertEquals(null, (Object)page);
        page = WIKI_SERVICE.createWikiPage(WIKI_SITE.getShortName(), "Title", "This Is Some Content");
        Assert.assertNotNull((Object)page.getNodeRef());
        Assert.assertNotNull((Object)page.getSystemName());
        NodeRef container = NODE_SERVICE.getPrimaryParent(page.getNodeRef()).getParentRef();
        NodeRef site = NODE_SERVICE.getPrimaryParent(container).getParentRef();
        Assert.assertEquals((Object)WIKI_SITE.getNodeRef(), (Object)site);
        ContentReader reader = CONTENT_SERVICE.getReader(page.getNodeRef(), ContentModel.PROP_CONTENT);
        Assert.assertEquals((Object)"This Is Some Content", (Object)reader.getContentString());
        Assert.assertEquals((Object)"text/html", (Object)reader.getMimetype());
        Assert.assertEquals((Object)"UTF-8", (Object)reader.getEncoding());
        Assert.assertEquals((Object)"Title", (Object)page.getTitle());
        Assert.assertEquals((Object)"This Is Some Content", (Object)page.getContents());
        Assert.assertEquals((Object)ADMIN_USER, (Object)page.getCreator());
        Assert.assertEquals((long)0L, (long)page.getTags().size());
        page = WIKI_SERVICE.getWikiPage(WIKI_SITE.getShortName(), page.getSystemName());
        Assert.assertEquals((Object)"Title", (Object)page.getTitle());
        Assert.assertEquals((Object)"This Is Some Content", (Object)page.getContents());
        Assert.assertEquals((Object)ADMIN_USER, (Object)page.getCreator());
        Assert.assertEquals((long)0L, (long)page.getTags().size());
        this.testNodesToTidy.add(page.getNodeRef());
    }

    @Test
    public void createUpdateDeleteEntry() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        WikiPageInfo page = WIKI_SERVICE.createWikiPage(WIKI_SITE.getShortName(), "Title", "This Is Some Content");
        this.testNodesToTidy.add(page.getNodeRef());
        Assert.assertEquals((Object)"Title", (Object)page.getSystemName());
        Assert.assertEquals((Object)"Title", (Object)page.getTitle());
        Assert.assertEquals((Object)"This Is Some Content", (Object)page.getContents());
        Assert.assertEquals((Object)TEST_USER, (Object)page.getCreator());
        Assert.assertEquals((long)0L, (long)page.getTags().size());
        page.setTitle("New Title");
        page.setContents("This is new content");
        page = WIKI_SERVICE.updateWikiPage(page);
        Assert.assertEquals((Object)"New_Title", (Object)page.getSystemName());
        Assert.assertEquals((Object)"New Title", (Object)page.getTitle());
        page = WIKI_SERVICE.getWikiPage(WIKI_SITE.getShortName(), page.getSystemName());
        Assert.assertEquals((Object)"New_Title", (Object)page.getSystemName());
        Assert.assertEquals((Object)"New Title", (Object)page.getTitle());
        Assert.assertEquals((Object)"This is new content", (Object)page.getContents());
        Assert.assertEquals((Object)TEST_USER, (Object)page.getCreator());
        Assert.assertEquals((long)0L, (long)page.getTags().size());
        WIKI_SERVICE.deleteWikiPage(page);
        Assert.assertEquals(null, (Object)WIKI_SERVICE.getWikiPage(WIKI_SITE.getShortName(), page.getSystemName()));
        page = WIKI_SERVICE.createWikiPage(WIKI_SITE.getShortName(), "Title Space", "This Is Some Content");
        this.testNodesToTidy.add(page.getNodeRef());
        Assert.assertEquals((Object)"Title_Space", (Object)page.getSystemName());
        Assert.assertEquals((Object)"Title Space", (Object)page.getTitle());
        Assert.assertEquals((Object)"This Is Some Content", (Object)page.getContents());
        Assert.assertEquals((Object)TEST_USER, (Object)page.getCreator());
        Assert.assertEquals((long)0L, (long)page.getTags().size());
        page.setContents("Changed contents");
        page = WIKI_SERVICE.updateWikiPage(page);
        page = WIKI_SERVICE.getWikiPage(WIKI_SITE.getShortName(), page.getSystemName());
        Assert.assertEquals((Object)"Title_Space", (Object)page.getSystemName());
        Assert.assertEquals((Object)"Title Space", (Object)page.getTitle());
        Assert.assertEquals((Object)"Changed contents", (Object)page.getContents());
        Assert.assertEquals((Object)TEST_USER, (Object)page.getCreator());
        Assert.assertEquals((long)0L, (long)page.getTags().size());
        page.setTitle("Alternate Title");
        page = WIKI_SERVICE.updateWikiPage(page);
        page = WIKI_SERVICE.getWikiPage(WIKI_SITE.getShortName(), page.getSystemName());
        Assert.assertEquals((Object)"Alternate_Title", (Object)page.getSystemName());
        Assert.assertEquals((Object)"Alternate Title", (Object)page.getTitle());
        Assert.assertEquals((Object)"Changed contents", (Object)page.getContents());
        Assert.assertEquals((Object)TEST_USER, (Object)page.getCreator());
        Assert.assertEquals((long)0L, (long)page.getTags().size());
    }

    @Test
    public void newContainerSetup() throws Exception {
        String TEST_SITE_NAME = "WikiTestNewTestSite";
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                if (SITE_SERVICE.getSite("WikiTestNewTestSite") != null) {
                    SITE_SERVICE.deleteSite("WikiTestNewTestSite");
                }
                SITE_SERVICE.createSite(WikiServiceImplTest.TEST_SITE_PREFIX, "WikiTestNewTestSite", "Test", "Test", SiteVisibility.PUBLIC);
                Assert.assertFalse((boolean)SITE_SERVICE.hasContainer("WikiTestNewTestSite", "wiki"));
                WIKI_SERVICE.createWikiPage("WikiTestNewTestSite", "Title", "TextTextText");
                Assert.assertTrue((boolean)SITE_SERVICE.hasContainer("WikiTestNewTestSite", "wiki"));
                NodeRef container = SITE_SERVICE.getContainer("WikiTestNewTestSite", "wiki");
                Assert.assertTrue((boolean)TAGGING_SERVICE.isTagScope(container));
                SITE_SERVICE.deleteSite("WikiTestNewTestSite");
                return null;
            }
        });
    }

    @Test
    public void tagging() throws Exception {
        String TAG_1 = "link_tag_1";
        String TAG_2 = "link_tag_2";
        String TAG_3 = "link_tag_3";
        WikiPageInfo page = WIKI_SERVICE.createWikiPage(WIKI_SITE.getShortName(), "Title", "This Is Some Content");
        this.testNodesToTidy.add(page.getNodeRef());
        Assert.assertEquals((long)0L, (long)page.getTags().size());
        page = WIKI_SERVICE.getWikiPage(WIKI_SITE.getShortName(), page.getSystemName());
        Assert.assertEquals((long)0L, (long)page.getTags().size());
        page.getTags().add("link_tag_1");
        page.getTags().add("link_tag_2");
        page.getTags().add("link_tag_1");
        Assert.assertEquals((long)3L, (long)page.getTags().size());
        WIKI_SERVICE.updateWikiPage(page);
        page = WIKI_SERVICE.getWikiPage(WIKI_SITE.getShortName(), page.getSystemName());
        Assert.assertEquals((long)2L, (long)page.getTags().size());
        Assert.assertEquals((Object)true, (Object)page.getTags().contains("link_tag_1"));
        Assert.assertEquals((Object)true, (Object)page.getTags().contains("link_tag_2"));
        Assert.assertEquals((Object)false, (Object)page.getTags().contains("link_tag_3"));
        page.getTags().remove("link_tag_2");
        page.getTags().add("link_tag_3");
        page.getTags().add("link_tag_1");
        WIKI_SERVICE.updateWikiPage(page);
        Assert.assertEquals((long)3L, (long)page.getTags().size());
        Assert.assertEquals((Object)true, (Object)page.getTags().contains("link_tag_1"));
        Assert.assertEquals((Object)false, (Object)page.getTags().contains("link_tag_2"));
        Assert.assertEquals((Object)true, (Object)page.getTags().contains("link_tag_3"));
        page = WIKI_SERVICE.getWikiPage(WIKI_SITE.getShortName(), page.getSystemName());
        Assert.assertEquals((long)2L, (long)page.getTags().size());
        Assert.assertEquals((Object)true, (Object)page.getTags().contains("link_tag_1"));
        Assert.assertEquals((Object)false, (Object)page.getTags().contains("link_tag_2"));
        Assert.assertEquals((Object)true, (Object)page.getTags().contains("link_tag_3"));
        page.getTags().clear();
        WIKI_SERVICE.updateWikiPage(page);
        page = WIKI_SERVICE.getWikiPage(WIKI_SITE.getShortName(), page.getSystemName());
        Assert.assertEquals((long)0L, (long)page.getTags().size());
        page.getTags().add("link_tag_1");
        page.getTags().add("link_tag_2");
        page.getTags().add("link_tag_3");
        WIKI_SERVICE.updateWikiPage(page);
        page = WIKI_SERVICE.getWikiPage(WIKI_SITE.getShortName(), page.getSystemName());
        Assert.assertEquals((long)3L, (long)page.getTags().size());
        Assert.assertEquals((Object)true, (Object)page.getTags().contains("link_tag_1"));
        Assert.assertEquals((Object)true, (Object)page.getTags().contains("link_tag_2"));
        Assert.assertEquals((Object)true, (Object)page.getTags().contains("link_tag_3"));
        WIKI_SERVICE.deleteWikiPage(page);
    }

    @Test
    public void pagesListing() throws Exception {
        PagingRequest paging = new PagingRequest(10);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        PagingResults<WikiPageInfo> results = WIKI_SERVICE.listWikiPages(WIKI_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        WikiPageInfo pageA = WIKI_SERVICE.createWikiPage(WIKI_SITE.getShortName(), "TitleA", "ContentA");
        WikiPageInfo pageB = WIKI_SERVICE.createWikiPage(WIKI_SITE.getShortName(), "TitleB", "ContentB");
        WikiPageInfo pageC = WIKI_SERVICE.createWikiPage(WIKI_SITE.getShortName(), "TitleC", "ContentC");
        this.testNodesToTidy.add(pageA.getNodeRef());
        this.testNodesToTidy.add(pageB.getNodeRef());
        this.testNodesToTidy.add(pageC.getNodeRef());
        results = WIKI_SERVICE.listWikiPages(WIKI_SITE.getShortName(), paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleC", (Object)((WikiPageInfo)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((WikiPageInfo)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((WikiPageInfo)results.getPage().get(2)).getTitle());
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        WikiPageInfo pageD = WIKI_SERVICE.createWikiPage(WIKI_SITE.getShortName(), "TitleD", "ContentD");
        this.testNodesToTidy.add(pageD.getNodeRef());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        paging = new PagingRequest(3);
        results = WIKI_SERVICE.listWikiPages(WIKI_SITE.getShortName(), paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleD", (Object)((WikiPageInfo)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleC", (Object)((WikiPageInfo)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((WikiPageInfo)results.getPage().get(2)).getTitle());
        paging = new PagingRequest(3, 3);
        results = WIKI_SERVICE.listWikiPages(WIKI_SITE.getShortName(), paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleA", (Object)((WikiPageInfo)results.getPage().get(0)).getTitle());
        paging = new PagingRequest(10);
        results = WIKI_SERVICE.listWikiPages(WIKI_SITE.getShortName(), TEST_USER, paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleC", (Object)((WikiPageInfo)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((WikiPageInfo)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((WikiPageInfo)results.getPage().get(2)).getTitle());
        results = WIKI_SERVICE.listWikiPages(WIKI_SITE.getShortName(), ADMIN_USER, paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleD", (Object)((WikiPageInfo)results.getPage().get(0)).getTitle());
        this.pushAuditableDatesBack(pageB, 10, 0);
        this.pushAuditableDatesBack(pageC, 100, 10);
        this.pushAuditableDatesBack(pageD, 0, 100);
        pageA.setContents("UpdatedContentsA");
        pageA = WIKI_SERVICE.updateWikiPage(pageA);
        Date today = new Date();
        Date tomorrow = new Date(today.getTime() + 86400000L);
        Date yesterday = new Date(today.getTime() - 86400000L);
        Date twoWeeksAgo = new Date(today.getTime() - 1209600000L);
        results = WIKI_SERVICE.listWikiPagesByCreated(WIKI_SITE.getShortName(), yesterday, tomorrow, paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleD", (Object)((WikiPageInfo)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((WikiPageInfo)results.getPage().get(1)).getTitle());
        results = WIKI_SERVICE.listWikiPagesByCreated(WIKI_SITE.getShortName(), twoWeeksAgo, yesterday, paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleB", (Object)((WikiPageInfo)results.getPage().get(0)).getTitle());
        results = WIKI_SERVICE.listWikiPagesByCreated(WIKI_SITE.getShortName(), twoWeeksAgo, tomorrow, paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleD", (Object)((WikiPageInfo)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((WikiPageInfo)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((WikiPageInfo)results.getPage().get(2)).getTitle());
        results = WIKI_SERVICE.listWikiPagesByModified(WIKI_SITE.getShortName(), yesterday, tomorrow, paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleA", (Object)((WikiPageInfo)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((WikiPageInfo)results.getPage().get(1)).getTitle());
        results = WIKI_SERVICE.listWikiPagesByModified(WIKI_SITE.getShortName(), twoWeeksAgo, yesterday, paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleC", (Object)((WikiPageInfo)results.getPage().get(0)).getTitle());
        results = WIKI_SERVICE.listWikiPagesByModified(WIKI_SITE.getShortName(), twoWeeksAgo, tomorrow, paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleA", (Object)((WikiPageInfo)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((WikiPageInfo)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleC", (Object)((WikiPageInfo)results.getPage().get(2)).getTitle());
        pageC.setContents("Changed C");
        pageC = WIKI_SERVICE.updateWikiPage(pageC);
        results = WIKI_SERVICE.listWikiPagesByModified(WIKI_SITE.getShortName(), twoWeeksAgo, tomorrow, paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleA", (Object)((WikiPageInfo)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((WikiPageInfo)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleC", (Object)((WikiPageInfo)results.getPage().get(2)).getTitle());
        paging = new PagingRequest(10);
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        results = WIKI_SERVICE.listWikiPages(WIKI_SITE.getShortName(), paging);
        for (WikiPageInfo link : results.getPage()) {
            PUBLIC_NODE_SERVICE.deleteNode(link.getNodeRef());
        }
        results = WIKI_SERVICE.listWikiPages(ALTERNATE_WIKI_SITE.getShortName(), paging);
        for (WikiPageInfo link : results.getPage()) {
            PUBLIC_NODE_SERVICE.deleteNode(link.getNodeRef());
        }
    }

    @Test
    public void pagesListingPermissionsChecking() throws Exception {
        PagingRequest paging = new PagingRequest(10);
        PagingResults<WikiPageInfo> results = WIKI_SERVICE.listWikiPages(WIKI_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = WIKI_SERVICE.listWikiPages(ALTERNATE_WIKI_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        Assert.assertEquals((Object)true, (Object)SITE_SERVICE.isMember(WIKI_SITE.getShortName(), TEST_USER));
        Assert.assertEquals((Object)false, (Object)SITE_SERVICE.isMember(ALTERNATE_WIKI_SITE.getShortName(), TEST_USER));
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        WikiPageInfo pageA = WIKI_SERVICE.createWikiPage(WIKI_SITE.getShortName(), "TitleA", "ContentA");
        WikiPageInfo pageB = WIKI_SERVICE.createWikiPage(WIKI_SITE.getShortName(), "TitleB", "ContentB");
        this.testNodesToTidy.add(pageA.getNodeRef());
        this.testNodesToTidy.add(pageB.getNodeRef());
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        WikiPageInfo pagePrivA = WIKI_SERVICE.createWikiPage(ALTERNATE_WIKI_SITE.getShortName(), "PrivTitleA", "Contents A");
        WikiPageInfo pagePrivB = WIKI_SERVICE.createWikiPage(ALTERNATE_WIKI_SITE.getShortName(), "PrivTitleB", "Contents B");
        WikiPageInfo pagePrivC = WIKI_SERVICE.createWikiPage(ALTERNATE_WIKI_SITE.getShortName(), "PrivTitleC", "Contents C");
        this.testNodesToTidy.add(pagePrivA.getNodeRef());
        this.testNodesToTidy.add(pagePrivB.getNodeRef());
        this.testNodesToTidy.add(pagePrivC.getNodeRef());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        results = WIKI_SERVICE.listWikiPages(WIKI_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = WIKI_SERVICE.listWikiPages(ALTERNATE_WIKI_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                SITE_SERVICE.setMembership(ALTERNATE_WIKI_SITE.getShortName(), TEST_USER, "SiteCollaborator");
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
                return null;
            }
        });
        results = WIKI_SERVICE.listWikiPages(WIKI_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = WIKI_SERVICE.listWikiPages(ALTERNATE_WIKI_SITE.getShortName(), paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        PERMISSION_SERVICE.setInheritParentPermissions(pagePrivC.getNodeRef(), false);
        PERMISSION_SERVICE.clearPermission(pagePrivC.getNodeRef(), TEST_USER);
        results = WIKI_SERVICE.listWikiPages(WIKI_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = WIKI_SERVICE.listWikiPages(ALTERNATE_WIKI_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                SITE_SERVICE.removeMembership(ALTERNATE_WIKI_SITE.getShortName(), TEST_USER);
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
                return null;
            }
        });
        results = WIKI_SERVICE.listWikiPages(WIKI_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = WIKI_SERVICE.listWikiPages(ALTERNATE_WIKI_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        paging = new PagingRequest(10);
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        results = WIKI_SERVICE.listWikiPages(WIKI_SITE.getShortName(), paging);
        for (WikiPageInfo link : results.getPage()) {
            PUBLIC_NODE_SERVICE.deleteNode(link.getNodeRef());
        }
        results = WIKI_SERVICE.listWikiPages(ALTERNATE_WIKI_SITE.getShortName(), paging);
        for (WikiPageInfo link : results.getPage()) {
            PUBLIC_NODE_SERVICE.deleteNode(link.getNodeRef());
        }
    }

    private void pushAuditableDatesBack(WikiPageInfo page, int createdDaysAgo, int modifiedDaysAgo) throws Exception {
        final NodeRef node = page.getNodeRef();
        Date created = page.getCreatedAt();
        final Date newCreated = new Date(created.getTime() - (long)createdDaysAgo * 86400000L);
        Date modified = page.getModifiedAt();
        final Date newModified = new Date(modified.getTime() - (long)modifiedDaysAgo * 86400000L);
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                BEHAVIOUR_FILTER.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
                NODE_SERVICE.setProperty(node, ContentModel.PROP_CREATED, (Serializable)newCreated);
                NODE_SERVICE.setProperty(node, ContentModel.PROP_MODIFIED, (Serializable)newModified);
                return null;
            }
        }, false, true);
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                BEHAVIOUR_FILTER.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
                PUBLIC_NODE_SERVICE.setProperty(node, ContentModel.PROP_CREATED, (Serializable)newCreated);
                PUBLIC_NODE_SERVICE.setProperty(node, ContentModel.PROP_MODIFIED, (Serializable)newModified);
                PUBLIC_NODE_SERVICE.setProperty(node, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Forced Change"));
                return null;
            }
        }, false, true);
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Assert.assertEquals((Object)newCreated, (Object)NODE_SERVICE.getProperty(node, ContentModel.PROP_CREATED));
                Assert.assertEquals((Object)newCreated, (Object)PUBLIC_NODE_SERVICE.getProperty(node, ContentModel.PROP_CREATED));
                Assert.assertEquals((Object)newModified, (Object)NODE_SERVICE.getProperty(node, ContentModel.PROP_MODIFIED));
                Assert.assertEquals((Object)newModified, (Object)PUBLIC_NODE_SERVICE.getProperty(node, ContentModel.PROP_MODIFIED));
                return null;
            }
        }, false, true);
        ((WikiPageInfoImpl)page).setCreatedAt(newCreated);
        ((WikiPageInfoImpl)page).setModifiedAt(newModified);
    }

    private static void createTestSites() throws Exception {
        final WikiServiceImpl privateWikiPageService = (WikiServiceImpl)testContext.getBean("wikiService");
        WIKI_SITE = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            @Override
            public SiteInfo execute() throws Throwable {
                SiteInfo site = SITE_SERVICE.createSite(WikiServiceImplTest.TEST_SITE_PREFIX, WikiServiceImplTest.class.getSimpleName() + "_testSite" + System.currentTimeMillis(), "test site title", "test site description", SiteVisibility.PUBLIC);
                privateWikiPageService.getSiteWikiContainer(site.getShortName(), true);
                CLASS_TEST_NODES_TO_TIDY.add(site.getNodeRef());
                return site;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        ALTERNATE_WIKI_SITE = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            @Override
            public SiteInfo execute() throws Throwable {
                SiteInfo site = SITE_SERVICE.createSite(WikiServiceImplTest.TEST_SITE_PREFIX, WikiServiceImplTest.class.getSimpleName() + "_testAltSite" + System.currentTimeMillis(), "alternate site title", "alternate site description", SiteVisibility.PRIVATE);
                privateWikiPageService.getSiteWikiContainer(site.getShortName(), true);
                CLASS_TEST_NODES_TO_TIDY.add(site.getNodeRef());
                return site;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
    }

    @Before
    public void setAdminUser() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
    }

    @After
    public void deleteTestNodes() throws Exception {
        WikiServiceImplTest.performDeletionOfNodes(this.testNodesToTidy);
    }

    @AfterClass
    public static void deleteClassTestNodesAndUsers() throws Exception {
        WikiServiceImplTest.performDeletionOfNodes(CLASS_TEST_NODES_TO_TIDY);
        WikiServiceImplTest.deleteUser(TEST_USER);
    }

    private static void performDeletionOfNodes(final List<NodeRef> nodesToDelete) {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                for (NodeRef node : nodesToDelete) {
                    if (!NODE_SERVICE.exists(node)) continue;
                    if (NODE_SERVICE.getType(node).equals((Object)SiteModel.TYPE_SITE)) {
                        SiteInfo siteInfo = SITE_SERVICE.getSite(node);
                        SITE_SERVICE.deleteSite(siteInfo.getShortName());
                        continue;
                    }
                    NODE_SERVICE.deleteNode(node);
                }
                return null;
            }
        });
    }

    private static void createUser(final String userName) {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                if (!AUTHENTICATION_SERVICE.authenticationExists(userName)) {
                    AUTHENTICATION_SERVICE.createAuthentication(userName, "PWD".toCharArray());
                }
                if (!PERSON_SERVICE.personExists(userName)) {
                    PropertyMap ppOne = new PropertyMap();
                    ppOne.put(ContentModel.PROP_USERNAME, userName);
                    ppOne.put(ContentModel.PROP_FIRSTNAME, "firstName");
                    ppOne.put(ContentModel.PROP_LASTNAME, "lastName");
                    ppOne.put(ContentModel.PROP_EMAIL, "email@email.com");
                    ppOne.put(ContentModel.PROP_JOBTITLE, "jobTitle");
                    PERSON_SERVICE.createPerson(ppOne);
                }
                return null;
            }
        });
    }

    private static void deleteUser(final String userName) {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                if (PERSON_SERVICE.personExists(userName)) {
                    PERSON_SERVICE.deletePerson(userName);
                }
                return null;
            }
        });
    }

    static {
        TEST_USER = WikiServiceImplTest.class.getSimpleName() + "_testuser";
        ADMIN_USER = AuthenticationUtil.getAdminUserName();
        CLASS_TEST_NODES_TO_TIDY = new ArrayList<NodeRef>();
    }
}

