/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.workflow.WorkflowAdminServiceImpl;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowSuiteContextShutdownTest;
import org.alfresco.repo.workflow.WorkflowTestHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.Test;

public abstract class AbstractMultitenantWorkflowTest
extends BaseSpringTest {
    private static final String XML = "text/xml";
    public static final String DEFAULT_ADMIN_PW = "admin";
    private static final QName ADHOC_TASK = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"adhocTask");
    private final String tenant1 = "wfMTTest1" + GUID.generate();
    private final String tenant2 = "wfMTTest2" + GUID.generate();
    private TenantAdminService tenantAdminService;
    private TenantService tenantService;
    private ServiceRegistry serviceRegistry;
    private WorkflowService workflowService;
    private PersonService personService;
    private String user1;
    private String user2;
    private WorkflowTestHelper wfTestHelper;

    @Test
    public void testDeployWorkflow() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.user1);
        List<WorkflowDefinition> allDefs = this.workflowService.getAllDefinitions();
        int allDefsSize = allDefs.size();
        List<WorkflowDefinition> defs = this.workflowService.getDefinitions();
        int defsSize = defs.size();
        String definitionKey = this.getTestDefinitionKey();
        WorkflowDefinition definition = this.workflowService.getDefinitionByName(definitionKey);
        AbstractMultitenantWorkflowTest.assertNull((Object)definition);
        definition = this.deployDefinition(this.getTestDefinitionPath());
        AbstractMultitenantWorkflowTest.assertNotNull((Object)definition);
        AbstractMultitenantWorkflowTest.assertEquals((String)definitionKey, (String)definition.getName());
        AbstractMultitenantWorkflowTest.assertNotNull((Object)this.workflowService.getDefinitionById(definition.getId()));
        AbstractMultitenantWorkflowTest.assertNotNull((Object)this.workflowService.getDefinitionByName(definitionKey));
        AbstractMultitenantWorkflowTest.assertEquals((int)(defsSize + 1), (int)this.workflowService.getDefinitions().size());
        AbstractMultitenantWorkflowTest.assertEquals((int)(allDefsSize + 1), (int)this.workflowService.getAllDefinitions().size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.user2);
        try {
            AbstractMultitenantWorkflowTest.assertNull((Object)this.workflowService.getDefinitionById(definition.getId()));
            AbstractMultitenantWorkflowTest.fail((String)"Should throw Exception here!");
        }
        catch (Exception e) {
            // empty catch block
        }
        AbstractMultitenantWorkflowTest.assertNull((Object)this.workflowService.getDefinitionByName(definitionKey));
        AbstractMultitenantWorkflowTest.assertEquals((int)defsSize, (int)this.workflowService.getDefinitions().size());
        AbstractMultitenantWorkflowTest.assertEquals((int)allDefsSize, (int)this.workflowService.getAllDefinitions().size());
        AbstractMultitenantWorkflowTest.assertNotNull((Object)this.deployDefinition(this.getTestDefinitionPath()));
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.user1);
        WorkflowDefinition definitionByName = this.workflowService.getDefinitionByName(definitionKey);
        AbstractMultitenantWorkflowTest.assertEquals((String)definition.getId(), (String)definitionByName.getId());
    }

    public void testQueryTasks() throws Exception {
        WorkflowTaskQuery query = new WorkflowTaskQuery();
        query.setTaskName(ADHOC_TASK);
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.user1);
        List<WorkflowTask> tasks = this.workflowService.queryTasks(query);
        AbstractMultitenantWorkflowTest.assertEquals((int)0, (int)tasks.size());
        String adhocKey = this.getAdhocDefinitionKey();
        WorkflowDefinition adhocDef1 = this.workflowService.getDefinitionByName(adhocKey);
        AbstractMultitenantWorkflowTest.assertNotNull((Object)adhocDef1);
        NodeRef assignee1 = this.personService.getPerson(this.user1);
        NodeRef pckg1 = this.workflowService.createPackage(null);
        HashMap<QName, Serializable> parameters1 = new HashMap<QName, Serializable>();
        parameters1.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)pckg1);
        parameters1.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)assignee1);
        WorkflowPath path = this.workflowService.startWorkflow(adhocDef1.getId(), parameters1);
        String instanceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(instanceId);
        this.workflowService.endTask(startTask.getId(), null);
        tasks = this.workflowService.queryTasks(query);
        AbstractMultitenantWorkflowTest.assertEquals((int)1, (int)tasks.size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.user2);
        tasks = this.workflowService.queryTasks(query);
        AbstractMultitenantWorkflowTest.assertEquals((int)0, (int)tasks.size());
        WorkflowDefinition adhocDef2 = this.workflowService.getDefinitionByName(adhocKey);
        NodeRef assignee2 = this.personService.getPerson(this.user2);
        NodeRef pckg2 = this.workflowService.createPackage(null);
        HashMap<QName, Serializable> parameters2 = new HashMap<QName, Serializable>();
        parameters2.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)pckg2);
        parameters2.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)assignee2);
        WorkflowPath path2 = this.workflowService.startWorkflow(adhocDef2.getId(), parameters2);
        String path2Id = path2.getId();
        String instanceId2 = path2.getInstance().getId();
        WorkflowTask startTask2 = this.workflowService.getStartTask(instanceId2);
        this.workflowService.endTask(startTask2.getId(), null);
        tasks = this.workflowService.queryTasks(query);
        AbstractMultitenantWorkflowTest.assertEquals((int)1, (int)tasks.size());
        AbstractMultitenantWorkflowTest.assertEquals((String)path2Id, (String)tasks.get(0).getPath().getId());
    }

    protected void onSetUpBeforeTransaction() throws Exception {
        super.onSetUpBeforeTransaction();
        this.serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.tenantService = (TenantService)this.applicationContext.getBean("tenantService");
        this.tenantAdminService = (TenantAdminService)this.applicationContext.getBean("tenantAdminService");
        this.workflowService = this.serviceRegistry.getWorkflowService();
        this.personService = this.serviceRegistry.getPersonService();
        WorkflowAdminServiceImpl workflowAdminService = (WorkflowAdminServiceImpl)this.applicationContext.getBean("workflowAdminService");
        this.wfTestHelper = new WorkflowTestHelper(workflowAdminService, this.getEngine(), true);
        AuthenticationUtil.clearCurrentSecurityContext();
        this.user1 = this.createTenant(this.tenant1);
        this.user2 = this.createTenant(this.tenant2);
    }

    private String createTenant(final String tenantDomain) {
        return (String)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                if (!AbstractMultitenantWorkflowTest.this.tenantAdminService.existsTenant(tenantDomain)) {
                    AbstractMultitenantWorkflowTest.this.tenantAdminService.createTenant(tenantDomain, ("admin " + tenantDomain).toCharArray(), null);
                }
                return AbstractMultitenantWorkflowTest.this.tenantService.getDomainUser(AuthenticationUtil.getAdminUserName(), tenantDomain);
            }
        });
    }

    protected void onTearDown() throws Exception {
        this.wfTestHelper.tearDown();
        super.onTearDown();
        WorkflowSuiteContextShutdownTest.closeContext();
    }

    protected WorkflowDefinition deployDefinition(String resource) {
        InputStream input = this.getInputStream(resource);
        WorkflowDeployment deployment = this.workflowService.deployDefinition(this.getEngine(), input, XML);
        WorkflowDefinition definition = deployment.getDefinition();
        return definition;
    }

    private InputStream getInputStream(String resource) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(resource);
    }

    protected String[] getConfigLocations() {
        return new String[]{ApplicationContextHelper.CONFIG_LOCATIONS[0], "classpath:tenant/mt-*context.xml"};
    }

    protected abstract String getTestDefinitionPath();

    protected abstract String getTestDefinitionKey();

    protected abstract String getAdhocDefinitionKey();

    protected abstract String getEngine();
}

