/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.runtime.ProcessInstance;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ActivitiSpringTest
extends TestCase {
    private static final QName PROP_CHECK_VALUE = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"check_value");
    private static final String PROC_DEF_KEY = "testTask";
    private static final String ACTIVITI_CONTEXT = "classpath:alfresco/activiti-context.xml";
    private static final QName ASPECT = ContentModel.ASPECT_ATTACHABLE;
    private RuntimeService runtime;
    private RepositoryService repo;
    private Deployment deployment;
    private AuthenticationComponent authenticationComponent;
    private NodeService nodeService;
    private RetryingTransactionHelper txnHelper;
    private NodeRef workingNodeRef;

    public void testSmoke() throws Exception {
        ActivitiSpringTest.assertNotNull((Object)this.runtime);
        ProcessInstance instance = this.runtime.startProcessInstanceByKey(PROC_DEF_KEY);
        ActivitiSpringTest.assertNotNull((Object)instance);
        String instanceId = instance.getId();
        ProcessInstance instanceInDb = this.findProcessInstance(instanceId);
        ActivitiSpringTest.assertNotNull((Object)instanceInDb);
        this.runtime.deleteProcessInstance(instance.getId(), "");
        ActivitiSpringTest.assertNotNull((Object)instance);
    }

    public void testRollbackFromAlfresco() {
        RetryingTransactionHelper.RetryingTransactionCallback<String> callback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Throwable {
                ProcessInstance instance = ActivitiSpringTest.this.runtime.startProcessInstanceByKey(ActivitiSpringTest.PROC_DEF_KEY);
                String id = instance.getId();
                try {
                    ActivitiSpringTest.this.blowUp();
                }
                catch (InvalidNodeRefException invalidNodeRefException) {
                    // empty catch block
                }
                return id;
            }
        };
        String id = this.txnHelper.doInTransaction(callback);
        ProcessInstance instance = this.findProcessInstance(id);
        if (instance != null) {
            this.runtime.deleteProcessInstance(id, "For test");
            ActivitiSpringTest.fail((String)"The process instance creation should have been rolled back!");
        }
    }

    public void testRollbackFromActiviti() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ActivitiSpringTest.this.nodeService.addAspect(ActivitiSpringTest.this.workingNodeRef, ASPECT, null);
                Assert.assertTrue((String)"The node should have the aspect!", (boolean)ActivitiSpringTest.this.nodeService.hasAspect(ActivitiSpringTest.this.workingNodeRef, ASPECT));
                try {
                    ActivitiSpringTest.this.runtime.signal("Fake Id");
                    Assert.fail((String)"Should throw an Exception here!");
                }
                catch (ActivitiException activitiException) {
                    // empty catch block
                }
                return null;
            }
        };
        this.txnHelper.doInTransaction(callback);
        ActivitiSpringTest.assertFalse((String)"The node should not have the aspect!", (boolean)this.nodeService.hasAspect(this.workingNodeRef, ASPECT));
    }

    public void testNestedWithoutPropogation() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void execute() throws Throwable {
                Void void_;
                ProcessInstance instance = ActivitiSpringTest.this.runtime.startProcessInstanceByKey(ActivitiSpringTest.PROC_DEF_KEY);
                final String id = instance.getId();
                ProcessInstance instanceInDb = ActivitiSpringTest.this.findProcessInstance(id);
                Assert.assertNotNull((String)"Can't read process instance in same transaction!", (Object)instanceInDb);
                RetryingTransactionHelper.RetryingTransactionCallback<Void> callbackInner = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    @Override
                    public Void execute() throws Throwable {
                        ProcessInstance instanceInDb2 = ActivitiSpringTest.this.findProcessInstance(id);
                        Assert.assertNull((String)"Should not be able to read process instance in inner transaction!", (Object)instanceInDb2);
                        return null;
                    }
                };
                try {
                    ActivitiSpringTest.this.txnHelper.doInTransaction(callbackInner, false, true);
                    void_ = null;
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    ActivitiSpringTest.this.runtime.deleteProcessInstance(id, "FOr test");
                    throw throwable;
                }
                ActivitiSpringTest.this.runtime.deleteProcessInstance(id, "FOr test");
                return void_;
            }
        };
        this.txnHelper.doInTransaction(callback);
    }

    private Long blowUp() {
        NodeRef invalidNodeRef = new NodeRef(this.workingNodeRef.getStoreRef(), "BOGUS");
        this.nodeService.setProperty(invalidNodeRef, PROP_CHECK_VALUE, null);
        ActivitiSpringTest.fail((String)"Expected to generate an InvalidNodeRefException");
        return null;
    }

    private ProcessInstance findProcessInstance(String instanceId) {
        return (ProcessInstance)this.runtime.createProcessInstanceQuery().processInstanceId(instanceId).singleResult();
    }

    protected void setUp() throws Exception {
        ConfigurableApplicationContext appContext = this.loadContext();
        this.repo = (RepositoryService)appContext.getBean("activitiRepositoryService");
        this.runtime = (RuntimeService)appContext.getBean("activitiRuntimeService");
        ServiceRegistry serviceRegistry = (ServiceRegistry)appContext.getBean("ServiceRegistry");
        this.authenticationComponent = (AuthenticationComponent)appContext.getBean("authenticationComponent");
        TransactionService transactionService = serviceRegistry.getTransactionService();
        this.nodeService = serviceRegistry.getNodeService();
        this.txnHelper = transactionService.getRetryingTransactionHelper();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        StoreRef storeRef = this.nodeService.createStore("workspace", "test-" + this.getName() + "-" + System.currentTimeMillis());
        NodeRef rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.workingNodeRef = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getName()), ContentModel.TYPE_CMOBJECT).getChildRef();
        String resource = "org/alfresco/repo/workflow/activiti/testTransaction.bpmn20.xml";
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream input = classLoader.getResourceAsStream(resource);
        this.deployment = this.repo.createDeployment().addInputStream(resource, input).deploy();
    }

    private String[] getConfigLocations() {
        Object[] defaultLocations = ApplicationContextHelper.CONFIG_LOCATIONS;
        Object[] locations = ArrayUtils.add((Object[])defaultLocations, (Object)ACTIVITI_CONTEXT);
        return (String[])locations;
    }

    private ConfigurableApplicationContext loadContext() throws Exception {
        String[] locations = this.getConfigLocations();
        return new ClassPathXmlApplicationContext(locations);
    }

    protected void tearDown() throws Exception {
        try {
            this.repo.deleteDeployment(this.deployment.getId());
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

