/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.workflow.AbstractWorkflowServiceIntegrationTest;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.QName;

public class ActivitiWorkflowServiceIntegrationTest
extends AbstractWorkflowServiceIntegrationTest {
    public void testOutcome() throws Exception {
        WorkflowDefinition definition = this.deployDefinition("alfresco/workflow/review.bpmn20.xml");
        this.personManager.setUser(USER1);
        HashMap<QName, Serializable> params = new HashMap<QName, Serializable>();
        NodeRef wfPackage = this.workflowService.createPackage(null);
        params.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)wfPackage);
        NodeRef assignee = this.personManager.get(USER2);
        params.put(WorkflowModel.ASSOC_ASSIGNEE, (Serializable)assignee);
        WorkflowPath path = this.workflowService.startWorkflow(definition.getId(), params);
        String instanceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(instanceId);
        this.workflowService.endTask(startTask.getId(), null);
        List<WorkflowPath> paths = this.workflowService.getWorkflowPaths(instanceId);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)1, (int)paths.size());
        path = paths.get(0);
        List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask reviewTask = tasks.get(0);
        QName outcomePropName = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"reviewOutcome");
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        props.put(outcomePropName, (Serializable)((Object)"Approve"));
        this.workflowService.updateTask(reviewTask.getId(), props, null, null);
        WorkflowTask result = this.workflowService.endTask(reviewTask.getId(), null);
        Serializable outcome = result.getProperties().get(WorkflowModel.PROP_OUTCOME);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((Object)"Approve", (Object)outcome);
    }

    public void testStartTaskEndsAutomatically() {
        WorkflowDefinition definition = this.deployDefinition(this.getTestDefinitionPath());
        WorkflowPath path = this.workflowService.startWorkflow(definition.getId(), null);
        String instanceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(instanceId);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((Object)((Object)WorkflowTaskState.COMPLETED), (Object)((Object)startTask.getState()));
        List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)1, (int)tasks.size());
        String taskName = tasks.get(0).getName();
        ActivitiWorkflowServiceIntegrationTest.assertEquals((String)"bpm_foo_task", (String)taskName);
    }

    public void testPriorityIsValid() {
        WorkflowDefinition definition = this.deployDefinition("activiti/testCustomActiviti.bpmn20.xml");
        this.personManager.setUser(USER1);
        WorkflowPath path = this.workflowService.startWorkflow(definition.getId(), null);
        String instanceId = path.getInstance().getId();
        WorkflowTask startTask = this.workflowService.getStartTask(instanceId);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((Object)((Object)WorkflowTaskState.COMPLETED), (Object)((Object)startTask.getState()));
        List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        for (WorkflowTask workflowTask : tasks) {
            Map<QName, Serializable> props = workflowTask.getProperties();
            TypeDefinition typeDefinition = workflowTask.getDefinition().getMetadata();
            Map propertyDefs = typeDefinition.getProperties();
            PropertyDefinition priorDef = (PropertyDefinition)propertyDefs.get(WorkflowModel.PROP_PRIORITY);
            ActivitiWorkflowServiceIntegrationTest.assertEquals((Object)props.get(WorkflowModel.PROP_PRIORITY), (Object)Integer.valueOf(priorDef.getDefaultValue()));
        }
    }

    protected void checkTaskQueryStartTaskCompleted(String workflowInstanceId, WorkflowTask startTask) {
        List<String> expectedTasks = Arrays.asList(startTask.getId());
        this.checkProcessIdQuery(workflowInstanceId, expectedTasks, WorkflowTaskState.COMPLETED);
        this.checkTaskIdQuery(startTask.getId(), WorkflowTaskState.COMPLETED);
        QName startTaskName = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"submitAdhocTask");
        this.checkTaskNameQuery(startTaskName, expectedTasks, WorkflowTaskState.COMPLETED, workflowInstanceId);
        this.checkActorIdQuery(USER1, expectedTasks, WorkflowTaskState.COMPLETED, workflowInstanceId);
        this.checkIsActiveQuery(expectedTasks, WorkflowTaskState.COMPLETED, workflowInstanceId);
        this.checkTaskPropsQuery(expectedTasks, WorkflowTaskState.COMPLETED, workflowInstanceId);
    }

    protected void checkTaskQueryTaskCompleted(String workflowInstanceId, WorkflowTask theTask, WorkflowTask startTask) {
        List<String> withoutStartTask = Arrays.asList(theTask.getId());
        List<String> bothTasks = Arrays.asList(theTask.getId(), startTask.getId());
        this.checkProcessIdQuery(workflowInstanceId, bothTasks, WorkflowTaskState.COMPLETED);
        QName taskName = QName.createQName((String)"http://www.alfresco.org/model/workflow/1.0", (String)"adhocTask");
        this.checkTaskNameQuery(taskName, withoutStartTask, WorkflowTaskState.COMPLETED, null);
        this.checkActorIdQuery(USER2, withoutStartTask, WorkflowTaskState.COMPLETED, null);
        this.checkIsActiveQuery(bothTasks, WorkflowTaskState.COMPLETED, workflowInstanceId);
        this.checkTaskPropsQuery(withoutStartTask, WorkflowTaskState.COMPLETED, null);
        this.checkProcessPropsQuery(withoutStartTask, WorkflowTaskState.COMPLETED);
    }

    protected void checkQueryTasksInactiveWorkflow(String workflowInstanceId) {
        WorkflowTaskQuery taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setActive(false);
        taskQuery.setProcessId(workflowInstanceId);
        List<WorkflowTask> tasks = this.workflowService.queryTasks(taskQuery);
        ActivitiWorkflowServiceIntegrationTest.assertNotNull(tasks);
        ActivitiWorkflowServiceIntegrationTest.assertEquals((int)3, (int)tasks.size());
        taskQuery = this.createWorkflowTaskQuery(WorkflowTaskState.COMPLETED);
        taskQuery.setActive(true);
        taskQuery.setProcessId(workflowInstanceId);
        this.checkNoTasksFoundUsingQuery(taskQuery);
    }

    protected String getEngine() {
        return "activiti";
    }

    protected String getTestDefinitionPath() {
        return "activiti/testTransaction.bpmn20.xml";
    }

    protected String getAdhocDefinitionPath() {
        return "alfresco/workflow/adhoc.bpmn20.xml";
    }

    protected String getPooledReviewDefinitionPath() {
        return "alfresco/workflow/review-pooled.bpmn20.xml";
    }

    protected String getParallelReviewDefinitionPath() {
        return "alfresco/workflow/parallel-review.bpmn20.xml";
    }

    protected String getTestTimerDefinitionPath() {
        return "activiti/testTimer.bpmn20.xml";
    }

    protected QName getAdhocProcessName() {
        return QName.createQName((String)"activitiAdhoc");
    }
}

