/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.util.List;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.BpmnParseListener;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.impl.util.xml.Element;
import org.activiti.engine.impl.variable.VariableDeclaration;
import org.alfresco.repo.tenant.TenantService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfrescoBpmnParseListener
implements BpmnParseListener {
    private TaskListener completeTaskListener;
    private TaskListener createTaskListener;
    private ExecutionListener processCreateListener;
    private TenantService tenantService;

    public void parseUserTask(Element userTaskElement, ScopeImpl scope, ActivityImpl activity) {
        ActivityBehavior activitybehaviour = activity.getActivityBehavior();
        if (activitybehaviour instanceof UserTaskActivityBehavior) {
            UserTaskActivityBehavior userTaskActivity = (UserTaskActivityBehavior)activitybehaviour;
            if (this.createTaskListener != null) {
                userTaskActivity.getTaskDefinition().addTaskListener("create", this.createTaskListener);
            }
            if (this.completeTaskListener != null) {
                userTaskActivity.getTaskDefinition().addTaskListener("complete", this.completeTaskListener);
            }
        }
    }

    public void parseProcess(Element processElement, ProcessDefinitionEntity processDefinition) {
    }

    public void parseStartEvent(Element startEventElement, ScopeImpl scope, ActivityImpl startEventActivity) {
    }

    public void parseExclusiveGateway(Element exclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
    }

    public void parseParallelGateway(Element parallelGwElement, ScopeImpl scope, ActivityImpl activity) {
    }

    public void parseScriptTask(Element scriptTaskElement, ScopeImpl scope, ActivityImpl activity) {
    }

    public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
    }

    public void parseTask(Element taskElement, ScopeImpl scope, ActivityImpl activity) {
    }

    public void parseManualTask(Element manualTaskElement, ScopeImpl scope, ActivityImpl activity) {
    }

    public void parseEndEvent(Element endEventElement, ScopeImpl scope, ActivityImpl activity) {
    }

    public void parseBoundaryTimerEventDefinition(Element timerEventDefinition, boolean interrupting, ActivityImpl timerActivity) {
    }

    public void parseSubProcess(Element subProcessElement, ScopeImpl scope, ActivityImpl activity) {
    }

    public void parseCallActivity(Element callActivityElement, ScopeImpl scope, ActivityImpl activity) {
    }

    public void parseProperty(Element propertyElement, VariableDeclaration variableDeclaration, ActivityImpl activity) {
    }

    public void parseSequenceFlow(Element sequenceFlowElement, ScopeImpl scopeElement, TransitionImpl transition) {
    }

    public void parseSendTask(Element sendTaskElement, ScopeImpl scope, ActivityImpl activity) {
    }

    public void parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope, ActivityImpl activity) {
    }

    public void parseBoundaryErrorEventDefinition(Element errorEventDefinition, boolean interrupting, ActivityImpl activity, ActivityImpl nestedErrorEventActivity) {
    }

    public void parseIntermediateTimerEventDefinition(Element timerEventDefinition, ActivityImpl timerActivity) {
    }

    public void parseRootElement(Element arg0, List<ProcessDefinitionEntity> arg1) {
        for (ProcessDefinitionEntity processDefinition : arg1) {
            processDefinition.addExecutionListener("start", this.processCreateListener);
            if (!this.tenantService.isEnabled()) continue;
            String key = this.tenantService.getName(processDefinition.getKey());
            processDefinition.setKey(key);
        }
    }

    public void parseMultiInstanceLoopCharacteristics(Element activityElement, Element multiInstanceLoopCharacteristicsElement, ActivityImpl activity) {
    }

    public void setCompleteTaskListener(TaskListener completeTaskListener) {
        this.completeTaskListener = completeTaskListener;
    }

    public void setCreateTaskListener(TaskListener createTaskListener) {
        this.createTaskListener = createTaskListener;
    }

    public void setProcessCreateListener(ExecutionListener processCreateListener) {
        this.processCreateListener = processCreateListener;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }
}

