/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti.tasklistener;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.delegate.VariableScope;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.repo.workflow.activiti.script.ActivitiScriptBase;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptTaskListener
extends ActivitiScriptBase
implements TaskListener {
    private static final String TASK_BINDING_NAME = "task";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notify(DelegateTask delegateTask) {
        if (this.script == null) throw new IllegalArgumentException("The field 'script' should be set on the TaskListener");
        String scriptString = this.getStringValue(this.script, (VariableScope)delegateTask);
        String scriptProcessorName = this.getStringValue(this.scriptProcessor, (VariableScope)delegateTask);
        String runAsUser = this.getStringValue(this.runAs, (VariableScope)delegateTask);
        boolean clearAuthenticationContext = this.checkFullyAuthenticatedUser(delegateTask);
        Map<String, Object> scriptModel = this.getInputMap(delegateTask, runAsUser);
        this.getServiceRegistry().getScriptService().buildCoreModel(scriptModel);
        try {
            Object scriptOutput = this.executeScript(scriptString, scriptModel, scriptProcessorName, runAsUser);
            if (scriptOutput != null) {
                // empty if block
            }
            Object var9_8 = null;
            if (!clearAuthenticationContext) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!clearAuthenticationContext) throw throwable;
            AuthenticationUtil.clearCurrentSecurityContext();
            throw throwable;
        }
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    protected Map<String, Object> getInputMap(DelegateTask delegateTask, String runAsUser) {
        HashMap<String, Object> scriptModel = new HashMap<String, Object>(1);
        ActivitiScriptNode personNode = this.getPersonNode(runAsUser);
        if (personNode != null) {
            ServiceRegistry registry = this.getServiceRegistry();
            scriptModel.put("person", personNode);
            NodeRef userHomeNode = (NodeRef)registry.getNodeService().getProperty(personNode.getNodeRef(), ContentModel.PROP_HOMEFOLDER);
            if (userHomeNode != null) {
                scriptModel.put("userhome", new ActivitiScriptNode(userHomeNode, registry));
            }
        }
        scriptModel.put(TASK_BINDING_NAME, delegateTask);
        scriptModel.put("execution", delegateTask.getExecution());
        Map variables = delegateTask.getExecution().getVariables();
        for (Map.Entry varEntry : variables.entrySet()) {
            scriptModel.put((String)varEntry.getKey(), varEntry.getValue());
        }
        return scriptModel;
    }

    private boolean checkFullyAuthenticatedUser(DelegateTask delegateTask) {
        String userName;
        if (AuthenticationUtil.getFullyAuthenticatedUser() == null && (userName = delegateTask.getAssignee()) != null) {
            AuthenticationUtil.setFullyAuthenticatedUser((String)userName);
            return true;
        }
        return false;
    }
}

