/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.repo.workflow.jbpm.JBPMNodeList;
import org.alfresco.repo.workflow.jbpm.JBPMSpringActionHandler;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.dom4j.Element;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.springframework.beans.factory.BeanFactory;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlfrescoJavaScript
extends JBPMSpringActionHandler {
    private static final long serialVersionUID = -2908748080671212745L;
    private static JpdlXmlReader jpdlReader = new JpdlXmlReader((InputSource)null);
    private ServiceRegistry services;
    private NodeRef companyHome;
    private Element script;
    private String runas;

    @Override
    protected void initialiseHandler(BeanFactory factory) {
        this.services = (ServiceRegistry)factory.getBean("ServiceRegistry");
        Repository repositoryHelper = (Repository)factory.getBean("repositoryHelper");
        this.companyHome = repositoryHelper.getCompanyHome();
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        if (this.script == null) {
            throw new WorkflowException("Script has not been provided");
        }
        boolean isTextOnly = this.isScriptOnlyText();
        List<VariableAccess> variableAccesses = this.getVariableAccessors(isTextOnly);
        String expression = this.getExpression(isTextOnly);
        Object result = this.executeExpression(expression, executionContext, variableAccesses);
        VariableAccess returnVariable = AlfrescoJavaScript.getWritableVariable(variableAccesses);
        if (returnVariable != null) {
            ContextInstance contextInstance = executionContext.getContextInstance();
            Token token = executionContext.getToken();
            contextInstance.setVariable(returnVariable.getVariableName(), result, token);
        }
    }

    private Object executeExpression(String expression, ExecutionContext executionContext, List<VariableAccess> variableAccesses) {
        boolean userChanged = this.checkFullyAuthenticatedUser(executionContext);
        Object result = this.executeScript(expression, executionContext, variableAccesses);
        if (userChanged) {
            AuthenticationUtil.clearCurrentSecurityContext();
        }
        return result;
    }

    private Object executeScript(String expression, ExecutionContext executionContext, List<VariableAccess> variableAccesses) {
        String user = AuthenticationUtil.getFullyAuthenticatedUser();
        if (this.runas == null && user != null) {
            return AlfrescoJavaScript.executeScript(executionContext, this.services, expression, variableAccesses, this.companyHome);
        }
        String runAsUser = this.runas;
        if (runAsUser == null) {
            runAsUser = AuthenticationUtil.getSystemUserName();
        } else {
            this.validateRunAsUser();
        }
        return this.executeScriptAs(runAsUser, expression, executionContext, variableAccesses);
    }

    private Object executeScriptAs(String runAsUser, final String expression, final ExecutionContext executionContext, final List<VariableAccess> variableAccesses) {
        return AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                return AlfrescoJavaScript.executeScript(executionContext, AlfrescoJavaScript.this.services, expression, variableAccesses, AlfrescoJavaScript.this.companyHome);
            }
        }, (String)runAsUser);
    }

    private boolean checkFullyAuthenticatedUser(ExecutionContext executionContext) {
        String userName;
        if (AuthenticationUtil.getFullyAuthenticatedUser() != null) {
            return false;
        }
        TaskInstance taskInstance = executionContext.getTaskInstance();
        if (taskInstance != null && (userName = taskInstance.getActorId()) != null) {
            AuthenticationUtil.setFullyAuthenticatedUser((String)userName);
            return true;
        }
        return false;
    }

    private void validateRunAsUser() {
        Boolean runAsExists = (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                return AlfrescoJavaScript.this.services.getPersonService().personExists(AlfrescoJavaScript.this.runas);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (!runAsExists.booleanValue()) {
            throw new WorkflowException("runas user '" + this.runas + "' does not exist.");
        }
    }

    private String getExpression(boolean isTextOnly) {
        if (isTextOnly) {
            return this.script.getText().trim();
        }
        Element expressionElement = this.script.element("expression");
        if (expressionElement == null) {
            throw new WorkflowException("Script expression has not been provided");
        }
        return expressionElement.getText().trim();
    }

    private List<VariableAccess> getVariableAccessors(boolean isTextOnly) {
        if (isTextOnly) {
            return null;
        }
        return jpdlReader.readVariableAccesses(this.script);
    }

    private boolean isScriptOnlyText() {
        Iterator iter = this.script.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            if (element.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    public static Object executeScript(ExecutionContext context, ServiceRegistry services, String expression, List<VariableAccess> variableAccesses, NodeRef companyHome) {
        Map<String, Object> inputMap = AlfrescoJavaScript.createInputMap(services, companyHome, context, variableAccesses);
        ScriptService scriptService = services.getScriptService();
        scriptService.buildCoreModel(inputMap);
        Object result = scriptService.executeScriptString(expression, inputMap);
        result = AlfrescoJavaScript.convertForJBPM(result, services);
        return result;
    }

    private static Object convertForJBPM(Object value, ServiceRegistry services) {
        if (value == null) {
            return null;
        }
        if (value instanceof NodeRef) {
            value = new JBPMNode((NodeRef)value, services);
        } else if (value instanceof Collection) {
            ArrayList converted;
            Collection collection = (Collection)value;
            boolean isNodeCollection = false;
            for (Object obj : collection) {
                if (!(obj instanceof NodeRef)) continue;
                isNodeCollection = true;
                break;
            }
            if (isNodeCollection) {
                converted = new JBPMNodeList();
                for (Object obj : collection) {
                    if (!(obj instanceof NodeRef)) {
                        throw new WorkflowException("Unable to convert script collection to JBPM value - mixed node/non-node collection");
                    }
                    converted.add((JBPMNode)AlfrescoJavaScript.convertForJBPM(obj, services));
                }
                value = converted;
            } else {
                converted = new ArrayList();
                for (Object obj : collection) {
                    converted.add(AlfrescoJavaScript.convertForJBPM(obj, services));
                }
                value = converted;
            }
        }
        return value;
    }

    private static Map<String, Object> createInputMap(ServiceRegistry services, NodeRef companyHome, ExecutionContext executionContext, List<VariableAccess> variableAccesses) {
        Map<String, Object> inputMap;
        block7: {
            ContextInstance contextInstance;
            Token token;
            block6: {
                TaskInstance taskInstance;
                Task task;
                ScriptService scriptService = services.getScriptService();
                NodeRef person = AlfrescoJavaScript.getPersonNode(services);
                NodeRef userHome = null;
                if (person != null) {
                    NodeService nodeService = services.getNodeService();
                    userHome = (NodeRef)nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER);
                }
                inputMap = scriptService.buildDefaultModel(person, companyHome, userHome, null, null, null);
                token = executionContext.getToken();
                inputMap.put("executionContext", executionContext);
                inputMap.put("token", token);
                Node node = executionContext.getNode();
                if (node != null) {
                    inputMap.put("node", node);
                }
                if ((task = executionContext.getTask()) != null) {
                    inputMap.put("task", task);
                }
                if ((taskInstance = executionContext.getTaskInstance()) != null) {
                    inputMap.put("taskInstance", taskInstance);
                }
                contextInstance = executionContext.getContextInstance();
                if (AlfrescoJavaScript.hasReadableVariable(variableAccesses)) break block6;
                Map variables = contextInstance.getVariables(token);
                if (variables == null) break block7;
                for (Map.Entry entry : variables.entrySet()) {
                    String variableName = (String)entry.getKey();
                    Object variableValue = entry.getValue();
                    inputMap.put(variableName, variableValue);
                }
                break block7;
            }
            for (VariableAccess variableAccess : variableAccesses) {
                if (!variableAccess.isReadable()) continue;
                String variableName = variableAccess.getVariableName();
                String mappedName = variableAccess.getMappedName();
                Object variableValue = contextInstance.getVariable(variableName, token);
                inputMap.put(mappedName, variableValue);
            }
        }
        return inputMap;
    }

    private static NodeRef getPersonNode(ServiceRegistry services) {
        String userName = AuthenticationUtil.getFullyAuthenticatedUser();
        if (userName != null) {
            NodeRef person = services.getPersonService().getPerson(userName);
            return person;
        }
        return null;
    }

    private static boolean hasReadableVariable(List<VariableAccess> variableAccesses) {
        if (variableAccesses != null) {
            for (VariableAccess variableAccess : variableAccesses) {
                if (!variableAccess.isReadable()) continue;
                return true;
            }
        }
        return false;
    }

    private static VariableAccess getWritableVariable(List<VariableAccess> variableAccesses) {
        VariableAccess writable = null;
        if (variableAccesses != null) {
            for (VariableAccess variableAccess : variableAccesses) {
                if (!variableAccess.isWritable()) continue;
                if (writable != null) {
                    throw new WorkflowException("AlfrescoJavaScript supports only one writable variable");
                }
                writable = variableAccess;
            }
        }
        return writable;
    }

    public void setScript(Element script) {
        this.script = script;
    }

    public void setRunas(String runas) {
        this.runas = runas;
    }
}

