/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TransformationOptionLimits;
import org.alfresco.service.cmr.repository.datatype.TypeConverter;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationOptions {
    public static final String OPT_SOURCE_NODEREF = "contentReaderNodeRef";
    public static final String OPT_SOURCE_CONTENT_PROPERTY = "sourceContentProperty";
    public static final String OPT_TARGET_NODEREF = "contentWriterNodeRef";
    public static final String OPT_TARGET_CONTENT_PROPERTY = "targetContentProperty";
    public static final String OPT_INCLUDE_EMBEDDED = "includeEmbedded";
    private NodeRef sourceNodeRef;
    private QName sourceContentProperty;
    private NodeRef targetNodeRef;
    private QName targetContentProperty;
    private Boolean includeEmbedded;
    private TransformationOptionLimits limits = new TransformationOptionLimits();
    public static TypeConverter.Converter<String, Boolean> relaxedBooleanTypeConverter = new TypeConverter.Converter<String, Boolean>(){

        public Boolean convert(String source) {
            if (source == null || source.length() == 0) {
                return null;
            }
            if (source.equalsIgnoreCase("true") || source.equalsIgnoreCase("t") || source.equalsIgnoreCase("yes") || source.equalsIgnoreCase("y")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    };

    public TransformationOptions() {
    }

    public TransformationOptions(NodeRef sourceNodeRef, QName sourceContentProperty, NodeRef targetNodeRef, QName targetContentProperty) {
        this.sourceNodeRef = sourceNodeRef;
        this.sourceContentProperty = sourceContentProperty;
        this.targetNodeRef = targetNodeRef;
        this.targetContentProperty = targetContentProperty;
        this.includeEmbedded = null;
    }

    public TransformationOptions(Map<String, Object> optionsMap) {
        this.set(optionsMap);
    }

    public void set(Map<String, Object> optionsMap) {
        this.sourceNodeRef = (NodeRef)optionsMap.get(OPT_SOURCE_NODEREF);
        this.sourceContentProperty = (QName)optionsMap.get(OPT_SOURCE_CONTENT_PROPERTY);
        this.targetNodeRef = (NodeRef)optionsMap.get(OPT_TARGET_NODEREF);
        this.targetContentProperty = (QName)optionsMap.get(OPT_TARGET_CONTENT_PROPERTY);
        this.includeEmbedded = (Boolean)optionsMap.get(OPT_INCLUDE_EMBEDDED);
        this.limits.set(optionsMap);
    }

    public void setSourceNodeRef(NodeRef sourceNodeRef) {
        this.sourceNodeRef = sourceNodeRef;
    }

    public NodeRef getSourceNodeRef() {
        return this.sourceNodeRef;
    }

    public void setSourceContentProperty(QName sourceContentProperty) {
        this.sourceContentProperty = sourceContentProperty;
    }

    public QName getSourceContentProperty() {
        return this.sourceContentProperty;
    }

    public void setTargetNodeRef(NodeRef targetNodeRef) {
        this.targetNodeRef = targetNodeRef;
    }

    public NodeRef getTargetNodeRef() {
        return this.targetNodeRef;
    }

    public void setTargetContentProperty(QName targetContentProperty) {
        this.targetContentProperty = targetContentProperty;
    }

    public QName getTargetContentProperty() {
        return this.targetContentProperty;
    }

    public void setIncludeEmbedded(Boolean includeEmbedded) {
        this.includeEmbedded = includeEmbedded;
    }

    public Boolean getIncludeEmbedded() {
        return this.includeEmbedded;
    }

    public long getTimeoutMs() {
        return this.limits.getTimeoutMs();
    }

    public void setTimeoutMs(long timeoutMs) {
        this.limits.setTimeoutMs(timeoutMs);
    }

    public long getReadLimitTimeMs() {
        return this.limits.getReadLimitTimeMs();
    }

    public void setReadLimitTimeMs(long readLimitTimeMs) {
        this.limits.setReadLimitTimeMs(readLimitTimeMs);
    }

    public long getMaxSourceSizeKBytes() {
        return this.limits.getMaxSourceSizeKBytes();
    }

    public void setMaxSourceSizeKBytes(long maxSourceSizeKBytes) {
        this.limits.setMaxSourceSizeKBytes(maxSourceSizeKBytes);
    }

    public long getReadLimitKBytes() {
        return this.limits.getReadLimitKBytes();
    }

    public void setReadLimitKBytes(long readLimitKBytes) {
        this.limits.setReadLimitKBytes(readLimitKBytes);
    }

    public int getMaxPages() {
        return this.limits.getMaxPages();
    }

    public void setMaxPages(int maxPages) {
        this.limits.setMaxPages(maxPages);
    }

    public int getPageLimit() {
        return this.limits.getPageLimit();
    }

    public void setPageLimit(int pageLimit) {
        this.limits.setPageLimit(pageLimit);
    }

    public TransformationOptionLimits getLimits() {
        return this.limits;
    }

    public void setLimits(TransformationOptionLimits limits) {
        this.limits = limits;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> optionsMap = new HashMap<String, Object>(7);
        optionsMap.put(OPT_SOURCE_NODEREF, this.sourceNodeRef);
        optionsMap.put(OPT_SOURCE_CONTENT_PROPERTY, this.sourceContentProperty);
        optionsMap.put(OPT_TARGET_NODEREF, this.targetNodeRef);
        optionsMap.put(OPT_TARGET_CONTENT_PROPERTY, this.targetContentProperty);
        optionsMap.put(OPT_INCLUDE_EMBEDDED, this.includeEmbedded);
        this.limits.toMap(optionsMap);
        return optionsMap;
    }

    public String toString(boolean includeLimits) {
        Map<String, Object> map = this.toMap();
        if (!includeLimits) {
            TransformationOptionLimits.removeFromMap(map);
        }
        return map.toString();
    }

    public String toString() {
        return this.toMap().toString();
    }
}

