/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.workflow;

import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTimer;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface WorkflowService {
    @Auditable(parameters={"engineId", "workflowDefinition", "mimetype"}, recordable={true, false, true})
    public WorkflowDeployment deployDefinition(String var1, InputStream var2, String var3);

    @Auditable(parameters={"engineId", "workflowDefinition", "mimetype", "name"}, recordable={true, false, true, true})
    public WorkflowDeployment deployDefinition(String var1, InputStream var2, String var3, String var4);

    @Auditable(parameters={"workflowDefinition"})
    public WorkflowDeployment deployDefinition(NodeRef var1);

    @Auditable(parameters={"definitionContent"})
    public boolean isDefinitionDeployed(NodeRef var1);

    @Auditable(parameters={"engineId", "workflowDefinition", "mimetype"}, recordable={true, false, true})
    public boolean isDefinitionDeployed(String var1, InputStream var2, String var3);

    @Auditable(parameters={"workflowDefinitionId"})
    public void undeployDefinition(String var1);

    @Auditable
    public List<WorkflowDefinition> getDefinitions();

    @Auditable
    public List<WorkflowDefinition> getAllDefinitions();

    @Auditable(parameters={"workflowDefinitionId"})
    public WorkflowDefinition getDefinitionById(String var1);

    @Auditable(parameters={"workflowName"})
    public WorkflowDefinition getDefinitionByName(String var1);

    @Auditable(parameters={"workflowName"})
    public List<WorkflowDefinition> getAllDefinitionsByName(String var1);

    @Auditable(parameters={"workflowDefinitionId"})
    public byte[] getDefinitionImage(String var1);

    @Auditable(parameters={"workflowDefinitionId"})
    public List<WorkflowTaskDefinition> getTaskDefinitions(String var1);

    @Auditable(parameters={"workflowDefinitionId", "parameters"})
    public WorkflowPath startWorkflow(String var1, Map<QName, Serializable> var2);

    @Auditable(parameters={"templateDefinition"})
    public WorkflowPath startWorkflowFromTemplate(NodeRef var1);

    @Auditable(parameters={"workflowDefinitionId"})
    public List<WorkflowInstance> getActiveWorkflows(String var1);

    @Auditable(parameters={"workflowDefinitionId"})
    public List<WorkflowInstance> getCompletedWorkflows(String var1);

    @Auditable(parameters={"workflowDefinitionId"})
    public List<WorkflowInstance> getWorkflows(String var1);

    @Auditable
    public List<WorkflowInstance> getActiveWorkflows();

    @Auditable
    public List<WorkflowInstance> getCompletedWorkflows();

    public List<WorkflowInstance> getWorkflows();

    @Auditable(parameters={"workflowId"})
    public WorkflowInstance getWorkflowById(String var1);

    @Auditable(parameters={"workflowId"})
    public List<WorkflowPath> getWorkflowPaths(String var1);

    @Auditable(parameters={"pathId"})
    public Map<QName, Serializable> getPathProperties(String var1);

    @Auditable(parameters={"workflowId"})
    public WorkflowInstance cancelWorkflow(String var1);

    @Auditable(parameters={"workflowId"})
    public WorkflowInstance deleteWorkflow(String var1);

    @Auditable(parameters={"pathId", "transitionId"})
    public WorkflowPath signal(String var1, String var2);

    @Auditable(parameters={"pathId", "event"})
    public WorkflowPath fireEvent(String var1, String var2);

    @Auditable(parameters={"pathId"})
    public List<WorkflowTask> getTasksForWorkflowPath(String var1);

    @Auditable(parameters={"pathId"})
    public WorkflowTask getStartTask(String var1);

    @Auditable(parameters={"workflowInstanceId"})
    public boolean hasWorkflowImage(String var1);

    @Auditable(parameters={"workflowInstanceId"})
    public InputStream getWorkflowImage(String var1);

    @Auditable(parameters={"workflowId"})
    public List<WorkflowTimer> getTimers(String var1);

    @Auditable(parameters={"taskId"})
    public WorkflowTask getTaskById(String var1);

    @Auditable(parameters={"authority", "state"})
    public List<WorkflowTask> getAssignedTasks(String var1, WorkflowTaskState var2);

    @Auditable(parameters={"authority"})
    public List<WorkflowTask> getPooledTasks(String var1);

    @Auditable(parameters={"query"})
    public List<WorkflowTask> queryTasks(WorkflowTaskQuery var1);

    @Auditable(parameters={"taskId", "properties", "add", "remove"})
    public WorkflowTask updateTask(String var1, Map<QName, Serializable> var2, Map<QName, List<NodeRef>> var3, Map<QName, List<NodeRef>> var4);

    @Auditable(parameters={"taskId", "transitionId"})
    public WorkflowTask endTask(String var1, String var2);

    @Auditable(parameters={"task", "username"})
    public boolean isTaskEditable(WorkflowTask var1, String var2);

    @Auditable(parameters={"task", "username"})
    public boolean isTaskReassignable(WorkflowTask var1, String var2);

    @Auditable(parameters={"task", "username"})
    public boolean isTaskClaimable(WorkflowTask var1, String var2);

    @Auditable(parameters={"task", "username"})
    public boolean isTaskReleasable(WorkflowTask var1, String var2);

    @Auditable(parameters={"container"})
    public NodeRef createPackage(NodeRef var1);

    @Auditable(parameters={"packageItem", "active"})
    public List<WorkflowInstance> getWorkflowsForContent(NodeRef var1, boolean var2);

    @Auditable(parameters={"packageItem", "active"})
    public List<NodeRef> getPackageContents(String var1);
}

